/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.ruleset.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetFactory;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import ilog.rules.engine.IlrContext;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import java.util.ArrayList;
import java.util.List;
import javax.resource.spi.work.Work;

public final class RulesetParsingWork
implements Work {
    private final LogHandler logger;
    private final XURulesetFactory factory;
    private final IlrXURulesetArchiveInformation archive;
    private final IlrXUContext xuContext;
    private XUException exception;
    private byte state;
    private XURulesetImpl ruleset;
    private final List<Listener> listeners;

    public RulesetParsingWork(IlrXURulesetArchiveInformation archive, XURulesetFactory factory, IlrXUContext xuContext, LogHandler logger) {
        this.factory = factory;
        this.archive = archive;
        this.xuContext = xuContext;
        this.logger = logger;
        this.state = 0;
        this.listeners = new ArrayList<Listener>();
    }

    public IlrXURulesetArchiveInformation getArchive() {
        return this.archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener l) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEnded() {
        List<Listener> list = this.listeners;
        synchronized (list) {
            for (Listener l : this.listeners) {
                l.workEnded(this);
            }
        }
    }

    public byte getState() {
        return this.state;
    }

    public XURulesetImpl getRuleset() {
        return this.ruleset;
    }

    public XUException getException() {
        return this.exception;
    }

    public void release() {
        this.finest(".release");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.state = 1;
            this.finest(".run()");
            this.ruleset = this.factory.createRuleset(this.archive, this.xuContext);
            if (this.ruleset.getCRERuleset() != null) {
                new IlrContext(this.ruleset.getCRERuleset(), true).end();
            }
            this.state = (byte)2;
            this.finest(".run() ends");
        }
        catch (Throwable e) {
            this.state = (byte)3;
            this.exception = e instanceof XUException ? (XUException)e : new XUException(XUMessageCode.ERROR_RULESET_PARSING_WORK_FAILED, new String[]{this.archive.getCanonicalPath().toString()}, e);
            this.logger.severe("XU.ERROR.10009", this.exception, new String[]{this.archive.getCanonicalPath().toString()}, this.xuContext);
        }
        finally {
            this.fireEnded();
        }
    }

    private void finest(String msg) {
        this.logger.finest(this.getClass().getName() + msg);
    }

    public static interface Listener {
        public void workEnded(RulesetParsingWork var1);
    }
}

