/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.ruleset.internal;

import com.ibm.rules.engine.load.XUEngineLoader;
import com.ibm.rules.engine.runtime.EngineDefinition;
import com.ibm.rules.engine.service.EngineService;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.cacache.internal.CACache;
import com.ibm.rules.res.xu.cacache.internal.CACacheException;
import com.ibm.rules.res.xu.cacache.internal.SimpleCACacheImpl;
import com.ibm.rules.res.xu.engine.cre.internal.RulesetParser;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.io.internal.NullPrintWriter;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.CRERulesetImpl;
import com.ibm.rules.res.xu.ruleset.internal.DERulesetImpl;
import com.ibm.rules.res.xu.ruleset.internal.MixedObjectInputStream;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetFactoryListener;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import com.ibm.rules.res.xu.util.internal.MultiplexClassLoader;
import ilog.rules.archive.IlrInternalRulesetArchiveHelper;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.xu.event.IlrProfilingRulesetEvent;
import ilog.rules.bres.xu.event.IlrRulesetEvent;
import ilog.rules.bres.xu.profiling.IlrProfilingHelper;
import ilog.rules.engine.IlrRuleset;
import ilog.rules.factory.IlrPropertyList;
import ilog.rules.factory.IlrReflect;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrDERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRulesetArchiveInformation;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetCreationException;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationMonitorImpl;
import ilog.rules.util.engine.IlrPropertyNames;
import ilog.rules.util.issue.IlrErrorException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;

public final class XURulesetFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final LogHandler log;
    private final IlrXUEventDispatcher evtDispatcher;
    private final IlrProfilingHelper profiling;
    private final List<XURulesetFactoryListener> listeners = new ArrayList<XURulesetFactoryListener>();
    private final Map<String, String> caCacheProps;
    private CACache caCache;
    private final IlrRulesetUsageInformationMonitorImpl monitor;

    public XURulesetFactory(LogHandler log, IlrXUEventDispatcher eventDispatcher, IlrProfilingHelper profiling, Map<String, String> factoryProps, Map<String, String> caCacheProps, IlrRulesetUsageInformationMonitorImpl monitor) {
        this.log = log;
        this.evtDispatcher = eventDispatcher;
        this.profiling = profiling;
        this.caCacheProps = caCacheProps;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExecutableRulesetFactoryListener(XURulesetFactoryListener listener) {
        List<XURulesetFactoryListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XURulesetImpl createRuleset(IlrXURulesetArchiveInformation archive, IlrXUContext xuCtx) throws XUException {
        long stime = System.currentTimeMillis();
        IlrRulesetArchiveProperties props = archive.getProperties();
        IlrEngineType engineType = props.getEngineType();
        IlrPath path = archive.getCanonicalPath();
        this.log.fine(XUMessageCode.INFO_RULESET_ARCHIVE_LOADING, new Object[]{path, engineType}, xuCtx);
        this.log(path.toString(), archive.getProperties(), xuCtx);
        IlrProfilingRulesetEvent evt = this.profiling.startRulesetMeasure(1, archive, xuCtx);
        IlrRulesetUsageInformationImpl usage = this.monitor == null ? null : this.monitor.getRulesetUsageInformationImpl(path.toString(), true);
        XURulesetImpl ruleset = engineType == IlrEngineType.DE ? this.createDERuleset(archive, usage) : this.createCRERuleset(archive, usage);
        IlrRulesetEvent rulesetEvt = new IlrRulesetEvent(0, ruleset, archive, xuCtx);
        this.evtDispatcher.rulesetEventRaised(rulesetEvt);
        this.profiling.stopRulesetMeasure(evt);
        this.profiling.sendRulesetEvent(evt);
        this.log.fine(XUMessageCode.INFO_RULESET_ARCHIVE_SUCESS, new Object[]{path, engineType}, xuCtx);
        long duration = System.currentTimeMillis() - stime;
        this.logFinest(".createRuleset(): parsing duration: " + duration, null, xuCtx);
        List<XURulesetFactoryListener> list = this.listeners;
        synchronized (list) {
            for (XURulesetFactoryListener listener : this.listeners) {
                listener.rulesetParsed(path.toString(), archive.getXOMClassLoader(), duration);
            }
        }
        this.log.info(XUMessageCode.INFO_RULESET_PARSING_DURATION, new Object[]{path, duration / 1000L});
        return ruleset;
    }

    protected static final CACache createCACache(Map<String, String> props) throws CACacheException {
        String type = props.get("type");
        if (type == null || type.isEmpty()) {
            return new SimpleCACacheImpl();
        }
        try {
            Class<?> clazz = Class.forName(type);
            return (CACache)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CACacheException(XUMessageCode.ERROR_CA_CACHE_ERROR, e);
        }
        catch (InstantiationException e) {
            throw new CACacheException(XUMessageCode.ERROR_CA_CACHE_ERROR, e);
        }
        catch (IllegalAccessException e) {
            throw new CACacheException(XUMessageCode.ERROR_CA_CACHE_ERROR, e);
        }
    }

    private final synchronized CACache getCACache() throws CACacheException {
        if (this.caCache == null && this.caCacheProps != null && !this.caCacheProps.isEmpty()) {
            CACache cache = XURulesetFactory.createCACache(this.caCacheProps);
            cache.setLogger(this.log.getLogger());
            cache.initialize(this.caCacheProps);
            this.caCache = cache;
        }
        return this.caCache;
    }

    private static final String getId(IlrRulesetArchiveInformation archive) {
        return (String)archive.getProperties().get("ruleset.uuid");
    }

    private final XURulesetImpl createDERuleset(IlrXURulesetArchiveInformation info, IlrRulesetUsageInformationImpl usage) throws IlrRulesetCreationException {
        IlrRulesetArchiveProperties props = info.getProperties();
        String canonicalPath = info.getCanonicalPath().toString();
        IlrDERulesetArchive archive = (IlrDERulesetArchive)info.getRESRulesetArchive();
        ClassLoader xomCL = info.getXOMClassLoader();
        ClassLoader rxom = info.getManagedXOMClassLoader();
        if (rxom == null) {
            rxom = xomCL;
        }
        InputStream input = null;
        XUEngineLoader.Output out = null;
        String id = null;
        ByteArrayOutputStream baos = null;
        try {
            DERulesetImpl ruleset;
            String type;
            CACache cache = this.getCACache();
            try {
                if (cache != null && (id = XURulesetFactory.getId(info)) != null) {
                    input = cache.get(id);
                }
            }
            catch (CACacheException e) {
                this.log.severe(XUMessageCode.ERROR_CA_CACHE_ERROR, e, null, null);
            }
            if (input == null) {
                input = archive.getContentStream();
                baos = new ByteArrayOutputStream();
                out = new XUEngineLoader.Output((OutputStream)baos);
                type = props.isDebugEnabled() ? "com.ibm.rules.engine.de.dsar.debug" : "com.ibm.rules.engine.de.dsar";
            } else {
                this.logFinest(".createDERuleset: has been loaded from CA cache");
                out = new XUEngineLoader.Output(null);
                type = props.isDebugEnabled() ? "com.ibm.rules.engine.de.jar.debug" : "com.ibm.rules.engine.de.jar";
            }
            this.logFinest(".createDERuleset: loading mode: " + type, null, null);
            EngineService[] services = new EngineService[]{};
            EngineDefinition def = XUEngineLoader.createEngineDefinition((String)type, (InputStream)input, (ClassLoader)rxom, (XUEngineLoader.Output)out, (Map)props, (EngineService[])services);
            if (cache != null && baos != null && out.isChanged()) {
                this.logFinest(".createDERuleset: DE bytecode generated.");
                try {
                    if (id == null) {
                        id = XURulesetFactory.getId(info);
                    }
                    if (id != null) {
                        cache.put(id, new ByteArrayInputStream(baos.toByteArray()));
                    }
                }
                catch (CACacheException e) {
                    this.log.severe(XUMessageCode.ERROR_CA_CACHE_ERROR, e, null, null);
                }
            }
            DERulesetImpl e = ruleset = new DERulesetImpl(def, canonicalPath, props, xomCL, info, null, this.log, usage);
            return e;
        }
        catch (CACacheException e) {
            throw new IlrRulesetCreationException("XU.ERROR.10009", new String[]{canonicalPath}, (Throwable)e);
        }
        catch (IlrErrorException e) {
            throw new IlrRulesetCreationException("XU.ERROR.10009", new String[]{canonicalPath}, (Throwable)e);
        }
        catch (XUEngineLoader.CreationException e) {
            throw new IlrRulesetCreationException("XU.ERROR.10009", new String[]{canonicalPath}, (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            if (out != null && out.getOutputStream() != null) {
                try {
                    out.getOutputStream().close();
                }
                catch (IOException e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private final XURulesetImpl createCRERuleset(IlrXURulesetArchiveInformation info, IlrRulesetUsageInformationImpl usage) throws IlrRulesetCreationException, XUException {
        IlrReflect reflect;
        IlrRuleset ruleset;
        IlrRulesetArchiveProperties props = info.getProperties();
        String canonicalPath = info.getCanonicalPath().toString();
        IlrRulesetArchive archive = ((IlrCRERulesetArchive)info.getRESRulesetArchive()).getRulesetArchive();
        ClassLoader xomCL = info.getXOMClassLoader();
        this.logFinest(".createCRERuleset: path:" + canonicalPath + " mxom:" + info.getManagedXOMClassLoader());
        if (info.getManagedXOMClassLoader() != null) {
            xomCL = info.getManagedXOMClassLoader();
        }
        if (xomCL == null) {
            this.logFinest(".createCRERuleset: creates ruleset " + canonicalPath + " without reflect");
            ruleset = new IlrRuleset();
            reflect = null;
        } else {
            this.logFinest(".createCRERuleset: creates ruleset reflect " + canonicalPath + " with XOM CL: " + xomCL);
            reflect = new IlrReflect();
            reflect.setClassLoader(xomCL);
            ruleset = new IlrRuleset(reflect);
        }
        ruleset.setMessageWriter(NullPrintWriter.getSingleton());
        this.setCRERulesetProperties(ruleset, props);
        ArrayList<String> warnings = new ArrayList<String>();
        ruleset = RulesetParser.parseArchive(canonicalPath, ruleset, props, reflect, xomCL, archive, warnings, this.log.getLogger());
        CRERulesetImpl execRuleset = new CRERulesetImpl(ruleset, canonicalPath, props, xomCL, info, warnings, this.log, usage);
        this.sendRulesetWarnings(execRuleset);
        return execRuleset;
    }

    private final void setCRERulesetProperties(IlrRuleset ruleset, IlrRulesetArchiveProperties rulesetProperties) {
        int i;
        if (rulesetProperties.isSequentialTraceEnabled()) {
            ruleset.getProperties().put("ilog.rules.engine.sequential.debug", (Object)new Boolean(true));
        }
        String[] sequentialTracedTasks = rulesetProperties.getSequentialTracedTasks();
        for (i = 0; i < sequentialTracedTasks.length; ++i) {
            ruleset.getProperties().put("ilog.rules.engine.sequential.debug." + sequentialTracedTasks[i], (Object)new Boolean(true));
        }
        for (i = 0; i < IlrPropertyNames.AllNames.length; ++i) {
            String name = IlrPropertyNames.AllNames[i];
            Class type = IlrPropertyNames.AllTypes[i];
            String value = (String)rulesetProperties.get(name);
            IlrPropertyList propertyList = ruleset.getProperties();
            if (value == null) continue;
            if (type.equals(Boolean.TYPE)) {
                propertyList.putBoolean(name, Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (type.equals(String.class)) {
                propertyList.putString(name, value);
                continue;
            }
            propertyList.put(name, (Object)value);
        }
    }

    private final void log(String canonicalPath, IlrRulesetArchiveProperties props, IlrXUContext xuCtx) {
        this.logFinest(".createRuleset.canonicalRulesetPath", new Object[]{canonicalPath}, xuCtx);
        for (String key : props.keySet()) {
            this.logFinest(".createRuleset.rulesetProperty", new Object[]{key, props.get(key)}, xuCtx);
        }
    }

    private void logFinest(String msg) {
        this.logFinest(msg, null, null);
    }

    private void logFinest(String msg, Object[] params, IlrXUContext ctx) {
        this.log.finest(this.getClass().getName() + msg, params, ctx);
    }

    static final void writeCRERuleset(IlrRuleset ruleset, OutputStream out) throws XUException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(out);
            oos.writeObject(ruleset);
        }
        catch (IOException e) {
            XUException ex = new XUException();
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final IlrRuleset readCRERuleset(InputStream in, ClassLoader xomClassLoader) throws ResourceException, IOException, ClassNotFoundException, XUException {
        MultiplexClassLoader mixedClassLoader = new MultiplexClassLoader(xomClassLoader, XURulesetFactory.class.getClassLoader());
        ObjectInputStream ois = null;
        try {
            ois = new MixedObjectInputStream(new BufferedInputStream(in, 32000), mixedClassLoader);
            IlrRuleset ruleset = (IlrRuleset)ois.readObject();
            ruleset.getReflect().setClassLoader((ClassLoader)mixedClassLoader);
            IlrRuleset ilrRuleset = ruleset;
            return ilrRuleset;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void sendRulesetWarnings(CRERulesetImpl ruleset) {
        String canonicalPath = ruleset.getCanonicalRulesetPath();
        Collection<String> warns = ruleset.getWarnings();
        if (warns != null) {
            for (String warn : warns) {
                this.log.warning(XUMessageCode.WARNING_RULESET_PARSING, null, new Object[]{canonicalPath, warn}, canonicalPath, null, true);
            }
        }
        IlrCRERulesetArchive creArchive = (IlrCRERulesetArchive)ruleset.getArchive().getRESRulesetArchive();
        IlrRulesetArchive archive = creArchive.getRulesetArchive();
        int major = IlrInternalRulesetArchiveHelper.getMajorVersion((IlrRulesetArchive)archive);
        int minor = IlrInternalRulesetArchiveHelper.getMinorVersion((IlrRulesetArchive)archive);
        int jrulesMajor = 8;
        int jrulesMinor = 7;
        if (major > jrulesMajor || major == jrulesMajor && minor > jrulesMinor) {
            this.log.warning(XUMessageCode.WARNING_NEWER_RULESET_ARCHIVE_VERSION, null, new Object[]{jrulesMajor + "." + jrulesMinor, major + "." + minor}, canonicalPath, null, true);
        }
    }
}

