/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.spi.config.internal;

import com.ibm.rules.res.xu.config.internal.PoolConfig;
import com.ibm.rules.res.xu.internal.XUException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SPIPoolConfigImpl
implements PoolConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> properties = new HashMap<String, String>(2);
    private final long defaultWaitTimeout;

    public SPIPoolConfigImpl(long defaultWaitTimeout) {
        this.defaultWaitTimeout = defaultWaitTimeout;
    }

    @Override
    public int getMaxSize() throws XUException {
        String str = this.properties.get("pool.maxSize");
        if (str == null || str.isEmpty()) {
            return 10;
        }
        return Integer.parseInt(str);
    }

    @Override
    public void setMaxSize(int size) throws XUException {
        this.properties.put("pool.maxSize", Long.toString(size));
    }

    @Override
    public long getWaitTimeout() throws XUException {
        String str = this.properties.get("pool.waitTimeout");
        if (str == null || str.isEmpty()) {
            return this.defaultWaitTimeout;
        }
        return Long.parseLong(str);
    }

    @Override
    public void setWaitTimeout(long t) throws XUException {
        this.properties.put("pool.waitTimeout", Long.toString(t));
    }

    @Override
    public Map<String, String> toMap() throws XUException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.properties);
        if (!this.properties.containsKey("pool.waitTimeout")) {
            result.put("pool.waitTimeout", Long.toString(this.defaultWaitTimeout));
        }
        if (!this.properties.containsKey("pool.maxSize")) {
            result.put("pool.maxSize", Long.toString(10L));
        }
        return result;
    }

    @Override
    public void putProperty(String k, String v) throws XUException {
        this.properties.put(k, v);
    }

    @Override
    public void setProperties(Map<String, String> props) throws XUException {
        this.properties.clear();
        this.properties.putAll(props);
    }

    protected String getProperty(String k) throws XUException {
        return this.properties.get(k);
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SPIPoolConfigImpl) {
            return ((Object)this.properties).equals(((SPIPoolConfigImpl)o).properties);
        }
        return false;
    }
}

