/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.spi.internal;

import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.cci.IlrXUConnection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class XUConnectionWeakSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<IlrConnectionId, WeakReference<IlrXUConnection>> connections = new HashMap<IlrConnectionId, WeakReference<IlrXUConnection>>();
    protected int count;

    public synchronized void add(IlrXUConnection connection) {
        IlrConnectionId id = connection.getId();
        if (this.connections.get(id) == null) {
            this.connections.put(id, new WeakReference<IlrXUConnection>(connection));
        }
        this.garbage();
    }

    public synchronized IlrXUConnection get(Serializable connectionId) {
        Iterator<WeakReference<IlrXUConnection>> it = this.connections.values().iterator();
        while (it.hasNext()) {
            WeakReference<IlrXUConnection> ref = it.next();
            IlrXUConnection conn = (IlrXUConnection)ref.get();
            if (conn == null) {
                it.remove();
                continue;
            }
            if (!conn.getId().equals(connectionId)) continue;
            return conn;
        }
        return null;
    }

    private final void garbage() {
        ++this.count;
        if (this.count > 5000 && this.connections.size() > 5000) {
            this.count = 0;
            Iterator<WeakReference<IlrXUConnection>> it = this.connections.values().iterator();
            while (it.hasNext()) {
                WeakReference<IlrXUConnection> ref = it.next();
                if (ref.get() != null) continue;
                it.remove();
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.connections = new HashMap<IlrConnectionId, WeakReference<IlrXUConnection>>();
    }

    public final synchronized void dump(XUInfoImpl dump) {
        dump.setCCIReconnectionPoolSize(this.connections.size());
    }
}

