/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.spi.internal;

import com.ibm.rules.res.xu.work.internal.PeriodicWorkManager;
import com.ibm.rules.res.xu.work.internal.WorkManagerImpl;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEvent;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public final class XUResourceAdapter
implements ResourceAdapter {
    private final IlrXUEventDispatcher eventDispatcher;
    private transient WorkManager workManager;
    private transient PeriodicWorkManager periodicWorkMgr;
    private final ArrayList<Listener> listeners = new ArrayList();

    public XUResourceAdapter() {
        this.eventDispatcher = new IlrXUEventDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(Listener listener) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    public final IlrXUEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        this.eventDispatcher.setMask(1L);
        if (ctx.getWorkManager() == null) {
            this.workManager = new WorkManagerImpl(null);
        }
        this.workManager = ctx.getWorkManager() instanceof WorkManagerImpl ? ctx.getWorkManager() : new WorkManagerImpl(ctx.getWorkManager());
        this.periodicWorkMgr = new PeriodicWorkManager(ctx);
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (Listener l : this.listeners) {
                l.resourceAdapterStarted(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (this.workManager != null && this.workManager instanceof WorkManagerImpl) {
            ((WorkManagerImpl)this.workManager).stop();
        }
        if (this.periodicWorkMgr != null) {
            this.periodicWorkMgr.stop();
        }
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (Listener l : this.listeners) {
                l.resourceAdapterStopped(this);
            }
        }
    }

    public final void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        throw new NotSupportedException();
    }

    public final void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
    }

    public final XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return null;
    }

    public final WorkManager getWorkManager() {
        return this.workManager;
    }

    public final void notifyRulesetArchiveChanged(String canonicalRulesetPath, IlrXUContext ctx) {
        IlrRulesetArchiveEvent evt = new IlrRulesetArchiveEvent(1, canonicalRulesetPath.toString(), ctx);
        this.getEventDispatcher().changePerformed(evt);
    }

    public final void notifyRulesetArchiveChanged(IlrPath canonicalRulesetPath, IlrXUContext ctx) {
        this.notifyRulesetArchiveChanged(canonicalRulesetPath.toString(), ctx);
    }

    public final synchronized PeriodicWorkManager getPeriodicWorkManager() {
        return this.periodicWorkMgr;
    }

    public final String getVersion() {
        int major = 8;
        int minor = 7;
        int update = 1;
        int fixPack = 0;
        int build = 1;
        return major + "." + minor + "." + update + "." + fixPack + "." + build;
    }

    public int hashCode() {
        int major = 8;
        int minor = 7;
        int update = 1;
        int fixPack = 0;
        int build = 1;
        return major + minor + update + fixPack + build;
    }

    public boolean equals(Object o) {
        if (o instanceof XUResourceAdapter) {
            return true;
        }
        Class<?> clazz = o.getClass();
        if (clazz.getName() == null || !clazz.getName().equals(this.getClass().getName())) {
            return false;
        }
        try {
            Method m = clazz.getMethod("getVersion", new Class[0]);
            return m.invoke(o, new Object[0]).equals(this.getVersion());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static interface Listener {
        public void resourceAdapterStarted(XUResourceAdapter var1);

        public void resourceAdapterStopped(XUResourceAdapter var1);
    }
}

