/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest;

import com.ibm.rules.rest.Converter;
import com.ibm.rules.rest.DocumentationProvider;
import com.ibm.rules.rest.RESTActionResult;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.RESTServiceConsumer;
import com.ibm.rules.rest.annotation.ActionResultType;
import com.ibm.rules.rest.annotation.Consumes;
import com.ibm.rules.rest.annotation.Doc;
import com.ibm.rules.rest.annotation.Path;
import com.ibm.rules.rest.annotation.PathParam;
import com.ibm.rules.rest.annotation.Produces;
import com.ibm.rules.rest.annotation.QueryParam;
import com.ibm.rules.rest.annotation.RESTResource;
import com.ibm.rules.rest.annotation.RegExp;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Action {
    private final Object bean;
    private final Method method;
    private List<Parameter> parameters;
    private Class<?> expectedClass;
    private final RESTServiceConsumer service;
    private String htmlDocCode;
    private ReturnType requestType;
    private Class<?> requestClass;
    private String requestClassHtmlDocCode;
    private ReturnType returnType;
    private Class<?> returnClass;
    private String[] produces;
    private Class<?> actionResultClass;
    private String version;
    private String since;
    private int priority;
    private String resource;
    public String[] consumes;

    public Action(Object bean, Method method, RESTServiceConsumer service) {
        this.bean = bean;
        this.method = method;
        this.service = service;
        this.extractParameters();
    }

    public String[] getConsumes() {
        return this.consumes;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public Object invoke(RESTContext context, Map<String, String> parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, UnsupportedEncodingException {
        Annotation[][] paramsAnnos = this.method.getParameterAnnotations();
        Object[] args = new Object[paramsAnnos.length];
        for (int i = 0; i < args.length; ++i) {
            Annotation[] annos = paramsAnnos[i];
            args[i] = this.extractValue(this.method.getParameterTypes()[i], annos, context, parameters);
        }
        return this.method.invoke(this.bean, args);
    }

    private void extractParameters() {
        Produces prod;
        Consumes cons;
        ActionResultType art;
        RESTResource v = this.method.getDeclaringClass().getAnnotation(RESTResource.class);
        if (v != null) {
            this.version = v.version();
            this.since = v.since();
            this.resource = v.name();
            this.priority = v.priority();
        }
        if ((art = this.method.getAnnotation(ActionResultType.class)) != null) {
            this.actionResultClass = art.value();
        }
        if ((cons = this.method.getAnnotation(Consumes.class)) != null) {
            this.consumes = cons.value();
        }
        if ((prod = this.method.getAnnotation(Produces.class)) != null) {
            this.produces = prod.value();
        }
        Class<?> returnClass = this.method.getReturnType();
        Path pathAnno = this.method.getAnnotation(Path.class);
        Doc docAnno = this.method.getAnnotation(Doc.class);
        this.returnClass = returnClass;
        this.returnType = RESTCollection.class.isAssignableFrom(returnClass) ? ReturnType.BEAN_ARRAY : ReturnType.BEAN;
        if (docAnno != null) {
            this.htmlDocCode = docAnno.value();
        }
        Annotation[][] paramsAnnos = this.method.getParameterAnnotations();
        for (int i = 0; i < paramsAnnos.length; ++i) {
            Class<?> parameter = this.method.getParameterTypes()[i];
            if (RESTContext.class.equals(parameter)) continue;
            Annotation[] annos = paramsAnnos[i];
            Parameter param = new Parameter(this.service.getDocumentationProvider());
            boolean bodyParam = true;
            String htmlDocCode = null;
            for (int j = 0; j < annos.length; ++j) {
                if (annos[j].annotationType().equals(PathParam.class)) {
                    param.name = ((PathParam)annos[j]).value();
                    bodyParam = false;
                }
                if (annos[j].annotationType().equals(QueryParam.class)) {
                    param.name = ((QueryParam)annos[j]).value();
                    param.query = true;
                    bodyParam = false;
                }
                if (annos[j].annotationType().equals(Doc.class)) {
                    htmlDocCode = param.htmlDocCode = ((Doc)annos[j]).value();
                }
                if (!annos[j].annotationType().equals(RegExp.class)) continue;
                param.regexp = ((RegExp)annos[j]).value();
            }
            if (bodyParam) {
                this.requestClass = parameter;
                this.requestClassHtmlDocCode = htmlDocCode;
                if (byte[].class.equals(parameter)) {
                    this.requestType = ReturnType.BYTE_ARRAY;
                    continue;
                }
                this.requestType = ReturnType.BEAN;
                continue;
            }
            if (param.getName() == null) continue;
            if (this.parameters == null) {
                this.parameters = new ArrayList<Parameter>();
            }
            this.parameters.add(param);
        }
    }

    private Object extractValue(Class argClass, Annotation[] annos, RESTContext context, Map<String, String> parameters) throws UnsupportedEncodingException {
        String key = null;
        boolean query = false;
        for (int i = 0; i < annos.length; ++i) {
            if (annos[i].annotationType().equals(PathParam.class)) {
                key = ((PathParam)annos[i]).value();
                break;
            }
            if (!annos[i].annotationType().equals(QueryParam.class)) continue;
            key = ((QueryParam)annos[i]).value();
            query = true;
            break;
        }
        if (key != null) {
            if (query) {
                return context.getParameters().get(key);
            }
            return parameters.get(key);
        }
        if (argClass.equals(RESTContext.class)) {
            return context;
        }
        if (argClass.equals(byte[].class)) {
            return context.getBody();
        }
        if (this.expectedClass == null) {
            Class<?>[] classes;
            for (Class<?> clazz : classes = this.method.getParameterTypes()) {
                if (clazz.equals(String.class) || clazz.equals(byte[].class) || clazz.equals(RESTContext.class)) continue;
                this.expectedClass = clazz;
                break;
            }
        }
        Object incomingObject = null;
        incomingObject = this.expectedClass != null ? context.computeIncomingObject(this.expectedClass, this.service.getReader(context.getConverterIn().getFormat())) : new String(context.getBody(), context.getCharacterEncoding());
        if (incomingObject == null) {
            return null;
        }
        if (argClass.isAssignableFrom(incomingObject.getClass())) {
            return incomingObject;
        }
        return null;
    }

    public String getPublicName() {
        return this.method.getName();
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getHTMLDocCode() {
        return this.htmlDocCode;
    }

    public String getDescription(Locale locale) {
        if (this.htmlDocCode == null) {
            return null;
        }
        if (this.service.getDocumentationProvider() == null) {
            return null;
        }
        LinkedList<String> args = new LinkedList<String>();
        if (this.parameters != null) {
            for (Parameter param : this.parameters) {
                args.add(param.name);
            }
        }
        return this.service.getDocumentationProvider().getLocalizedMessage(locale, this.htmlDocCode, args.toArray(new String[args.size()]));
    }

    public ReturnType getRequestType() {
        return this.requestType;
    }

    public Class<?> getRequestClass() {
        return this.requestClass;
    }

    public String getRequestClassHtmlDocCode() {
        return this.requestClassHtmlDocCode;
    }

    public String getRequestClassDescription(Locale locale) {
        if (this.htmlDocCode == null) {
            return null;
        }
        if (this.service.getDocumentationProvider() == null) {
            return null;
        }
        return this.service.getDocumentationProvider().getLocalizedMessage(locale, this.requestClassHtmlDocCode, new String[0]);
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public Class<?> getActionResultClass() {
        return this.actionResultClass;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String toString() {
        return this.method.toGenericString().replaceAll("com\\.ibm\\.rules\\.res\\.model\\.rest\\.service\\.internal\\.", "").replaceAll("com\\.ibm\\.rules\\.res\\.model\\.rest\\.internal\\.", "");
    }

    public static String getFieldRepresentation(Class<?> clazz, Class<?> actionResultClass, Converter reader, String fieldName, Locale locale) {
        Field field;
        if (clazz == null) {
            return null;
        }
        try {
            field = clazz.getField(fieldName);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        if (field != null) {
            Object value;
            try {
                value = field.get(null);
            }
            catch (Exception e) {
                return null;
            }
            try {
                if (clazz.equals(RESTActionResult.class) && "DEFAULT_OUT_INSTANCE".equals(fieldName) && actionResultClass != null) {
                    clazz.getMethod("setResource", Object.class).invoke(value, actionResultClass.getField(fieldName).get(null));
                }
                if (clazz.equals(RESTActionResult.class) && "DEFAULT_OUT_INSTANCE".equals(fieldName) && actionResultClass == null) {
                    clazz.getMethod("setResource", Object.class).invoke(value, new Object[]{null});
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            RESTContext context = new RESTContext();
            context.setIso8601dateFormat(true);
            context.setLocale(locale);
            StringWriter writer = new StringWriter();
            reader.toFormat(writer, value, context);
            String result = writer.toString();
            int start = -1;
            while ((start = result.indexOf("@@")) != -1) {
                int end = result.indexOf("@@", start + "@@".length());
                String info = result.substring(start + "@@".length(), end);
                String[] bundleAndKey = info.split("#");
                String doc = "{" + ResourceBundle.getBundle(bundleAndKey[0], locale).getString(bundleAndKey[1]) + "}";
                result = result.substring(0, start) + doc + result.substring(end + "@@".length());
            }
            return result;
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public static class Parameter {
        public boolean query = false;
        public String name;
        public String regexp;
        public String htmlDocCode;
        public DocumentationProvider docProvider;

        public Parameter(DocumentationProvider docProvider) {
            this.docProvider = docProvider;
        }

        public List<Option> getOptions(Locale locale) {
            if (this.htmlDocCode == null) {
                return null;
            }
            if (this.docProvider == null) {
                return null;
            }
            LinkedList<Option> result = null;
            int index = 1;
            String name = null;
            while ((name = this.docProvider.getLocalizedMessageWithoutException(locale, this.htmlDocCode + "_OPTION_" + index + "_NAME", new String[0])) != null) {
                if (result == null) {
                    result = new LinkedList<Option>();
                }
                Option option = new Option();
                option.name = name;
                option.doc = this.docProvider.getLocalizedMessageWithoutException(locale, this.htmlDocCode + "_OPTION_" + index + "_DESC", new String[0]);
                if (option.name.endsWith("*")) {
                    option.name = option.name.substring(0, option.name.length() - 1);
                    option.defaultValue = true;
                }
                result.add(option);
                ++index;
            }
            return result;
        }

        public String getName() {
            return this.name;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public String getDescription(Locale locale) {
            if (this.htmlDocCode == null) {
                return null;
            }
            if (this.docProvider == null) {
                return null;
            }
            return this.docProvider.getLocalizedMessage(locale, this.htmlDocCode, new String[0]);
        }

        public static class Option {
            public boolean defaultValue;
            public String name;
            public String doc;
        }
    }

    public static enum ReturnType {
        NOT_SPECIFIED,
        BEAN,
        BEAN_ARRAY,
        INT,
        BYTE_ARRAY;

    }
}

