/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class HTTPError
extends Error {
    private static final long serialVersionUID = 1L;
    private int code;
    private String description;
    private String body;

    public HTTPError(int code, String description, String body) {
        this.code = code;
        this.description = description;
        this.body = body;
    }

    public HTTPError(int code, Exception e) {
        this.code = code;
        this.initCause(e);
        this.init(e);
    }

    private void init(Exception exception) {
        try {
            StringWriter softErrorMessage = new StringWriter();
            String currentMessage = exception.getMessage();
            Throwable currentException = exception;
            while (currentMessage == null && currentException.getCause() != null) {
                currentException = currentException.getCause();
                currentMessage = currentException.getMessage();
            }
            softErrorMessage.append(currentMessage).append('\n');
            while (currentException.getCause() != null && currentException.getCause() != currentException) {
                if ((currentException = currentException.getCause()).getMessage() == null || currentMessage.contains(currentException.getMessage())) continue;
                currentMessage = currentException.getMessage();
                softErrorMessage.append(currentException.getMessage()).append('\n');
            }
            softErrorMessage.close();
            this.description = softErrorMessage.toString();
            StringWriter stackErrorMessage = new StringWriter();
            PrintWriter pw = new PrintWriter(stackErrorMessage);
            exception.printStackTrace(pw);
            pw.close();
            stackErrorMessage.close();
            this.body = stackErrorMessage.toString();
        }
        catch (IOException e) {
            this.description = e.getLocalizedMessage();
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBody() {
        return this.body;
    }
}

