/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest;

import com.ibm.rules.res.util.internal.HTTPTransparentNegociation;
import com.ibm.rules.res.util.internal.RESTUtil;
import com.ibm.rules.res.util.internal.StreamUtil;
import com.ibm.rules.res.xml.internal.XSD;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.RESTServiceBinding;
import com.ibm.rules.rest.RESTServiceConsumer;
import com.ibm.rules.rest.UnknowPathException;
import com.ibm.rules.rest.io.RESTRequest;
import com.ibm.rules.rest.io.RESTRequestMultipartParser;
import com.ibm.rules.rest.io.RESTResponse;
import com.ibm.rules.rest.io.WADLBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.fileupload.FileUploadException;
import org.w3c.dom.Element;

public class RESTFacade {
    private static final Pattern PATTERN_BINDING = Pattern.compile("(/v1)?(/(json|xml))?(/.*)?");
    private final Map<String, RESTServiceBinding> context2binding;
    private final RESTServiceBinding defaultBinding;
    private final String wadlFileName;
    private transient RESTServiceConsumer service;
    private WADLBuilder wadlBuilder;
    private WADLBuilder wadlBuilderHTML;
    private WADLBuilder wadlBuilderInline;
    private final String wadlDefaultNS;
    private final RESTRequestMultipartParser multipartParser = new RESTRequestMultipartParser();

    public RESTFacade(Map<String, RESTServiceBinding> context2binding, RESTServiceBinding defaultBinding, RESTServiceConsumer service, String wadlFileName, String wadlDefaultNS, String wadlName) {
        this.context2binding = context2binding;
        this.defaultBinding = defaultBinding;
        this.wadlFileName = wadlFileName;
        this.wadlDefaultNS = wadlDefaultNS;
        this.service = service;
        try {
            this.wadlBuilder = new WADLBuilder(wadlFileName, wadlName, wadlDefaultNS, context2binding, RESTUtil.availableLocales, false, false);
            this.wadlBuilderHTML = new WADLBuilder(wadlFileName, wadlName, wadlDefaultNS, context2binding, RESTUtil.availableLocales, true, false);
            this.wadlBuilderInline = new WADLBuilder(wadlFileName, wadlName, wadlDefaultNS, context2binding, RESTUtil.availableLocales, true, true);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doMethod(short method, RESTRequest request, RESTResponse response) throws IOException, UnknowPathException {
        Matcher m;
        String pathInfo;
        InputStream is = request.getInputStream();
        byte[] data = null;
        if (is != null) {
            data = StreamUtil.toByteArray(is);
        }
        if ((pathInfo = request.getPathInfo()) == null) {
            pathInfo = "";
        }
        if (!(m = PATTERN_BINDING.matcher(pathInfo)).matches() || pathInfo.length() == 0) {
            throw new UnknowPathException();
        }
        String version = "v1";
        if (m.group(1) != null) {
            version = m.group(1).substring(1);
        }
        RESTServiceBinding inputBinding = this.getBinding(request, m.group(3), "Content-Type", "format", false, this.defaultBinding);
        RESTServiceBinding outputBinding = this.getBinding(request, m.group(3), "Accept", "accept", true, inputBinding);
        Locale locale = this.getLocale(request, true, Locale.ENGLISH);
        method = RESTFacade.getMethod(method, request);
        if (m.group(4) != null && m.group(4).toLowerCase().startsWith("/" + this.wadlFileName.toLowerCase())) {
            String[] tokens = m.group(4).split("/");
            if (tokens.length == 2) {
                this.sendWADL(request, response, version, locale);
                return;
            } else {
                try {
                    this.service.getServiceDescription(this.wadlBuilder, locale);
                    XSD xsd = this.wadlBuilder.getXSDs().get(tokens[2]);
                    if (xsd == null) return;
                    response.setContentType("application/xml");
                    TransformerFactory transfac = TransformerFactory.newInstance();
                    Transformer trans = transfac.newTransformer();
                    trans.setOutputProperty("omit-xml-declaration", "no");
                    trans.setOutputProperty("indent", "yes");
                    StreamResult result = new StreamResult(response.getOutputStream());
                    Element root = xsd.getElement();
                    root.setAttribute("xmlns", this.wadlDefaultNS);
                    DOMSource source = new DOMSource(root);
                    trans.transform(source, result);
                    return;
                }
                catch (Exception e) {
                    throw new HTTPError(500, e);
                }
            }
        }
        RESTContext context = new RESTContext();
        context.setMethod(method);
        context.setConverterIn(inputBinding.getReader());
        String contentType = request.getHeaders().get("Content-Type");
        if (contentType == null) {
            contentType = inputBinding.getMediaType();
        }
        context.setContentType(contentType);
        if (outputBinding == null) {
            context.setConverterOut(inputBinding.getReader());
        } else {
            context.setConverterOut(outputBinding.getReader());
        }
        context.setLocation(m.group(4));
        context.setHeadersIn(request.getHeaders());
        context.setParameters(request.getParameters());
        context.setCharacterEncoding(request.getCharacterEncoding());
        boolean iso8601dateFormat = true;
        String dateFormat = request.getParameters().get("date");
        if ("long".equals(dateFormat)) {
            iso8601dateFormat = false;
        }
        context.setIso8601dateFormat(iso8601dateFormat);
        Map<String, RESTRequestMultipartParser.Part> files = null;
        HashMap<String, String> parameters = new HashMap<String, String>(request.getParameters());
        try {
            files = this.multipartParser.extractMultipart(request, data, parameters);
            String body = (String)parameters.get("body");
            if (body != null) {
                data = body.getBytes("UTF-8");
            } else {
                RESTRequestMultipartParser.Part fileBody = files.get("body");
                if (fileBody != null) {
                    data = fileBody.getContent();
                    String ct = fileBody.getHeaders().get("content-type");
                    if (ct != null) {
                        context.setContentType(ct);
                    }
                }
            }
        }
        catch (FileUploadException e) {
            throw new HTTPError(500, (Exception)((Object)e));
        }
        context.setBody(data);
        context.setFiles(files);
        context.setVersion(version);
        context.setLocale(locale);
        context.setContext(request.getRequestURL().substring(0, request.getRequestURL().indexOf(request.getContextPath()) + request.getContextPath().length()));
        context.prechecks();
        inputBinding.doMethod(request, response, context);
    }

    protected RESTServiceBinding getBinding(RESTRequest req, String uriFormat, String headerKey, String paramKey, boolean accept, RESTServiceBinding defaultBinding) {
        RESTServiceBinding result = null;
        String receivedValue = null;
        if (uriFormat != null) {
            receivedValue = uriFormat;
            result = this.context2binding.get(uriFormat);
        } else {
            String tmp = req.getParameters().get(paramKey);
            if (tmp != null) {
                receivedValue = tmp;
                result = this.chooseBestBinding(tmp);
            } else {
                tmp = req.getHeaders().get(headerKey);
                if (tmp != null) {
                    int indexSemicolon = 0;
                    indexSemicolon = tmp.indexOf(59);
                    if (indexSemicolon != -1) {
                        tmp = tmp.substring(0, indexSemicolon);
                    }
                    receivedValue = tmp;
                    result = this.chooseBestBinding(tmp);
                }
            }
        }
        if (result == null) {
            if (accept) {
                if (receivedValue != null) {
                    throw new HTTPError(406, "Not Acceptable", receivedValue);
                }
            } else {
                result = defaultBinding;
            }
        }
        return result;
    }

    protected Locale getLocale(RESTRequest req, boolean accept, Locale defaultLocale) {
        Locale result = null;
        String receivedValue = null;
        String tmp = req.getParameters().get("accept-language");
        if (tmp != null) {
            receivedValue = tmp;
            result = RESTUtil.chooseBestLanguage(tmp);
        } else {
            tmp = req.getHeaders().get("Accept-Language");
            if (tmp != null) {
                receivedValue = tmp;
                result = RESTUtil.chooseBestLanguage(tmp);
            }
        }
        if (result == null) {
            if (accept) {
                if (receivedValue != null) {
                    throw new HTTPError(406, "Not Acceptable", receivedValue);
                }
            } else {
                result = defaultLocale;
            }
        }
        return result;
    }

    public static short getMethod(short initialMethod, RESTRequest req) {
        String tmp = req.getHeaders().get("x-method-override");
        if (tmp != null) {
            short bm = RESTServiceConsumer.getBM(tmp);
            if (bm == 0) {
                return initialMethod;
            }
            return bm;
        }
        tmp = req.getHeaders().get("x-http-method-override");
        if (tmp != null) {
            short bm = RESTServiceConsumer.getBM(tmp);
            if (bm == 0) {
                return initialMethod;
            }
            return bm;
        }
        tmp = req.getParameters().get("x-method-override");
        if (tmp != null) {
            short bm = RESTServiceConsumer.getBM(tmp);
            if (bm == 0) {
                return initialMethod;
            }
            return bm;
        }
        tmp = req.getParameters().get("x-http-method-override");
        if (tmp != null) {
            short bm = RESTServiceConsumer.getBM(tmp);
            if (bm == 0) {
                return initialMethod;
            }
            return bm;
        }
        return initialMethod;
    }

    protected void sendWADL(RESTRequest req, RESTResponse resp, String version, Locale locale) {
        try {
            boolean strict;
            resp.setContentType("application/xml");
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            Object wadlResult = null;
            boolean html = req.getParameters().get("html") != null;
            boolean inline = req.getParameters().get("inline") != null;
            boolean bl = strict = req.getParameters().get("strict") != null;
            if (html) {
                resp.getOutputStream().write(("<?xml-stylesheet type=\"text/xsl\" href=\"" + req.getContextPath() + "/xslt/wadl_documentation-2009-02.xsl\"?>\n").getBytes());
                trans.setOutputProperty("omit-xml-declaration", "yes");
                wadlResult = this.service.getServiceDescription(this.wadlBuilderHTML, locale);
            } else if (inline) {
                trans.setOutputProperty("omit-xml-declaration", "no");
                wadlResult = this.service.getServiceDescription(this.wadlBuilderInline, locale);
            } else {
                trans.setOutputProperty("omit-xml-declaration", "no");
                wadlResult = this.service.getServiceDescription(this.wadlBuilder, locale);
            }
            if (wadlResult instanceof Throwable) {
                throw (Throwable)wadlResult;
            }
            Element root = (Element)wadlResult;
            String base = req.getRequestURL().substring(0, req.getRequestURL().length() - req.getPathInfo().length());
            base = req.isPreemptiveAuthentication() ? base + "auth/" + version : base + "/" + version;
            ((Element)root.getElementsByTagName("resources").item(0)).getAttributeNode("base").setValue(base);
            if (strict) {
                resp.setContentType("application/vnd.sun.wadl+xml;charset=UTF-8");
            } else {
                resp.setContentType("application/xml;charset=UTF-8");
            }
            StreamResult result = new StreamResult(resp.getOutputStream());
            DOMSource source = new DOMSource(root);
            trans.transform(source, result);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected RESTServiceBinding chooseBestBinding(String contentTypeString) {
        RESTServiceBinding result = null;
        HTTPTransparentNegociation tn = new HTTPTransparentNegociation(contentTypeString);
        Set<HTTPTransparentNegociation.TNPart> tnparts = tn.getParts();
        for (HTTPTransparentNegociation.TNPart tnPart : tnparts) {
            String root = tnPart.getRoot();
            String complement = tnPart.getComplement();
            if (complement != null) {
                if (!"application".equals(root) && !"text".equals(root) && !"*".equals(root)) continue;
                if (complement.equals("*")) {
                    result = this.defaultBinding;
                    break;
                }
                result = this.context2binding.get(complement);
                if (result == null) continue;
                break;
            }
            result = this.context2binding.get(root);
        }
        return result;
    }
}

