/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest;

import com.ibm.icu.text.Collator;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.RESTProperty;
import com.ibm.rules.rest.io.RESTCollectionJsonSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="properties")
@JsonSerialize(using=RESTCollectionJsonSerializer.class)
public class RESTProperties
extends RESTCollection<Map.Entry<String, String>, RESTProperty> {
    public static RESTProperties DEFAULT_IN_INSTANCE;
    public static RESTProperties DEFAULT_OUT_INSTANCE;
    private final Map<String, String> properties = new TreeMap<String, String>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            Collator collator = Collator.getInstance((Locale)Locale.ENGLISH);
            collator.setStrength(2);
            return collator.compare(o1, o2);
        }
    });
    private Collection<RESTProperty> restProperties;

    public RESTProperties() {
        super(Locale.ENGLISH);
    }

    public RESTProperties(Map<String, String> properties, Locale locale) {
        super(locale);
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    @XmlElement(name="property")
    public Collection<RESTProperty> getProperties() {
        if (this.restProperties != null) {
            return this.restProperties;
        }
        if (this.properties == null) {
            this.restProperties = new ArrayList<RESTProperty>();
            return this.restProperties;
        }
        return this.getRESTCollection();
    }

    public void setProperties(Collection<RESTProperty> properties) {
        this.restProperties = properties;
    }

    @Override
    @JsonIgnore
    public Collection<Map.Entry<String, String>> getInitialCollection() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.entrySet();
    }

    @Override
    public RESTProperty toRESTObject(Map.Entry<String, String> internalObject, Locale locale) {
        RESTProperty result = new RESTProperty();
        result.setId(internalObject.getKey());
        result.setValue(internalObject.getValue());
        return result;
    }

    public Properties toJavaProperties() {
        Properties props = null;
        Collection<Object> restProperties = null;
        if (this.getRESTCollection() != null && this.getRESTCollection().size() > 0) {
            restProperties = this.getRESTCollection();
        } else if (this.getForcedRESTCollection() != null && this.getForcedRESTCollection().size() > 0) {
            restProperties = this.getForcedRESTCollection();
        }
        if (restProperties != null && restProperties.size() > 0) {
            props = new Properties();
            for (RESTProperty rESTProperty : restProperties) {
                props.put(rESTProperty.getId(), rESTProperty.getValue());
            }
        }
        return props;
    }

    @Override
    public Collection<RESTProperty> getForcedRESTCollection() {
        return this.restProperties;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("@@com.ibm.rules.rest.doc#propertyKey@@", "@@com.ibm.rules.rest.doc#propertyValue@@");
        DEFAULT_IN_INSTANCE = new RESTProperties(map, Locale.ENGLISH);
        DEFAULT_OUT_INSTANCE = new RESTProperties(map, Locale.ENGLISH);
    }
}

