/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest;

import com.ibm.rules.rest.Action;
import com.ibm.rules.rest.Converter;
import com.ibm.rules.rest.DocumentationProvider;
import com.ibm.rules.rest.LocationStepChoicePoint;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.RESTPreResponse;
import com.ibm.rules.rest.RESTServiceDescriptionBuilder;
import com.ibm.rules.rest.UnknowPathException;
import com.ibm.rules.rest.annotation.ActionResultType;
import com.ibm.rules.rest.annotation.DELETE;
import com.ibm.rules.rest.annotation.GET;
import com.ibm.rules.rest.annotation.POST;
import com.ibm.rules.rest.annotation.PUT;
import com.ibm.rules.rest.annotation.Path;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RESTServiceConsumer {
    private static final Pattern PATTERN_RANGE = Pattern.compile("items=([1-9][0-9]*)-([1-9][0-9]*)");
    private final DocumentationProvider docProvider;
    public static final short GET = 1;
    public static final short PUT = 2;
    public static final short POST = 4;
    public static final short DELETE = 8;
    private LocationStepChoicePoint getChoicePoint;
    private LocationStepChoicePoint putChoicePoint;
    private LocationStepChoicePoint deleteChoicePoint;
    private LocationStepChoicePoint postChoicePoint;
    private Class[] involvedClass;
    private Map<RESTContext.Format, Converter> reader;

    public RESTServiceConsumer(DocumentationProvider docProvider) {
        this.docProvider = docProvider;
    }

    public DocumentationProvider getDocumentationProvider() {
        return this.docProvider;
    }

    public static String getName(short method) {
        if (method == 1) {
            return "GET";
        }
        if (method == 4) {
            return "POST";
        }
        if (method == 2) {
            return "PUT";
        }
        if (method == 8) {
            return "DELETE";
        }
        return null;
    }

    public static short getBM(String method) {
        if ("GET".equals(method)) {
            return 1;
        }
        if ("POST".equals(method)) {
            return 4;
        }
        if ("PUT".equals(method)) {
            return 2;
        }
        if ("DELETE".equals(method)) {
            return 8;
        }
        return 0;
    }

    public void registerReader(Converter reader) {
        if (this.reader == null) {
            this.reader = new HashMap<RESTContext.Format, Converter>();
        }
        this.reader.put(reader.getFormat(), reader);
    }

    public Converter getReader(RESTContext.Format format) {
        return this.reader.get((Object)format);
    }

    public void addService(Class serviceClass, Object serviceBean) {
        int i;
        if (!serviceClass.isAssignableFrom(serviceBean.getClass())) {
            // empty if block
        }
        String rootPath = null;
        Path pathAnno = serviceClass.getAnnotation(Path.class);
        if (pathAnno != null) {
            rootPath = pathAnno.value();
        }
        Method[] methods = serviceClass.getMethods();
        HashSet<Class> involvedClassSet = new HashSet<Class>();
        if (this.involvedClass != null) {
            for (i = 0; i < this.involvedClass.length; ++i) {
                involvedClassSet.add(this.involvedClass[i]);
            }
        }
        for (i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            this.extractClassUsed(involvedClassSet, method);
            Annotation[] annotations = method.getAnnotations();
            Action action = new Action(serviceBean, method, this);
            short httpMethod = 0;
            for (int j = 0; j < annotations.length; ++j) {
                Annotation annotation = annotations[j];
                Class<? extends Annotation> annoClass = annotation.annotationType();
                if (annoClass.equals(GET.class)) {
                    httpMethod = (short)(httpMethod | 1);
                    continue;
                }
                if (annoClass.equals(PUT.class)) {
                    httpMethod = (short)(httpMethod | 2);
                    continue;
                }
                if (annoClass.equals(POST.class)) {
                    httpMethod = (short)(httpMethod | 4);
                    continue;
                }
                if (annoClass.equals(DELETE.class)) {
                    httpMethod = (short)(httpMethod | 8);
                    continue;
                }
                if (!annoClass.equals(Path.class)) continue;
                String location = ((Path)annotation).value();
                if (location.startsWith("/")) {
                    location = location.substring(1);
                }
                if (rootPath != null) {
                    location = rootPath + "/" + location;
                }
                String[] locationSteps = location.split("/");
                if ((httpMethod & 1) == 1) {
                    if (this.getChoicePoint == null) {
                        this.getChoicePoint = new LocationStepChoicePoint();
                    }
                    this.enhanceStepChoicePoint(this.getChoicePoint, locationSteps, action);
                }
                if ((httpMethod & 2) == 2) {
                    if (this.putChoicePoint == null) {
                        this.putChoicePoint = new LocationStepChoicePoint();
                    }
                    this.enhanceStepChoicePoint(this.putChoicePoint, locationSteps, action);
                }
                if ((httpMethod & 4) == 4) {
                    if (this.postChoicePoint == null) {
                        this.postChoicePoint = new LocationStepChoicePoint();
                    }
                    this.enhanceStepChoicePoint(this.postChoicePoint, locationSteps, action);
                }
                if ((httpMethod & 8) != 8) continue;
                if (this.deleteChoicePoint == null) {
                    this.deleteChoicePoint = new LocationStepChoicePoint();
                }
                this.enhanceStepChoicePoint(this.deleteChoicePoint, locationSteps, action);
            }
        }
        this.involvedClass = involvedClassSet.toArray(new Class[involvedClassSet.size()]);
    }

    private void extractClassUsed(Set<Class> involvedClassList, Method method) {
        involvedClassList.add(method.getReturnType());
        ActionResultType resultType = method.getAnnotation(ActionResultType.class);
        if (resultType != null) {
            involvedClassList.add(resultType.value());
        }
        Class<?>[] classes = method.getParameterTypes();
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i].equals(RESTPreResponse.class) || classes[i].equals(RESTContext.class)) continue;
            involvedClassList.add(classes[i]);
        }
    }

    private void enhanceStepChoicePoint(LocationStepChoicePoint initChoicePoint, String[] locationSteps, Action action) {
        LocationStepChoicePoint currentChoicePoint = initChoicePoint;
        for (int k = 0; k < locationSteps.length; ++k) {
            currentChoicePoint = currentChoicePoint.addStep(locationSteps[k], action.getParameters());
        }
        currentChoicePoint.addAction(action);
    }

    public Class[] getInvolvedClass() {
        return this.involvedClass;
    }

    public Object invokeMethod(RESTContext context) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, UnknowPathException, UnsupportedEncodingException {
        short method = context.getMethod();
        if (method == 8) {
            return this.invokeMethod(context, this.deleteChoicePoint, false);
        }
        if (method == 4) {
            return this.invokeMethod(context, this.postChoicePoint, false);
        }
        if (method == 2) {
            return this.invokeMethod(context, this.putChoicePoint, false);
        }
        return this.invokeMethod(context, this.getChoicePoint, true);
    }

    private Object invokeMethod(RESTContext context, LocationStepChoicePoint choicePointStart, boolean getMethod) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, UnknowPathException, UnsupportedEncodingException {
        Object result;
        String location = context.getLocation();
        if (location == null) {
            throw new UnknowPathException();
        }
        if (location.startsWith("/")) {
            location = location.substring(1);
        }
        String[] locationSteps = location.split("/");
        if (choicePointStart == null) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        LocationStepChoicePoint currentChoicePoint = choicePointStart;
        for (int i = 0; i < locationSteps.length; ++i) {
            if ((currentChoicePoint = currentChoicePoint.nextStep(locationSteps[i], parameters)) != null) continue;
            throw new UnknowPathException();
        }
        Action action = currentChoicePoint.getAction(context.getContentType());
        if (action == null) {
            throw new UnknowPathException();
        }
        boolean count = false;
        Map<String, String> params = context.getParameters();
        if (params.containsKey("count") && (params.get("count") == null || params.get("count").length() == 0 || params.get("count").equals("true"))) {
            count = true;
            params.put("count", "true");
        }
        if ((result = action.invoke(context, parameters)) instanceof RESTCollection) {
            Matcher m;
            String range;
            RESTCollection collection = (RESTCollection)result;
            Map<String, String> reqHeaders = context.getHeadersIn();
            String string = range = reqHeaders != null ? reqHeaders.get("range") : null;
            if (range != null && (m = PATTERN_RANGE.matcher(range)).matches()) {
                collection.paging(Integer.parseInt(m.group(1)) - 1, Integer.parseInt(m.group(2)) - 1);
                context.getHeadersOut().put("Content-Range", "items " + m.group(1) + "-" + m.group(2) + "/" + collection.count());
            }
            if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().length() == 0) continue;
                    if ("orderby".equals(entry.getKey())) {
                        collection.addOrderBy(entry.getValue());
                        continue;
                    }
                    collection.addFilter(entry.getKey(), entry.getValue());
                }
                if (count) {
                    RESTPreResponse resp = new RESTPreResponse();
                    resp.setContentType("text/plain");
                    resp.setStatus(resp.getStatus());
                    resp.setData(String.valueOf(collection.count()).getBytes());
                    return resp;
                }
            }
        }
        return result;
    }

    public Object getServiceDescription(RESTServiceDescriptionBuilder serviceDescription, Locale locale) {
        serviceDescription.putMethod((short)1, this.getChoicePoint);
        serviceDescription.putMethod((short)2, this.putChoicePoint);
        serviceDescription.putMethod((short)4, this.postChoicePoint);
        serviceDescription.putMethod((short)8, this.deleteChoicePoint);
        return serviceDescription.getDescription(locale);
    }
}

