/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest.io;

import com.ibm.rules.res.xml.internal.JAXBClassDesciption;
import com.ibm.rules.res.xml.internal.XSD;
import com.ibm.rules.res.xml.internal.XSDUtil;
import com.ibm.rules.rest.Action;
import com.ibm.rules.rest.LocationStepChoicePoint;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.RESTPreResponse;
import com.ibm.rules.rest.RESTServiceBinding;
import com.ibm.rules.rest.RESTServiceDescriptionBuilder;
import com.ibm.rules.rest.annotation.HideRESTCollectionFunction;
import com.ibm.rules.rest.io.LocalizationHelper;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WADLBuilder
implements RESTServiceDescriptionBuilder {
    public static final String WADL_DEFAULT_NS_NAME = "rest";
    protected DocumentBuilderFactory xmlFactory = DocumentBuilderFactory.newInstance();
    protected DocumentBuilder docBuilder;
    private LocationStepChoicePoint getChoicePoint;
    private LocationStepChoicePoint putChoicePoint;
    private LocationStepChoicePoint deleteChoicePoint;
    private LocationStepChoicePoint postChoicePoint;
    private final Map<String, RESTServiceBinding> context2binding;
    private final RESTServiceBinding defaultBinding;
    private final String wadlFileName;
    private final String description;
    private final String namespace;
    private final boolean inlineAll;
    private final boolean inlineXSD;
    private boolean html;
    private final List<Locale> availableLocales;
    private Map<String, XSD> xsds;
    private Map<String, JAXBClassDesciption> javaFqn2QName;

    public WADLBuilder(String wadlFileName, String description, String namespace, Map<String, RESTServiceBinding> context2binding, List<Locale> availableLocales, boolean inlineAll, boolean inlineXSD) throws ParserConfigurationException {
        this.defaultBinding = context2binding.get("xml");
        this.context2binding = context2binding;
        DocumentBuilderFactory xmlFactory = DocumentBuilderFactory.newInstance();
        xmlFactory.setValidating(false);
        xmlFactory.setNamespaceAware(true);
        this.docBuilder = xmlFactory.newDocumentBuilder();
        this.wadlFileName = wadlFileName;
        this.description = description;
        this.namespace = namespace;
        this.inlineAll = inlineAll;
        this.inlineXSD = inlineXSD;
        this.availableLocales = availableLocales;
    }

    @Override
    public Object getDescription(Locale locale) {
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Document doc = this.docBuilder.newDocument();
            Element root = doc.createElement("application");
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://wadl.dev.java.net/2009/02");
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rest", this.namespace);
            root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://wadl.dev.java.net/2009/02 wadl.xsd");
            HashMap<String, Element> references = new HashMap<String, Element>();
            Element rootDoc = doc.createElement("doc");
            rootDoc.setAttribute("title", this.description);
            root.appendChild(rootDoc);
            Element grammars = doc.createElement("grammars");
            this.appendGrammar(grammars, locale);
            root.appendChild(grammars);
            Element resources = doc.createElement("resources");
            resources.setAttribute("base", "TO_BE_REPLACED");
            root.appendChild(resources);
            this.appendChoicePoint(resources, this.getChoicePoint, "GET", references, locale);
            this.appendChoicePoint(resources, this.postChoicePoint, "POST", references, locale);
            this.appendChoicePoint(resources, this.putChoicePoint, "PUT", references, locale);
            this.appendChoicePoint(resources, this.deleteChoicePoint, "DELETE", references, locale);
            if (!this.inlineAll) {
                for (Element paramElement : references.values()) {
                    root.appendChild(paramElement);
                }
                this.appendClassicalParamDoc(root, null, null, references, locale, true);
            }
            return root;
        }
        catch (Throwable e) {
            return e;
        }
    }

    private <T> void appendClass(Class<T> clazz, Set<Class<?>> result) {
        if (clazz != null && !clazz.isArray() && !clazz.isPrimitive()) {
            result.add(clazz);
        }
    }

    private void appendAllClasses(Action action, Set<Class<?>> result) {
        if (action != null) {
            this.appendClass(action.getRequestClass(), result);
            this.appendClass(action.getReturnClass(), result);
        }
    }

    private void appendAllClasses(LocationStepChoicePoint choicePoint, Set<Class<?>> result) {
        Action defaultAction;
        if (choicePoint == null) {
            return;
        }
        ArrayList<Action> alreadyDiplayed = new ArrayList<Action>();
        Map<String, Action> type2action = choicePoint.getActionMap();
        if (type2action != null) {
            for (Map.Entry<String, Action> entry : type2action.entrySet()) {
                this.appendAllClasses(entry.getValue(), result);
                alreadyDiplayed.add(entry.getValue());
            }
        }
        if ((defaultAction = choicePoint.getAction(null)) != null && !alreadyDiplayed.contains(defaultAction)) {
            this.appendAllClasses(defaultAction, result);
        }
        this.appendAllClasses(choicePoint.getWildNameStep(), result);
        if (choicePoint.getWildNames() != null) {
            for (LocationStepChoicePoint.WildName wildName : choicePoint.getWildNames()) {
                this.appendAllClasses(wildName.step, result);
            }
        }
        if (choicePoint.getSteps() != null) {
            for (Map.Entry entry : choicePoint.getSteps().entrySet()) {
                this.appendAllClasses((LocationStepChoicePoint)entry.getValue(), result);
            }
        }
    }

    private Set<Class<?>> getAllClasses(LocationStepChoicePoint getChoicePoint, LocationStepChoicePoint putChoicePoint, LocationStepChoicePoint postChoicePoint, LocationStepChoicePoint deleteChoicePoint) {
        HashSet result = new HashSet();
        this.appendAllClasses(getChoicePoint, result);
        this.appendAllClasses(putChoicePoint, result);
        this.appendAllClasses(postChoicePoint, result);
        this.appendAllClasses(deleteChoicePoint, result);
        return result;
    }

    public Map<String, JAXBClassDesciption> getJavaFqn2QName() throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        if (this.getXSDs() != null) {
            return this.javaFqn2QName;
        }
        return null;
    }

    public Map<String, XSD> getXSDs() throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        if (this.xsds == null) {
            HashMap<String, String[]> uri2nameAndLocation = new HashMap<String, String[]>();
            this.javaFqn2QName = new HashMap<String, JAXBClassDesciption>();
            this.xsds = new HashMap<String, XSD>();
            this.xsds = new XSDUtil(null).generateSchema(this.getAllClasses(this.getChoicePoint, this.putChoicePoint, this.postChoicePoint, this.deleteChoicePoint), this.namespace, true, WADL_DEFAULT_NS_NAME, uri2nameAndLocation, WADL_DEFAULT_NS_NAME, this.javaFqn2QName, false);
        }
        return this.xsds;
    }

    private void appendGrammar(Element root, Locale locale) throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        Map<String, XSD> xsds = this.getXSDs();
        for (Map.Entry<String, XSD> entry : xsds.entrySet()) {
            if (this.inlineXSD) {
                Element element = entry.getValue().getElement();
                Node adoptedNode = root.getOwnerDocument().adoptNode(element);
                root.appendChild(adoptedNode);
                continue;
            }
            Element representation = root.getOwnerDocument().createElement("include");
            representation.setAttribute("href", this.wadlFileName + "/" + entry.getKey());
            root.appendChild(representation);
            Element doc = root.getOwnerDocument().createElement("doc");
            doc.setAttribute("title", LocalizationHelper.getLocalizedMessage(locale, "generated", new Object[0]));
            representation.appendChild(doc);
        }
    }

    private Element findElementWithPath(Element root, String pathName) {
        NodeList nodeList = root.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element tmp = (Element)nodeList.item(i);
            if (!pathName.equals(tmp.getAttribute("path"))) continue;
            return tmp;
        }
        return null;
    }

    private void appendRepresentation(Element root, RESTServiceBinding binding, String mediaType, Map<String, Element> references, Class<?> clazz, Class<?> actionResultClass, String fieldName, Locale locale, String postFixString) throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        if (clazz == null) {
            return;
        }
        if (this.inlineAll) {
            Element representationNode = this.createRepresentation(root, binding, clazz, actionResultClass, fieldName, locale, postFixString);
            root.appendChild(representationNode);
        } else {
            Element representationNode = references.get(binding.getType() + clazz.getSimpleName() + postFixString);
            if (representationNode == null) {
                representationNode = this.createRepresentation(root, binding, clazz, actionResultClass, fieldName, locale, postFixString);
                references.put(binding.getType() + clazz.getSimpleName() + postFixString, representationNode);
            }
            representationNode = root.getOwnerDocument().createElement("representation");
            representationNode.setAttribute("href", "#" + binding.getType() + clazz.getSimpleName() + postFixString);
            root.appendChild(representationNode);
        }
    }

    private void appendActionMethod(Action action, Element root, LocationStepChoicePoint choicePoint, String methodName, Map<String, Element> references, Locale locale) throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        Element method = root.getOwnerDocument().createElement("method");
        method.setAttribute("name", methodName);
        root.appendChild(method);
        this.appendActionDoc(method, action, locale);
        Element methodRequest = root.getOwnerDocument().createElement("request");
        method.appendChild(methodRequest);
        this.appendParamDoc(methodRequest, action, references, locale, true);
        this.appendClassicalParamDoc(methodRequest, action.getRequestClass(), methodName, references, locale, false);
        if (action.getRequestClass() != null) {
            Element methodDoc;
            String inputDescription;
            Element representation;
            if (String.class.isAssignableFrom(action.getRequestClass())) {
                representation = root.getOwnerDocument().createElement("representation");
                representation.setAttribute("mediaType", "text/plain");
                methodRequest.appendChild(representation);
                inputDescription = action.getRequestClassDescription(locale);
                if (inputDescription != null) {
                    methodDoc = root.getOwnerDocument().createElement("doc");
                    methodDoc.setTextContent(inputDescription);
                    representation.appendChild(methodDoc);
                }
            } else if (action.getRequestClass().getName().equals("[B")) {
                representation = root.getOwnerDocument().createElement("representation");
                representation.setAttribute("mediaType", "application/octet-stream");
                methodRequest.appendChild(representation);
                inputDescription = action.getRequestClassDescription(locale);
                if (inputDescription != null) {
                    methodDoc = root.getOwnerDocument().createElement("doc");
                    methodDoc.setTextContent(inputDescription);
                    representation.appendChild(methodDoc);
                }
            } else {
                this.appendRepresentation(methodRequest, this.defaultBinding, this.defaultBinding.getMediaType(), references, action.getRequestClass(), action.getActionResultClass(), "DEFAULT_IN_INSTANCE", locale, "In");
                for (Map.Entry<String, RESTServiceBinding> entry : this.context2binding.entrySet()) {
                    if (entry.getValue() == this.defaultBinding) continue;
                    this.appendRepresentation(methodRequest, entry.getValue(), entry.getValue().getMediaType(), references, action.getRequestClass(), action.getActionResultClass(), "DEFAULT_IN_INSTANCE", locale, "In");
                }
            }
        }
        Element methodResponse = root.getOwnerDocument().createElement("response");
        method.appendChild(methodResponse);
        if (!RESTPreResponse.class.isAssignableFrom(action.getReturnClass())) {
            HideRESTCollectionFunction hide;
            if (action.getReturnClass().getName().equals("[B")) {
                Element representation = root.getOwnerDocument().createElement("representation");
                representation.setAttribute("mediaType", "application/octet-stream");
            } else {
                this.appendRepresentation(methodResponse, this.defaultBinding, this.defaultBinding.getMediaType(), references, action.getReturnClass(), action.getActionResultClass(), "DEFAULT_OUT_INSTANCE", locale, "Out");
                for (Map.Entry<String, RESTServiceBinding> entry : this.context2binding.entrySet()) {
                    if (entry.getValue() == this.defaultBinding) continue;
                    this.appendRepresentation(methodResponse, entry.getValue(), entry.getValue().getMediaType(), references, action.getReturnClass(), action.getActionResultClass(), "DEFAULT_OUT_INSTANCE", locale, "Out");
                }
            }
            if (RESTCollection.class.isAssignableFrom(action.getReturnClass()) && (hide = action.getReturnClass().getAnnotation(HideRESTCollectionFunction.class)) == null) {
                Element methodForCount = root.getOwnerDocument().createElement("method");
                methodForCount.setAttribute("name", "GET");
                root.appendChild(methodForCount);
                Element docForCount = root.getOwnerDocument().createElement("doc");
                docForCount.setAttribute("title", this.getCountFunctionName(action.getPublicName()));
                docForCount.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "count", new Object[0]));
                methodForCount.appendChild(docForCount);
                Element requestForCount = root.getOwnerDocument().createElement("request");
                methodForCount.appendChild(requestForCount);
                Element paramCount = root.getOwnerDocument().createElement("param");
                paramCount.setAttribute("name", "count");
                paramCount.setAttribute("style", "query");
                paramCount.setAttribute("type", "xsd:boolean");
                paramCount.setAttribute("required", "true");
                paramCount.setAttribute("repeating", "false");
                paramCount.setAttribute("fixed", "true");
                requestForCount.appendChild(paramCount);
                this.appendParamDoc(requestForCount, action, references, locale, false);
                Element responseForCount = root.getOwnerDocument().createElement("response");
                methodForCount.appendChild(responseForCount);
                Element representationForCount = root.getOwnerDocument().createElement("representation");
                representationForCount.setAttribute("mediaType", "text/plain");
                responseForCount.appendChild(representationForCount);
            }
        }
    }

    private String getCountFunctionName(String publicName) {
        if (publicName == null) {
            return null;
        }
        if (publicName.startsWith("get")) {
            return "getCountOf" + publicName.substring(3);
        }
        return publicName + "Count";
    }

    private void appendActionMethod(Element root, LocationStepChoicePoint choicePoint, String methodName, Map<String, Element> references, Locale locale) throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        if (choicePoint != null && (choicePoint.getAction(null) != null || choicePoint.getActionMap() != null)) {
            Action defaultAction;
            ArrayList<Action> alreadyDiplayed = new ArrayList<Action>();
            Map<String, Action> type2action = choicePoint.getActionMap();
            if (type2action != null) {
                for (Map.Entry<String, Action> entry : type2action.entrySet()) {
                    this.appendActionMethod(entry.getValue(), root, choicePoint, methodName, references, locale);
                    alreadyDiplayed.add(entry.getValue());
                }
            }
            if ((defaultAction = choicePoint.getAction(null)) != null && !alreadyDiplayed.contains(defaultAction)) {
                this.appendActionMethod(defaultAction, root, choicePoint, methodName, references, locale);
            }
        }
    }

    private void appendResource(Element root, HashMap<String, LocationStepChoicePoint> currentSteps, String method, Map<String, Element> references, Locale locale) throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        if (currentSteps != null) {
            TreeSet<Map.Entry<String, LocationStepChoicePoint>> set = new TreeSet<Map.Entry<String, LocationStepChoicePoint>>(new Comparator<Map.Entry<String, LocationStepChoicePoint>>(){

                @Override
                public int compare(Map.Entry<String, LocationStepChoicePoint> o1, Map.Entry<String, LocationStepChoicePoint> o2) {
                    Action a1 = o1.getValue().getAction(null);
                    Action a2 = o2.getValue().getAction(null);
                    if (a1 != null && a2 != null) {
                        int result = a1.getPriority() - a2.getPriority();
                        if (result != 0) {
                            return result;
                        }
                        return 1;
                    }
                    return 1;
                }
            });
            set.addAll(currentSteps.entrySet());
            for (Map.Entry<String, LocationStepChoicePoint> entry : set) {
                String step = entry.getKey();
                Element nextResource = this.findElementWithPath(root, step);
                if (nextResource == null) {
                    nextResource = root.getOwnerDocument().createElement("resource");
                    nextResource.setAttribute("path", step);
                    root.appendChild(nextResource);
                }
                this.appendChoicePoint(nextResource, entry.getValue(), method, references, locale);
            }
        }
    }

    private void appendActionDoc(Element root, Action action, Locale locale) {
        if (action == null) {
            return;
        }
        String actionDescription = action.getDescription(locale);
        if (actionDescription != null) {
            Element methodDoc = root.getOwnerDocument().createElement("doc");
            if (actionDescription != null) {
                methodDoc.setAttribute("title", action.getPublicName());
                methodDoc.setTextContent(actionDescription);
            }
            root.appendChild(methodDoc);
        }
    }

    private Element createParam(Element root, Action.Parameter param, Locale locale) {
        List<Action.Parameter.Option> options;
        Element paramNode = root.getOwnerDocument().createElement("param");
        paramNode.setAttribute("type", "xsd:string");
        paramNode.setAttribute("style", param.query ? "query" : "template");
        if (param.htmlDocCode != null) {
            paramNode.setAttribute("id", param.htmlDocCode);
        }
        paramNode.setAttribute("name", param.getName());
        String actionDescription = param.getDescription(locale);
        if (actionDescription != null) {
            Element methodDoc = root.getOwnerDocument().createElement("doc");
            if (actionDescription != null) {
                methodDoc.setAttribute("title", param.getName());
                methodDoc.setTextContent(actionDescription);
            }
            paramNode.appendChild(methodDoc);
        }
        if ((options = param.getOptions(locale)) != null) {
            for (Action.Parameter.Option option : options) {
                if (option.defaultValue) {
                    paramNode.setAttribute("default", option.name);
                }
                Element paramOption = root.getOwnerDocument().createElement("option");
                paramOption.setAttribute("value", option.name);
                paramNode.appendChild(paramOption);
                Element optionDoc = root.getOwnerDocument().createElement("doc");
                if (option.doc != null) {
                    optionDoc.setAttribute("title", option.name);
                    optionDoc.setTextContent(option.doc);
                }
                paramOption.appendChild(optionDoc);
            }
        }
        return paramNode;
    }

    private Element createRepresentation(Element root, RESTServiceBinding binding, Class<?> clazz, Class<?> actionResultClass, String fieldName, Locale locale, String postFixString) throws DOMException, IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        String representationDescription;
        Element representationNode = root.getOwnerDocument().createElement("representation");
        representationNode.setAttribute("mediaType", binding.getMediaType());
        if (binding.getMediaType().equals("application/xml")) {
            representationNode.setAttribute("element", "rest:" + this.getJavaFqn2QName().get(clazz.getName()).getElementLocalName());
            representationNode.setAttribute("xmlns:rest", this.namespace);
        }
        if (!this.inlineAll) {
            representationNode.setAttribute("id", binding.getType() + clazz.getSimpleName() + postFixString);
        }
        if ((representationDescription = Action.getFieldRepresentation(clazz, actionResultClass, binding.getReader(), fieldName, locale)) != null) {
            Element methodDoc = root.getOwnerDocument().createElement("doc");
            methodDoc.setAttribute("title", binding.getType() + "(" + clazz.getSimpleName() + ")");
            Element pre = root.getOwnerDocument().createElement("pre");
            pre.setTextContent(representationDescription);
            methodDoc.appendChild(pre);
            representationNode.appendChild(methodDoc);
        }
        return representationNode;
    }

    private void appendOverrideMethodParameters(Element root, String method, Locale locale, boolean reference) {
        Element paramXMethodOverride = root.getOwnerDocument().createElement("param");
        if (reference) {
            paramXMethodOverride.setAttribute("id", "xMethodOverrideAsHeader" + method);
        }
        paramXMethodOverride.setAttribute("name", "X-Method-Override");
        paramXMethodOverride.setAttribute("style", "header");
        paramXMethodOverride.setAttribute("required", "false");
        paramXMethodOverride.setAttribute("repeating", "false");
        paramXMethodOverride.setAttribute("fixed", method);
        root.appendChild(paramXMethodOverride);
        Element docNode = root.getOwnerDocument().createElement("doc");
        docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "xMethodOverrideAsHeader", new Object[0]));
        paramXMethodOverride.appendChild(docNode);
        paramXMethodOverride = root.getOwnerDocument().createElement("param");
        if (reference) {
            paramXMethodOverride.setAttribute("id", "xMethodOverrideAsQuery" + method);
        }
        paramXMethodOverride.setAttribute("name", "x-method-override");
        paramXMethodOverride.setAttribute("style", "query");
        paramXMethodOverride.setAttribute("required", "false");
        paramXMethodOverride.setAttribute("repeating", "false");
        paramXMethodOverride.setAttribute("fixed", method);
        root.appendChild(paramXMethodOverride);
        docNode = root.getOwnerDocument().createElement("doc");
        docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "xMethodOverrideAsQuery", new Object[0]));
        paramXMethodOverride.appendChild(docNode);
        Element paramXHTTPMethodOverride = root.getOwnerDocument().createElement("param");
        if (reference) {
            paramXHTTPMethodOverride.setAttribute("id", "xHTTPMethodOverrideAsHeader" + method);
        }
        paramXHTTPMethodOverride.setAttribute("name", "X-HTTP-Method-Override");
        paramXHTTPMethodOverride.setAttribute("style", "header");
        paramXHTTPMethodOverride.setAttribute("required", "false");
        paramXHTTPMethodOverride.setAttribute("repeating", "false");
        paramXHTTPMethodOverride.setAttribute("fixed", method);
        root.appendChild(paramXHTTPMethodOverride);
        docNode = root.getOwnerDocument().createElement("doc");
        docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "xHTTPMethodOverrideAsHeader", new Object[0]));
        paramXHTTPMethodOverride.appendChild(docNode);
        paramXHTTPMethodOverride = root.getOwnerDocument().createElement("param");
        if (reference) {
            paramXHTTPMethodOverride.setAttribute("id", "xHTTPMethodOverrideAsQuery" + method);
        }
        paramXHTTPMethodOverride.setAttribute("name", "x-http-method-override");
        paramXHTTPMethodOverride.setAttribute("style", "query");
        paramXHTTPMethodOverride.setAttribute("required", "false");
        paramXHTTPMethodOverride.setAttribute("repeating", "false");
        paramXHTTPMethodOverride.setAttribute("fixed", method);
        root.appendChild(paramXHTTPMethodOverride);
        docNode = root.getOwnerDocument().createElement("doc");
        docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "xHTTPMethodOverrideAsQuery", new Object[0]));
        paramXHTTPMethodOverride.appendChild(docNode);
    }

    private void appendClassicalParamDoc(Element root, Class requestClass, String method, Map<String, Element> params, Locale locale, boolean reference) {
        if (this.inlineAll || reference) {
            Element paramContentType;
            Element optionFormat;
            Element optionFormat2;
            String[] options;
            Element paramDateFormat = root.getOwnerDocument().createElement("param");
            if (reference) {
                paramDateFormat.setAttribute("id", "dateFormat");
            }
            paramDateFormat.setAttribute("name", "date");
            paramDateFormat.setAttribute("style", "query");
            paramDateFormat.setAttribute("default", "iso8601");
            paramDateFormat.setAttribute("required", "false");
            paramDateFormat.setAttribute("repeating", "false");
            root.appendChild(paramDateFormat);
            Element docNode = root.getOwnerDocument().createElement("doc");
            docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "dateFormat", new Object[0]));
            paramDateFormat.appendChild(docNode);
            for (String option : options = new String[]{"iso8601", "long"}) {
                optionFormat2 = root.getOwnerDocument().createElement("option");
                optionFormat2.setAttribute("value", option);
                paramDateFormat.appendChild(optionFormat2);
                docNode = root.getOwnerDocument().createElement("doc");
                docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "dateFormat_" + option, new Object[0]));
                optionFormat2.appendChild(docNode);
            }
            Element paramAccept = root.getOwnerDocument().createElement("param");
            if (reference) {
                paramAccept.setAttribute("id", "acceptAsHeader");
            }
            paramAccept.setAttribute("name", "Accept");
            paramAccept.setAttribute("style", "header");
            paramAccept.setAttribute("default", this.defaultBinding.getMediaType());
            paramAccept.setAttribute("required", "false");
            paramAccept.setAttribute("repeating", "false");
            root.appendChild(paramAccept);
            docNode = root.getOwnerDocument().createElement("doc");
            docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "acceptAsHeader", new Object[0]));
            paramAccept.appendChild(docNode);
            for (Map.Entry<String, RESTServiceBinding> binding : this.context2binding.entrySet()) {
                optionFormat = root.getOwnerDocument().createElement("option");
                optionFormat.setAttribute("value", binding.getValue().getMediaType());
                paramAccept.appendChild(optionFormat);
            }
            paramAccept = root.getOwnerDocument().createElement("param");
            if (reference) {
                paramAccept.setAttribute("id", "acceptAsQuery");
            }
            paramAccept.setAttribute("name", "accept");
            paramAccept.setAttribute("style", "query");
            paramAccept.setAttribute("default", this.defaultBinding.getMediaType());
            paramAccept.setAttribute("required", "false");
            paramAccept.setAttribute("repeating", "false");
            root.appendChild(paramAccept);
            docNode = root.getOwnerDocument().createElement("doc");
            docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "acceptAsQuery", new Object[0]));
            paramAccept.appendChild(docNode);
            for (Map.Entry<String, RESTServiceBinding> binding : this.context2binding.entrySet()) {
                optionFormat = root.getOwnerDocument().createElement("option");
                optionFormat.setAttribute("value", binding.getValue().getMediaType());
                paramAccept.appendChild(optionFormat);
            }
            Element paramAcceptLanguage = root.getOwnerDocument().createElement("param");
            if (reference) {
                paramAcceptLanguage.setAttribute("id", "acceptLanguageAsHeader");
            }
            paramAcceptLanguage.setAttribute("name", "Accept-Language");
            paramAcceptLanguage.setAttribute("style", "header");
            paramAcceptLanguage.setAttribute("default", "en");
            paramAcceptLanguage.setAttribute("required", "false");
            paramAcceptLanguage.setAttribute("repeating", "false");
            root.appendChild(paramAcceptLanguage);
            docNode = root.getOwnerDocument().createElement("doc");
            docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "acceptLanguageAsHeader", new Object[0]));
            paramAcceptLanguage.appendChild(docNode);
            for (Locale tmpLocale : this.availableLocales) {
                optionFormat2 = root.getOwnerDocument().createElement("option");
                optionFormat2.setAttribute("value", tmpLocale.toString());
                paramAcceptLanguage.appendChild(optionFormat2);
                docNode = root.getOwnerDocument().createElement("doc");
                docNode.setTextContent(tmpLocale.getDisplayName(locale));
                optionFormat2.appendChild(docNode);
            }
            paramAcceptLanguage = root.getOwnerDocument().createElement("param");
            if (reference) {
                paramAcceptLanguage.setAttribute("id", "acceptLanguageAsQuery");
            }
            paramAcceptLanguage.setAttribute("name", "accept-language");
            paramAcceptLanguage.setAttribute("style", "query");
            paramAcceptLanguage.setAttribute("default", "en");
            paramAcceptLanguage.setAttribute("required", "false");
            paramAcceptLanguage.setAttribute("repeating", "false");
            root.appendChild(paramAcceptLanguage);
            docNode = root.getOwnerDocument().createElement("doc");
            docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "acceptLanguageAsQuery", new Object[0]));
            paramAcceptLanguage.appendChild(docNode);
            for (Locale tmpLocale : this.availableLocales) {
                optionFormat2 = root.getOwnerDocument().createElement("option");
                optionFormat2.setAttribute("value", tmpLocale.toString());
                paramAcceptLanguage.appendChild(optionFormat2);
                docNode = root.getOwnerDocument().createElement("doc");
                docNode.setTextContent(tmpLocale.getDisplayName(locale));
                optionFormat2.appendChild(docNode);
            }
            if (reference) {
                paramContentType = root.getOwnerDocument().createElement("param");
                paramContentType.setAttribute("id", "contentTypeTextPlainAsHeader");
                paramContentType.setAttribute("name", "Content-Type");
                paramContentType.setAttribute("style", "header");
                paramContentType.setAttribute("default", "text/plain");
                paramContentType.setAttribute("required", "true");
                paramContentType.setAttribute("repeating", "false");
                root.appendChild(paramContentType);
                docNode = root.getOwnerDocument().createElement("doc");
                docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "contentTypeAsHeader", new Object[0]));
                paramContentType.appendChild(docNode);
                Element optionElement = root.getOwnerDocument().createElement("option");
                optionElement.setAttribute("value", "text/plain");
                paramContentType.appendChild(optionElement);
                paramContentType = root.getOwnerDocument().createElement("param");
                paramContentType.setAttribute("id", "contentTypeOctetStreamAsHeader");
                paramContentType.setAttribute("name", "Content-Type");
                paramContentType.setAttribute("style", "header");
                paramContentType.setAttribute("default", "application/octet-stream");
                paramContentType.setAttribute("required", "true");
                paramContentType.setAttribute("repeating", "false");
                root.appendChild(paramContentType);
                docNode = root.getOwnerDocument().createElement("doc");
                docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "contentTypeAsHeader", new Object[0]));
                paramContentType.appendChild(docNode);
                optionElement = root.getOwnerDocument().createElement("option");
                optionElement.setAttribute("value", "application/octet-stream");
                paramContentType.appendChild(optionElement);
                paramContentType = root.getOwnerDocument().createElement("param");
                paramContentType.setAttribute("id", "contentTypeAsHeader");
                paramContentType.setAttribute("name", "Content-Type");
                paramContentType.setAttribute("style", "header");
                paramContentType.setAttribute("default", this.defaultBinding.getMediaType());
                paramContentType.setAttribute("required", "false");
                paramContentType.setAttribute("repeating", "false");
                root.appendChild(paramContentType);
                docNode = root.getOwnerDocument().createElement("doc");
                docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "contentTypeAsHeader", new Object[0]));
                paramContentType.appendChild(docNode);
                for (Map.Entry<String, RESTServiceBinding> binding : this.context2binding.entrySet()) {
                    optionElement = root.getOwnerDocument().createElement("option");
                    optionElement.setAttribute("value", binding.getValue().getMediaType());
                    paramContentType.appendChild(optionElement);
                }
            } else {
                paramContentType = root.getOwnerDocument().createElement("param");
                boolean textPlain = false;
                boolean octetStream = false;
                if (requestClass != null) {
                    if (String.class.isAssignableFrom(requestClass)) {
                        textPlain = true;
                    } else if (requestClass.getName().equals("[B")) {
                        octetStream = true;
                    }
                }
                paramContentType.setAttribute("name", "Content-Type");
                paramContentType.setAttribute("style", "header");
                if (textPlain) {
                    paramContentType.setAttribute("required", "true");
                } else if (octetStream) {
                    paramContentType.setAttribute("required", "true");
                } else {
                    paramContentType.setAttribute("required", "false");
                }
                paramContentType.setAttribute("repeating", "false");
                root.appendChild(paramContentType);
                docNode = root.getOwnerDocument().createElement("doc");
                docNode.setTextContent(LocalizationHelper.getLocalizedMessage(locale, "contentTypeAsHeader", new Object[0]));
                paramContentType.appendChild(docNode);
                if (textPlain) {
                    Element optionElement = root.getOwnerDocument().createElement("option");
                    optionElement.setAttribute("value", "text/plain");
                    paramContentType.appendChild(optionElement);
                } else if (octetStream) {
                    Element optionElement = root.getOwnerDocument().createElement("option");
                    optionElement.setAttribute("value", "application/octet-stream");
                    paramContentType.appendChild(optionElement);
                } else {
                    for (Map.Entry<String, RESTServiceBinding> binding : this.context2binding.entrySet()) {
                        Element optionElement = root.getOwnerDocument().createElement("option");
                        optionElement.setAttribute("value", binding.getValue().getMediaType());
                        paramContentType.appendChild(optionElement);
                    }
                }
            }
            if (method == null || method.equals("GET")) {
                this.appendOverrideMethodParameters(root, "GET", locale, reference);
            }
            if (method == null || method.equals("POST")) {
                this.appendOverrideMethodParameters(root, "POST", locale, reference);
            }
            if (method == null || method.equals("PUT")) {
                this.appendOverrideMethodParameters(root, "PUT", locale, reference);
            }
            if (method == null || method.equals("DELETE")) {
                this.appendOverrideMethodParameters(root, "DELETE", locale, reference);
            }
        } else {
            Element paramRef = root.getOwnerDocument().createElement("param");
            paramRef.setAttribute("href", "#dateFormat");
            root.appendChild(paramRef);
            paramRef = root.getOwnerDocument().createElement("param");
            paramRef.setAttribute("href", "#acceptAsHeader");
            root.appendChild(paramRef);
            paramRef = root.getOwnerDocument().createElement("param");
            paramRef.setAttribute("href", "#acceptAsQuery");
            root.appendChild(paramRef);
            paramRef = root.getOwnerDocument().createElement("param");
            paramRef.setAttribute("href", "#acceptLanguageAsHeader");
            root.appendChild(paramRef);
            paramRef = root.getOwnerDocument().createElement("param");
            paramRef.setAttribute("href", "#acceptLanguageAsQuery");
            root.appendChild(paramRef);
            boolean textPlain = false;
            boolean octetStream = false;
            if (requestClass != null) {
                if (String.class.isAssignableFrom(requestClass)) {
                    textPlain = true;
                } else if (requestClass.getName().equals("[B")) {
                    octetStream = true;
                }
            }
            if (textPlain) {
                paramRef = root.getOwnerDocument().createElement("param");
                paramRef.setAttribute("href", "#contentTypeTextPlainAsHeader");
                root.appendChild(paramRef);
            } else if (octetStream) {
                paramRef = root.getOwnerDocument().createElement("param");
                paramRef.setAttribute("href", "#contentTypeOctetStreamAsHeader");
                root.appendChild(paramRef);
            } else {
                paramRef = root.getOwnerDocument().createElement("param");
                paramRef.setAttribute("href", "#contentTypeAsHeader");
                root.appendChild(paramRef);
            }
            paramRef = root.getOwnerDocument().createElement("param");
            paramRef.setAttribute("href", "#xMethodOverrideAsHeader" + method);
            root.appendChild(paramRef);
            paramRef = root.getOwnerDocument().createElement("param");
            paramRef.setAttribute("href", "#xMethodOverrideAsQuery" + method);
            root.appendChild(paramRef);
            paramRef = root.getOwnerDocument().createElement("param");
            paramRef.setAttribute("href", "#xHTTPMethodOverrideAsHeader" + method);
            root.appendChild(paramRef);
            paramRef = root.getOwnerDocument().createElement("param");
            paramRef.setAttribute("href", "#xHTTPMethodOverrideAsQuery" + method);
            root.appendChild(paramRef);
        }
    }

    private void appendParamDoc(Element root, Action action, Map<String, Element> params, Locale locale, boolean queryParams) {
        if (action == null) {
            return;
        }
        if (action.getParameters() == null) {
            return;
        }
        for (Action.Parameter tmp : action.getParameters()) {
            Element paramNode;
            if (tmp.query && !queryParams) continue;
            String docCode = tmp.htmlDocCode;
            if (docCode == null || this.inlineAll) {
                paramNode = this.createParam(root, tmp, locale);
                root.appendChild(paramNode);
                continue;
            }
            paramNode = params.get(docCode);
            if (paramNode == null) {
                paramNode = this.createParam(root, tmp, locale);
                params.put(docCode, paramNode);
            }
            paramNode = root.getOwnerDocument().createElement("param");
            paramNode.setAttribute("href", "#" + docCode);
            root.appendChild(paramNode);
        }
    }

    private void appendResourceWildchar(Element root, LocationStepChoicePoint currentStep, String method, Map<String, Element> references, Locale locale) throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        if (currentStep == null) {
            return;
        }
        List<LocationStepChoicePoint.WildName> wildNames = currentStep.getWildNames();
        if (wildNames != null) {
            for (LocationStepChoicePoint.WildName wildName : wildNames) {
                String step = "{" + wildName.name + "}";
                Element nextResource = this.findElementWithPath(root, step);
                if (nextResource == null) {
                    nextResource = root.getOwnerDocument().createElement("resource");
                    nextResource.setAttribute("path", step);
                    root.appendChild(nextResource);
                }
                LocationStepChoicePoint nextStep = wildName.step == null ? currentStep.getWildNameStep() : wildName.step;
                this.appendChoicePoint(nextResource, nextStep, method, references, locale);
            }
        }
    }

    private void appendChoicePoint(Element root, LocationStepChoicePoint choicePoint, String method, Map<String, Element> references, Locale locale) throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        this.appendActionMethod(root, choicePoint, method, references, locale);
        HashMap<String, LocationStepChoicePoint> getSteps = choicePoint != null ? choicePoint.getSteps() : null;
        this.appendResource(root, getSteps, method, references, locale);
        this.appendResourceWildchar(root, choicePoint, method, references, locale);
    }

    @Override
    public void putMethod(short method, LocationStepChoicePoint choicePoint) {
        this.xsds = null;
        switch (method) {
            case 4: {
                this.postChoicePoint = choicePoint;
                break;
            }
            case 2: {
                this.putChoicePoint = choicePoint;
                break;
            }
            case 8: {
                this.deleteChoicePoint = choicePoint;
                break;
            }
            default: {
                this.getChoicePoint = choicePoint;
            }
        }
    }
}

