/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml;

import ilog.rules.base.xml.IlrXmlConverter;
import ilog.rules.base.xml.IlrXmlDefaultConverterManager;
import ilog.rules.base.xml.IlrXmlNamespaceManager;
import ilog.rules.base.xml.IlrXmlService;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrIssueHandler;
import ilog.rules.util.issue.IlrWarning;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class IlrXmlAbstractService
implements IlrXmlService {
    protected IlrIssueHandler errorManager;
    protected boolean validating = false;
    DocumentBuilderFactory factory;
    protected Transformer transformer;
    protected boolean useDOMLS = false;

    public IlrXmlAbstractService(IlrIssueHandler issueHandler) {
        this.errorManager = issueHandler;
    }

    protected abstract IlrXmlDefaultConverterManager getConverterManager();

    @Override
    public void addConverter(IlrXmlConverter converter) {
        this.getConverterManager().addConverter(converter);
    }

    @Override
    public void removeConverter(IlrXmlConverter converter) {
        this.getConverterManager().removeConverter(converter);
    }

    @Override
    public void addSingleton(String id, Object singleton) {
        this.getConverterManager().addSingleton(id, singleton);
    }

    @Override
    public Collection<IlrWarning> getWarnings() {
        return this.errorManager.getWarnings();
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public Object readObject(InputSource is, Map data, Class expectedType) throws IlrErrorException {
        this.errorManager.clear();
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory(this.validating);
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document document = docBuilder.parse(is);
            return this.readObjectInternal(document, data, expectedType);
        }
        catch (ParserConfigurationException e) {
            this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_007", e.getMessage(), "ilog.rules.xml.data.messages", e));
            this.errorManager.throwException();
        }
        catch (IOException e) {
            this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_007", new String[]{e.getMessage()}, e));
            this.errorManager.throwException();
        }
        catch (SAXException e) {
            this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_008", e.getMessage()));
            this.errorManager.throwException();
        }
        return null;
    }

    public Object readObject(Document document, Map data, Class expectedType) throws IlrErrorException {
        this.errorManager.clear();
        return this.readObjectInternal(document, data, expectedType);
    }

    private Object readObjectInternal(Document document, Map data, Class expectedType) throws IlrErrorException {
        Object obj = this.getConverterManager().readObject(document, data, expectedType);
        if (this.errorManager.hasErrors()) {
            this.errorManager.throwException();
        }
        return obj;
    }

    @Override
    public Object readObject(Reader reader, String readerPublicId, Map data, Class expectedType) throws IlrErrorException {
        InputSource is = new InputSource(reader);
        is.setPublicId(readerPublicId);
        return this.readObject(is, data, expectedType);
    }

    @Override
    public Object readObject(InputStream istream, String readerPublicId, Map data, Class expectedType) throws IlrErrorException {
        InputSource is = new InputSource(istream);
        is.setPublicId(readerPublicId);
        return this.readObject(is, data, expectedType);
    }

    private IlrXmlNamespaceManager createNamespaceManager() {
        IlrXmlNamespaceManager nsManager = new IlrXmlNamespaceManager();
        nsManager.addNamespace("xsi", "http://www.w3.org/2000/10/XMLSchema-instance");
        return nsManager;
    }

    @Override
    public void writeObject(Object object, Writer writer, Map data) throws IlrErrorException {
        this.writeObject(object, null, writer, data);
    }

    @Override
    public void writeObject(Object object, QName elementQName, OutputStream os, Map data) throws IlrErrorException {
        this.writeObject(object, null, os, data);
    }

    @Override
    public void writeObject(Object object, OutputStream os, Map data) throws IlrErrorException {
        this.writeObject(object, new OutputStreamWriter(os), data);
    }

    @Override
    public void writeObject(Object object, QName elementQName, Writer writer, Map data) throws IlrErrorException {
        Document document = this.createDocument(object, elementQName, data);
        this.writeDocument(document, writer);
    }

    public Document createDocument(Object object, Map data) throws IlrErrorException {
        return this.createDocument(object, null, data);
    }

    public Document createDocument(Object object, QName elementQName, Map data) throws IlrErrorException {
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory(true);
        Document document = this.createEmptyDocument(factory);
        if (document != null) {
            this.fillDocument(document, object, elementQName, data);
        }
        if (this.errorManager.hasErrors()) {
            this.errorManager.throwException();
        }
        return document;
    }

    public Document createEmptyDocument(DocumentBuilderFactory factory) throws IlrErrorException {
        Document document = null;
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            document = this.createEmptyDocument(docBuilder);
        }
        catch (ParserConfigurationException e) {
            this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_007", new String[]{e.getMessage()}, e));
            this.errorManager.throwException();
        }
        return document;
    }

    public Document createEmptyDocument(DocumentBuilder builder) {
        this.errorManager.clear();
        Document document = builder.newDocument();
        document.setXmlVersion("1.1");
        return document;
    }

    public void fillDocument(Document document, Object object, QName elementQName, Map data) {
        this.errorManager.clear();
        this.getConverterManager().writeObject(object, elementQName, this.createNamespaceManager(), document, data);
        if (this.errorManager.hasErrors()) {
            this.errorManager.throwException();
        }
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory(boolean validating) {
        if (this.factory == null) {
            this.factory = IlrXmlAbstractService.createDocumentBuilderFactory(validating);
        } else {
            this.factory.setValidating(validating);
        }
        return this.factory;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory(boolean validating) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(validating);
        if (validating) {
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        return factory;
    }

    public void writeDocument(Document doc, Writer writer) throws IlrErrorException {
        this.writeUsingTransformer(doc, writer);
    }

    private boolean writeUsingDomLS(Document doc, Writer writer) {
        if (doc.getFeature("Core", "3.0") != null && doc.getFeature("LS", "3.0") != null) {
            DOMImplementationLS domImplementationLS = (DOMImplementationLS)doc.getImplementation().getFeature("LS", "3.0");
            LSOutput LSO = domImplementationLS.createLSOutput();
            LSO.setCharacterStream(writer);
            LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
            Element element = doc.getDocumentElement();
            Node xsi = element.getAttributes().getNamedItem("xmlns:xsi");
            if (xsi != null) {
                element.removeAttribute(xsi.getNodeName());
            }
            if (!lsSerializer.write(doc, LSO)) {
                this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_007", new Object[0]));
                this.errorManager.throwException();
            }
            return true;
        }
        return false;
    }

    private void writeUsingTransformer(Document doc, Writer writer) {
        Transformer localTransformer = this.transformer;
        if (localTransformer == null) {
            try {
                localTransformer = IlrXmlAbstractService.createTransformer();
            }
            catch (Exception ex) {
                this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_007", new String[]{ex.getMessage()}, ex));
                this.errorManager.throwException();
            }
        }
        this.writeDocument(doc, writer, localTransformer);
    }

    public void writeDocument(Document doc, Writer writer, Transformer transformer) {
        try {
            DOMSource xmlSource = new DOMSource(doc);
            writer.append("<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n");
            StreamResult xmlDest = new StreamResult(writer);
            transformer.transform(xmlSource, xmlDest);
        }
        catch (Exception ex) {
            this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_007", new String[]{ex.getMessage()}, ex));
            this.errorManager.throwException();
        }
    }

    public static Transformer createTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = IlrXmlAbstractService.createTransformerFactory();
        return IlrXmlAbstractService.createTransformer(transformerFactory);
    }

    public static Transformer createTransformer(TransformerFactory transformerFactory) throws TransformerConfigurationException {
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("version", "1.1");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        return transformer;
    }

    public static TransformerFactory createTransformerFactory() {
        return TransformerFactory.newInstance();
    }
}

