/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml.converter;

import ilog.rules.base.xml.converter.IlrPrimitiveConverter;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrIssueHandler;
import java.math.BigInteger;

public class IlrBigIntegerConverter
extends IlrPrimitiveConverter {
    private static IlrBigIntegerConverter INSTANCE = new IlrBigIntegerConverter();

    public static IlrBigIntegerConverter getInstance() {
        return INSTANCE;
    }

    public IlrBigIntegerConverter() {
        super(BigInteger.class);
    }

    @Override
    public Class[] getSupportedClasses() {
        return new Class[]{BigInteger.class};
    }

    @Override
    protected Object convert(String text, IlrIssueHandler issueHandler) throws IlrErrorException {
        return new BigInteger(this.removePlus(text));
    }

    private String removePlus(String source) {
        if ((source = source.trim()).startsWith("+")) {
            return source.substring(1).trim();
        }
        return source;
    }
}

