/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml.converter;

import ilog.rules.base.xml.IlrXmlConverter;
import ilog.rules.base.xml.IlrXmlMarshallingContext;
import ilog.rules.base.xml.IlrXmlUnmarshallingContext;
import ilog.rules.util.issue.IlrErrorException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class IlrCharConverter
implements IlrXmlConverter {
    private static IlrCharConverter INSTANCE = new IlrCharConverter();
    private static final QName XML_ELEMENT = new QName("char");

    public static IlrCharConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public Class[] getSupportedClasses() {
        return new Class[]{Character.TYPE, Character.class};
    }

    @Override
    public QName getXmlType() {
        return null;
    }

    @Override
    public QName getXmlElement() {
        return XML_ELEMENT;
    }

    @Override
    public QName getSchemaLocation() {
        return null;
    }

    @Override
    public boolean isReferenceWorthy() {
        return false;
    }

    @Override
    public void writeObject(Object object, Element element, IlrXmlMarshallingContext context) throws IlrErrorException {
        Character c = (Character)object;
        if (c.charValue() == '\u0000') {
            element.setAttribute("null", "true");
        } else {
            Text t = context.getDocument().createTextNode("" + c);
            element.appendChild(t);
        }
    }

    @Override
    public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
        String nullAttribute = element.getAttribute("null");
        if (nullAttribute != null && nullAttribute.equals("true")) {
            return Character.valueOf('\u0000');
        }
        Text t = (Text)element.getFirstChild();
        return Character.valueOf(t.getData().charAt(0));
    }
}

