/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml.converter;

import ilog.rules.base.xml.converter.IlrPrimitiveConverter;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrIssueHandler;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class IlrDateConverter
extends IlrPrimitiveConverter {
    private DatatypeFactory datatypeFactory;

    public IlrDateConverter() throws DatatypeConfigurationException {
        super(new QName("date"), Date.class);
        this.datatypeFactory = DatatypeFactory.newInstance();
    }

    public IlrDateConverter(DatatypeFactory datatypeFactory) {
        super(new QName("date"), Date.class);
        this.datatypeFactory = datatypeFactory;
    }

    @Override
    protected Object convert(String text, IlrIssueHandler issueHandler) throws IlrErrorException {
        XMLGregorianCalendar gregorianCalendar = this.datatypeFactory.newXMLGregorianCalendar(text);
        return gregorianCalendar.toGregorianCalendar().getTime();
    }

    @Override
    protected String toString(Object object) throws IlrErrorException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime((Date)object);
        XMLGregorianCalendar xmlGregorianCalendar = this.datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
        return xmlGregorianCalendar.toString();
    }
}

