/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml.converter;

import ilog.rules.base.xml.IlrXmlMarshallingContext;
import ilog.rules.base.xml.IlrXmlUnmarshallingContext;
import ilog.rules.base.xml.converter.IlrMapConverter;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IlrEnumMapConverter
extends IlrMapConverter {
    private static final QName XML_ELEMENT = new QName("enumMap");

    @Override
    public void writeObject(Object object, Element element, IlrXmlMarshallingContext context) throws IlrErrorException {
        final EnumMap enumMap = (EnumMap)object;
        Class keyType = AccessController.doPrivileged(new PrivilegedAction<Class>(){

            @Override
            public Class run() {
                try {
                    Field keyTypeField = EnumMap.class.getDeclaredField("keyType");
                    keyTypeField.setAccessible(true);
                    Object keyTypeObject = keyTypeField.get(enumMap);
                    return (Class)keyTypeObject;
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        if (keyType != null) {
            element.setAttribute("keyType", keyType.getCanonicalName());
        }
        super.writeObject(object, element, context);
    }

    @Override
    public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
        NodeList list = element.getChildNodes();
        final String keyTypeStr = element.getAttribute("keyType");
        if (keyTypeStr != null) {
            Class keyType = new PrivilegedAction<Class>(){

                @Override
                public Class run() {
                    try {
                        return Class.forName(keyTypeStr);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            }.run();
            if (keyType != null) {
                EnumMap c = new EnumMap(keyType);
                this.fillMap(context, list, c);
                return c;
            }
            context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_016", keyTypeStr, element.getLocalName()));
        } else {
            context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_011", "keyType", element.getLocalName()));
        }
        return null;
    }

    @Override
    protected Map createInstance(int initialCapacity) {
        return null;
    }

    @Override
    public Class[] getSupportedClasses() {
        return new Class[]{EnumMap.class};
    }

    @Override
    public QName getXmlElement() {
        return XML_ELEMENT;
    }
}

