/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml.converter;

import ilog.rules.base.xml.converter.IlrPrimitiveConverter;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrIssueHandler;
import java.text.Format;
import java.text.ParseException;
import javax.xml.namespace.QName;

public class IlrFormatConverter
extends IlrPrimitiveConverter {
    private static final String MSD_ID_PREFIX = "ilog.rules.engine.dataio.messages";
    final Format format;

    public IlrFormatConverter(Format format, Class clazz) {
        super(clazz);
        this.format = format;
    }

    public IlrFormatConverter(QName xmlElement, Format format, Class clazz) {
        super(xmlElement, clazz);
        this.format = format;
    }

    @Override
    protected Object convert(String text, IlrIssueHandler issueHandler) throws IlrErrorException {
        try {
            return this.format.parseObject(text);
        }
        catch (ParseException e) {
            issueHandler.add(new IlrError(MSD_ID_PREFIX, "ParseException", e.getMessage(), text));
            return WRONG_VALUE;
        }
    }

    @Override
    protected String toString(Object object) throws IlrErrorException {
        return this.format.format(object);
    }
}

