/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml.converter;

import ilog.rules.base.xml.converter.IlrPrimitiveConverter;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrIssueHandler;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class XMLDurationConverter
extends IlrPrimitiveConverter {
    private final DatatypeFactory datatypeFactory;

    public XMLDurationConverter() throws DatatypeConfigurationException {
        this(DatatypeFactory.newInstance());
    }

    public XMLDurationConverter(DatatypeFactory datatypeFactory) {
        super(Duration.class);
        this.datatypeFactory = datatypeFactory;
    }

    protected String toString(Duration object) throws IlrErrorException {
        return object.toString();
    }

    @Override
    protected Object convert(String text, IlrIssueHandler issueHandler) throws IlrErrorException {
        try {
            return this.datatypeFactory.newDuration(text);
        }
        catch (IllegalArgumentException e) {
            issueHandler.add(new IlrError("ilog.rules.xml.data.messages", "ParseException", e.getMessage(), text));
            return WRONG_VALUE;
        }
    }
}

