/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.crypto;

import ilog.rules.crypto.IlrEncryptionServiceException;
import ilog.rules.crypto.IlrEncryptionUtility;

public class IlrEncryptionService {
    private static IlrEncryptionService instance = null;
    private IlrEncryptionUtility cryptoUtil;

    private IlrEncryptionService(IlrEncryptionUtility cryptoUtil) throws IlrEncryptionServiceException {
        this.cryptoUtil = cryptoUtil;
    }

    public static synchronized IlrEncryptionService getInstance() throws IlrEncryptionServiceException {
        if (instance == null) {
            instance = new IlrEncryptionService(IlrEncryptionUtility.getInstance());
        }
        return instance;
    }

    public String encrypt(String message) throws IlrEncryptionServiceException {
        return this.cryptoUtil.encrypt(message);
    }

    public String decrypt(String message) throws IlrEncryptionServiceException {
        return this.cryptoUtil.decrypt(message);
    }

    public String getAlgorithm() {
        return this.cryptoUtil.getAlgorithm();
    }
}

