/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.crypto;

import ilog.rules.crypto.IlrEncryptionServiceException;
import ilog.rules.crypto.IlrOldEncryptionService;
import ilog.rules.util.IlrBase64DecoderStream;
import ilog.rules.util.IlrBase64EncoderStream;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class IlrEncryptionUtility {
    private static IlrEncryptionUtility instance = null;
    private static final String ALGO_KEY_VERSION = "AES 1";
    private static final byte[] defaultRawKey = new byte[]{63, 81, -21, 91, -9, 113, 122, 120, 81, -17, 83, -108, 71, 42, 39, 1};
    private static final String ALGO = "AES";
    private static final String BLOCK_MODE = "ECB";
    private static final String PADDING_SCHEME = "PKCS5Padding";
    private static final String KEY_HASHING_ALGO = "SHA-1";
    private Cipher cipher;
    private SecretKeySpec key;

    public static synchronized IlrEncryptionUtility getInstance() throws IlrEncryptionServiceException {
        if (instance == null) {
            instance = new IlrEncryptionUtility();
        }
        return instance;
    }

    public IlrEncryptionUtility() throws IlrEncryptionServiceException {
        this(null);
    }

    public IlrEncryptionUtility(byte[] rawKey) throws IlrEncryptionServiceException {
        if (this.cipher == null) {
            this.initCipher();
        }
        byte[] key = rawKey != null ? rawKey : this.keyHash(defaultRawKey);
        this.key = new SecretKeySpec(key, ALGO);
    }

    private void initCipher() throws IlrEncryptionServiceException {
        try {
            this.cipher = Cipher.getInstance(String.format("%s/%s/%s", ALGO, BLOCK_MODE, PADDING_SCHEME));
        }
        catch (Exception ex) {
            throw new IlrEncryptionServiceException(ex);
        }
    }

    private byte[] keyHash(byte[] inKey) throws IlrEncryptionServiceException {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance(KEY_HASHING_ALGO);
        }
        catch (Exception ex) {
            throw new IlrEncryptionServiceException(ex);
        }
        byte[] hash = sha.digest(inKey);
        byte[] hashkey = new byte[16];
        System.arraycopy(hash, 0, hashkey, 0, 16);
        return hashkey;
    }

    public String getAlgorithm() {
        return ALGO;
    }

    public String getAlgoAndKeyID() {
        return ALGO_KEY_VERSION;
    }

    public byte[] encryptData(byte[] data) throws IlrEncryptionServiceException {
        if (data == null) {
            return null;
        }
        try {
            this.cipher.init(1, this.key);
            byte[] encrypted = this.cipher.doFinal(data);
            return encrypted;
        }
        catch (Exception ex) {
            throw new IlrEncryptionServiceException(ex);
        }
    }

    public byte[] decryptData(byte[] bytes) throws IlrEncryptionServiceException {
        if (bytes == null) {
            return null;
        }
        try {
            this.cipher.init(2, this.key);
            byte[] cipherArray = this.cipher.doFinal(bytes);
            return cipherArray;
        }
        catch (Exception ex) {
            throw new IlrEncryptionServiceException(ex);
        }
    }

    public String encrypt(String message) throws IlrEncryptionServiceException {
        if (message == null) {
            return null;
        }
        try {
            byte[] encrypted = this.encryptData(message.getBytes("UTF-8"));
            byte[] encoded = IlrBase64EncoderStream.encode(encrypted);
            return new String(encoded, "UTF-8");
        }
        catch (Exception ex) {
            throw new IlrEncryptionServiceException(ex);
        }
    }

    public String decrypt(String message) throws IlrEncryptionServiceException {
        if (message == null) {
            return null;
        }
        try {
            byte[] decoded = IlrBase64DecoderStream.decode(message.getBytes("UTF-8"));
            byte[] decrypted = this.decryptData(decoded);
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            throw new IlrEncryptionServiceException(e);
        }
    }

    public static String decryptFlexible(String message) throws IlrEncryptionServiceException {
        try {
            IlrEncryptionUtility aes = IlrEncryptionUtility.getInstance();
            String decrypted = aes.decrypt(message);
            return decrypted;
        }
        catch (Exception ex) {
            try {
                IlrOldEncryptionService des = IlrOldEncryptionService.getInstance();
                String decrypted = des.decrypt(message);
                return decrypted;
            }
            catch (Exception e) {
                throw new IlrEncryptionServiceException(ex);
            }
        }
    }
}

