/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.data;

import ilog.rules.data.IlrActionKey;
import ilog.rules.data.IlrSourceSupport;
import ilog.rules.data.IlrSourceZone;
import java.util.ArrayList;

public class IlrBlockSourceSupport
extends IlrSourceSupport {
    private IlrSourceZone actionKeyword;
    protected int level = 0;
    protected ArrayList keys = new ArrayList(10);
    protected ArrayList zones = new ArrayList(10);
    String sourceIdentifier;
    String sourceName;

    public IlrBlockSourceSupport(String keyword, IlrSourceZone keywordZone, String sourceIdentifier, String sourceName, IlrSourceZone actionKeyword) {
        super(keyword, keywordZone);
        this.actionKeyword = actionKeyword;
        this.sourceIdentifier = sourceIdentifier;
        this.sourceName = sourceName;
    }

    int getType() {
        return -1;
    }

    public IlrSourceZone getActionKeyword() {
        return this.actionKeyword;
    }

    public void incrementLevel() {
        ++this.level;
    }

    public void decrementLevel() {
        --this.level;
    }

    public void addActionZone(IlrSourceZone zone) {
        int index = this.keys.size();
        this.keys.add(new IlrActionKey(this.getSourceIdentifier(), index, this.level, this.getType()));
        this.zones.add(zone);
    }

    public IlrSourceZone getActionZone(IlrActionKey key) {
        int index = key.index;
        try {
            return (IlrSourceZone)this.zones.get(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public IlrSourceZone getActionZone(int position) {
        int size = this.zones.size();
        for (int i = 0; i < size; ++i) {
            IlrSourceZone zone = (IlrSourceZone)this.zones.get(i);
            if (position < zone.getBeginPosition() || position > zone.getEndPosition()) continue;
            return zone;
        }
        return null;
    }

    public IlrActionKey getActionKey(int position) {
        int size = this.zones.size();
        for (int i = 0; i < size; ++i) {
            IlrSourceZone zone = (IlrSourceZone)this.zones.get(i);
            if (position < zone.getBeginPosition() || position > zone.getEndPosition()) continue;
            return (IlrActionKey)this.keys.get(i);
        }
        return null;
    }

    public final String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public int getZonesSize() {
        return this.zones.size();
    }

    public final boolean isSameSourceIdentifier(String ident) {
        return this.sourceIdentifier.equals(ident);
    }

    @Override
    public String toString() {
        String sourceZoneStr = super.toString() + "\n";
        String details = "Level = " + this.level + " SourceIdentifier = " + this.sourceIdentifier + " SourceName = " + this.sourceName + "\n";
        String result = sourceZoneStr + details;
        if (this.actionKeyword != null) {
            String actionKeywordStr = "Action block starts at: " + this.actionKeyword.toString() + "\n";
            ArrayList<String> keysStr = new ArrayList<String>(this.keys.size());
            for (int i = 0; i < this.keys.size(); ++i) {
                IlrActionKey key = (IlrActionKey)this.keys.get(i);
                IlrSourceZone zone = this.getActionZone(key);
                String keyStr = "   " + key.toString() + " " + zone.toString() + "\n";
                keysStr.add(keyStr);
            }
            result = result + actionKeywordStr;
            for (int j = 0; j < keysStr.size(); ++j) {
                String str = (String)keysStr.get(j);
                result = result + str;
            }
        }
        return result;
    }
}

