/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.data;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IlrSourceStructure {
    private Vector sourceElements = new Vector();
    public static final int IMPORT = 1;
    public static final int FUNCTION = 2;
    public static final int PROPERTIES = 3;
    public static final int RULE = 4;
    public static final int SETUP = 5;

    public void addElement(Element el) {
        this.sourceElements.addElement(el);
    }

    public Enumeration elements() {
        return this.sourceElements.elements();
    }

    public static class Rule
    extends Element {
        private Properties props = new Properties();
        public String name;
        public String conditions;
        public String actions;
        public String comments;

        public Rule() {
            super(4);
        }

        public String getProperty(String key) {
            return this.props.getProperty(key);
        }

        public void setProperty(String key, String value) {
            this.props.setProperty(key, value);
        }

        public Properties getProperties() {
            return this.props;
        }

        public Enumeration keys() {
            return this.props.keys();
        }
    }

    public static class Setup
    extends Element {
        public String comments;
        public String body;

        public Setup() {
            super(5);
        }
    }

    public static class Properties
    extends Element {
        private Hashtable props;

        public Properties() {
            super(3);
        }

        public String getProperty(String key) {
            if (this.props == null) {
                return null;
            }
            return (String)this.props.get(key);
        }

        public void setProperty(String key, String value) {
            if (this.props == null) {
                this.props = new Hashtable();
            }
            this.props.put(key, value);
        }

        public Enumeration keys() {
            if (this.props == null) {
                return null;
            }
            return this.props.keys();
        }
    }

    public static class Function
    extends Element {
        public String name;
        public String body;
        public String comments;

        public Function() {
            super(2);
        }
    }

    public static class Import
    extends Element {
        public String value;

        public Import() {
            super(1);
        }
    }

    public static class Element {
        private int type;

        Element(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

