/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.base.IlrArrayIndexer;
import ilog.rules.base.IlrUtil;
import ilog.rules.datasource.IlrDefaultDataSourceModel;
import ilog.rules.datasource.IlrMutableTableDataSource;
import ilog.rules.datasource.IlrTableDataSource;
import ilog.rules.datasource.IlrTableDataSourceModel;
import ilog.rules.util.issue.IlrDefaultIssueHandler;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrIssueHandler;
import ilog.rules.util.issue.IlrWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class IlrMemTableDataSource
implements IlrMutableTableDataSource {
    private IlrTableDataSourceModel model;
    private String name;
    private transient HashMap tableDSFromName = new HashMap();
    private static String NULL_VALUE = "";

    public IlrMemTableDataSource(String name, IlrTableDataSourceModel model) {
        this.name = name;
        this.model = model;
        if (model != null) {
            IlrTableDataSourceModel.Table[] tables = model.getTables();
            for (int i = 0; i < tables.length; ++i) {
                this.tableDSFromName.put(tables[i].getName(), new TableDS(tables[i]));
            }
        }
    }

    public static IlrMemTableDataSource createDataSource(IlrTableDataSource dataSource, String dataSourceName) throws Exception {
        IlrMemTableDataSource memDataSource = new IlrMemTableDataSource(dataSourceName, dataSource.getModel());
        boolean alreadyConnected = dataSource.isConnected();
        if (!alreadyConnected) {
            dataSource.connectDevice();
        }
        IlrTableDataSourceModel.Table[] tables = dataSource.getModel().getTables();
        for (int i = 0; i < tables.length; ++i) {
            String tableName = tables[i].getName();
            IlrTableDataSource.RowIterator rowIte = dataSource.iterateRows(tableName);
            while (rowIte.hasNext()) {
                IlrTableDataSource.Row row1 = rowIte.nextRow();
                IlrMutableTableDataSource.MutableRow row2 = memDataSource.addRow(tableName);
                row2.setCells(row1.getCells());
            }
        }
        if (!alreadyConnected) {
            dataSource.disconnectDevice();
        }
        return memDataSource;
    }

    @Override
    public IlrTableDataSourceModel getModel() {
        return this.model;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void connectDevice() throws Exception {
    }

    @Override
    public void disconnectDevice() throws Exception {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isQuerySupported() {
        return false;
    }

    @Override
    public void synchronizeDevice() throws Exception {
    }

    @Override
    public IlrMutableTableDataSource.MutableRowIterator iterateMutableRows(String tableName, String query) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectDevice(String password) throws Exception {
    }

    @Override
    public IlrTableDataSource.RowIterator iterateRows(String tableName, String query) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public IlrTableDataSource.RowIterator iterateRows(String tableName) {
        TableDS table = (TableDS)this.tableDSFromName.get(tableName);
        if (table == null) {
            return null;
        }
        return table.iterateMutableRows();
    }

    @Override
    public IlrMutableTableDataSource.MutableRowIterator iterateMutableRows(String tableName) {
        TableDS table = (TableDS)this.tableDSFromName.get(tableName);
        if (table == null) {
            return null;
        }
        return table.iterateMutableRows();
    }

    @Override
    public Collection<IlrWarning> check() throws IlrErrorException {
        IlrDefaultIssueHandler errorManager = new IlrDefaultIssueHandler();
        IlrDefaultDataSourceModel.checkModel(this.model, errorManager);
        IlrTableDataSourceModel.Table[] tables = this.model.getTables();
        for (int i = 0; i < tables.length; ++i) {
            this.checkContent(tables[i], errorManager);
        }
        if (errorManager.hasErrors()) {
            errorManager.throwException();
        }
        return errorManager.getWarnings();
    }

    private void checkContent(IlrTableDataSourceModel.Table table, IlrIssueHandler errorManager) throws IlrErrorException {
        IlrTableDataSource.RowIterator rowIte = this.iterateRows(table.getName());
        IlrTableDataSourceModel.Column[] columns = table.getColumns();
        int rowSize = columns.length;
        try {
            while (rowIte.hasNext()) {
                IlrTableDataSource.Row row = rowIte.nextRow();
                for (int i = 0; i < rowSize; ++i) {
                    Object obj = row.getCell(i);
                    if (this.isNullValue(obj)) continue;
                    if (obj == null) {
                        errorManager.add(new IlrError("datasource", "ERROR_DS_007", columns[i].getName(), table.getName()));
                        continue;
                    }
                    if (IlrUtil.areSameBoxingType(obj.getClass(), columns[i].getType()) || columns[i].getType().isAssignableFrom(obj.getClass())) continue;
                    String columnType = columns[i].getType() == null ? "null" : columns[i].getType().getName();
                    errorManager.add(new IlrError("datasource", "ERROR_DS_008", columns[i].getName(), table.getName(), obj.getClass().getName(), columnType));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public IlrMutableTableDataSource.MutableRow addRow(String tableName) throws Exception {
        TableDS table = (TableDS)this.tableDSFromName.get(tableName);
        if (table != null) {
            return table.addRow();
        }
        return null;
    }

    @Override
    public void removeRow(String tableName, int rowIx) throws Exception {
        TableDS table = (TableDS)this.tableDSFromName.get(tableName);
        if (table != null) {
            table.removeRow(rowIx);
        }
    }

    @Override
    public Object getNullValue() {
        return NULL_VALUE;
    }

    @Override
    public boolean isNullValue(Object object) {
        return object == NULL_VALUE;
    }

    @Override
    public void setModel(IlrTableDataSourceModel model) {
        this.model = model;
    }

    private static final class RowDS
    implements IlrMutableTableDataSource.MutableRow {
        IlrArrayIndexer tableIndexer;
        final Object[] cells;
        int index = -1;

        public RowDS(Object[] cells, IlrArrayIndexer tableIndexer, int index) {
            this.tableIndexer = tableIndexer;
            this.cells = cells;
            this.index = index;
        }

        @Override
        public Object getCell(String columnName) {
            return this.cells[this.tableIndexer.getIndex(columnName)];
        }

        @Override
        public Object getCell(int columnIx) {
            return this.cells[columnIx];
        }

        @Override
        public Object[] getCells() {
            return this.cells;
        }

        @Override
        public void setCell(int columnIx, Object value) {
            this.cells[columnIx] = value;
        }

        @Override
        public void setCell(String columnName, Object value) {
            this.cells[this.tableIndexer.getIndex((String)columnName)] = value;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setCells(Object[] sourceCells) {
            System.arraycopy(sourceCells, 0, this.cells, 0, this.cells.length);
        }
    }

    private static final class MutableIteratorDS
    implements IlrMutableTableDataSource.MutableRowIterator {
        ArrayList rows;
        int nextIx;

        public MutableIteratorDS(ArrayList rows) {
            this.rows = rows;
        }

        @Override
        public IlrMutableTableDataSource.MutableRow nextMutableRow() {
            return (IlrMutableTableDataSource.MutableRow)this.nextRow();
        }

        @Override
        public boolean hasNext() {
            return this.nextIx < this.rows.size();
        }

        @Override
        public IlrTableDataSource.Row nextRow() {
            if (this.nextIx < this.rows.size()) {
                return (IlrTableDataSource.Row)this.rows.get(this.nextIx++);
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.nextIx < this.rows.size()) {
                this.rows.remove(this.nextIx);
                --this.nextIx;
            }
        }

        @Override
        public IlrTableDataSource.Row[] toRowArray() throws Exception {
            IlrTableDataSource.Row[] arrays = new IlrTableDataSource.Row[this.rows.size()];
            return this.rows.toArray(arrays);
        }
    }

    private static final class TableDS {
        ArrayList rows = new ArrayList();
        IlrArrayIndexer tableIndexer;
        int rowSize;

        public TableDS(IlrTableDataSourceModel.Table table) {
            this.rowSize = table.getColumnCount();
            String[] cols = new String[this.rowSize];
            for (int i = 0; i < this.rowSize; ++i) {
                cols[i] = table.getColumn(i).getName();
            }
            this.tableIndexer = new IlrArrayIndexer(cols);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public IlrMutableTableDataSource.MutableRowIterator iterateMutableRows() {
            return new MutableIteratorDS(this.rows);
        }

        public IlrMutableTableDataSource.MutableRow addRow() throws Exception {
            RowDS row = new RowDS(new Object[this.rowSize], this.tableIndexer, this.rows.size());
            this.rows.add(row);
            return row;
        }

        public void removeRow(int rowIx) throws Exception {
            this.rows.remove(rowIx);
            for (int i = rowIx; i < this.rows.size(); ++i) {
                RowDS row = (RowDS)this.rows.get(i);
                --row.index;
            }
        }
    }
}

