/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.base.IlrMutableStringMap;
import ilog.rules.base.IlrUtil;
import ilog.rules.base.xml.IlrXmlConverter;
import ilog.rules.base.xml.IlrXmlConverterProvider;
import ilog.rules.base.xml.IlrXmlDefaultService;
import ilog.rules.base.xml.IlrXmlMarshallingContext;
import ilog.rules.base.xml.IlrXmlUnmarshallingContext;
import ilog.rules.base.xml.converter.IlrBooleanConverter;
import ilog.rules.base.xml.converter.IlrByteConverter;
import ilog.rules.base.xml.converter.IlrDoubleConverter;
import ilog.rules.base.xml.converter.IlrFloatConverter;
import ilog.rules.base.xml.converter.IlrIntConverter;
import ilog.rules.base.xml.converter.IlrLongConverter;
import ilog.rules.base.xml.converter.IlrShortConverter;
import ilog.rules.base.xml.converter.IlrStringConverter;
import ilog.rules.datasource.IlrDataSourcePool;
import ilog.rules.datasource.IlrDefaultColumnModel;
import ilog.rules.datasource.IlrDefaultDataSourceModel;
import ilog.rules.datasource.IlrDefaultTableModel;
import ilog.rules.datasource.IlrMemTableDataSource;
import ilog.rules.datasource.IlrMutableTableDataSource;
import ilog.rules.datasource.IlrMutableTableDataSourceModel;
import ilog.rules.datasource.IlrTableDataSource;
import ilog.rules.datasource.IlrTableDataSourceModel;
import ilog.rules.datasource.IlrXmlDSConstants;
import ilog.rules.datasource.IlrXmlPoolConverters;
import ilog.rules.util.issue.IlrDefaultIssueHandler;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrIssueHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IlrXmlDataSourceReaderWriter
extends IlrXmlDefaultService {
    public IlrXmlDataSourceReaderWriter() {
        this(new IlrDefaultIssueHandler());
    }

    public IlrXmlDataSourceReaderWriter(IlrIssueHandler errorManager) {
        super(errorManager, false);
        ArrayList cs = new ArrayList();
        ConverterProvider declarer = new ConverterProvider();
        declarer.declareConverters(cs);
        for (int i = 0; i < cs.size(); ++i) {
            this.addConverter((IlrXmlConverter)cs.get(i));
        }
    }

    public void writeDataSource(IlrTableDataSource dataSource, Writer writer) throws IlrErrorException {
        this.writeObject((Object)dataSource, writer, new HashMap());
    }

    public IlrTableDataSource readDataSource(Reader reader, String sourcePublicId) throws IlrErrorException {
        HashMap datas = new HashMap();
        return (IlrTableDataSource)this.readObject(reader, sourcePublicId, datas, IlrTableDataSource.class);
    }

    public void writePool(IlrDataSourcePool pool, Writer writer) throws IlrErrorException {
        this.writeObject((Object)pool, writer, new HashMap());
    }

    public IlrDataSourcePool readPool(Reader reader, String sourcePublicId) throws IlrErrorException {
        HashMap datas = new HashMap();
        return (IlrDataSourcePool)this.readObject(reader, sourcePublicId, datas, IlrTableDataSource.class);
    }

    public void writeDataSource(IlrTableDataSource dataSource, OutputStream os) throws IlrErrorException {
        this.writeObject((Object)dataSource, os, new HashMap());
    }

    public IlrTableDataSource readDataSource(InputStream is, String sourcePublicId) throws IlrErrorException {
        HashMap datas = new HashMap();
        return (IlrTableDataSource)this.readObject(is, sourcePublicId, datas, IlrTableDataSource.class);
    }

    public void writePool(IlrDataSourcePool pool, OutputStream os) throws IlrErrorException {
        this.writeObject((Object)pool, os, new HashMap());
    }

    public IlrDataSourcePool readPool(InputStream is, String sourcePublicId) throws IlrErrorException {
        HashMap datas = new HashMap();
        return (IlrDataSourcePool)this.readObject(is, sourcePublicId, datas, IlrDataSourcePool.class);
    }

    private static class IlrMutableStringMapConverter
    implements IlrXmlConverter,
    IlrXmlDSConstants {
        private IlrMutableStringMapConverter() {
        }

        @Override
        public Class[] getSupportedClasses() {
            return new Class[]{IlrMutableStringMap.class};
        }

        @Override
        public QName getXmlElement() {
            return PROPERTIES_ELEMENT;
        }

        @Override
        public QName getXmlType() {
            return PROPERTIES_TYPE;
        }

        @Override
        public QName getSchemaLocation() {
            return SCHEMA_LOCATION_QNAME;
        }

        @Override
        public boolean isReferenceWorthy() {
            return true;
        }

        @Override
        public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
            IlrMutableStringMap prop = new IlrMutableStringMap();
            NodeList propertyElems = element.getElementsByTagName("property");
            for (int i = 0; i < propertyElems.getLength(); ++i) {
                Element propElem = (Element)propertyElems.item(i);
                prop.addProperty(propElem.getAttribute("key"), propElem.getAttribute("value"));
            }
            return prop;
        }

        @Override
        public void writeObject(Object object, Element propertiesElem, IlrXmlMarshallingContext context) throws IlrErrorException {
            IlrMutableStringMap properties = (IlrMutableStringMap)object;
            Document doc = context.getDocument();
            String[] keys = properties.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                Element propertyElem = doc.createElement("property");
                propertyElem.setAttribute("key", keys[i]);
                propertyElem.setAttribute("value", properties.getValue(keys[i]));
                propertiesElem.appendChild(propertyElem);
            }
        }
    }

    private static class IlrDefaultDataSourceModelConverter
    implements IlrXmlConverter,
    IlrXmlDSConstants {
        private IlrDefaultDataSourceModelConverter() {
        }

        @Override
        public void writeObject(Object object, Element modelElement, IlrXmlMarshallingContext context) throws IlrErrorException {
            IlrDefaultDataSourceModel dsModel = (IlrDefaultDataSourceModel)object;
            Document doc = context.getDocument();
            context.writeObject(dsModel.getProperties(), modelElement);
            Element tablesElement = context.createElement("http://schemas.ilog.com/JRules/1.0/datasource", "tables");
            modelElement.appendChild(tablesElement);
            IlrTableDataSourceModel.Table[] tables = dsModel.getTables();
            for (int i = 0; i < tables.length; ++i) {
                tablesElement.appendChild(this.writeTable(tables[i], doc, context));
            }
        }

        private Element writeTable(IlrTableDataSourceModel.Table table, Document doc, IlrXmlMarshallingContext context) throws IlrErrorException {
            Element tableElem = doc.createElement("table");
            tableElem.setAttribute("name", table.getName());
            context.writeObject(table.getProperties(), tableElem);
            Element colsElem = doc.createElement("columns");
            tableElem.appendChild(colsElem);
            IlrTableDataSourceModel.Column[] cs = table.getColumns();
            for (int i = 0; i < cs.length; ++i) {
                IlrTableDataSourceModel.Column c = cs[i];
                Element columnElem = doc.createElement("column");
                colsElem.appendChild(columnElem);
                columnElem.setAttribute("name", c.getName());
                columnElem.setAttribute("type", c.getType().getName());
                context.writeObject(c.getProperties(), columnElem);
            }
            return tableElem;
        }

        @Override
        public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
            Element propsElem = context.getFirstElement(element, PROPERTIES_ELEMENT.getNamespaceURI(), PROPERTIES_ELEMENT.getLocalPart());
            IlrMutableStringMap prop = (IlrMutableStringMap)context.readObject(null, propsElem, IlrMutableStringMap.class);
            IlrDefaultDataSourceModel dsModel = new IlrDefaultDataSourceModel(prop);
            Element tablesElem = context.getNextElement(propsElem, null, "tables");
            NodeList tableElems = tablesElem.getElementsByTagName("table");
            for (int i = 0; i < tableElems.getLength(); ++i) {
                Element tableElem = (Element)tableElems.item(i);
                IlrMutableTableDataSourceModel.MutableTable table = this.readTable(tableElem, context);
                dsModel.addTable(table);
            }
            return dsModel;
        }

        private IlrMutableTableDataSourceModel.MutableTable readTable(Element tableElmt, IlrXmlUnmarshallingContext context) throws IlrErrorException {
            String name = tableElmt.getAttribute("name");
            Element propsElem = context.getFirstElement(tableElmt, PROPERTIES_ELEMENT.getNamespaceURI(), PROPERTIES_ELEMENT.getLocalPart());
            IlrMutableStringMap prop = (IlrMutableStringMap)context.readObject(null, propsElem, IlrMutableStringMap.class);
            IlrDefaultTableModel table = new IlrDefaultTableModel(name, prop);
            Element colsElem = context.getNextElement(propsElem, null, "columns");
            NodeList colElems = colsElem.getElementsByTagName("column");
            for (int i = 0; i < colElems.getLength(); ++i) {
                Element colElem = (Element)colElems.item(i);
                String colName = colElem.getAttribute("name");
                String typeStr = colElem.getAttribute("type");
                Class type = null;
                if (typeStr != null) {
                    try {
                        type = IlrUtil.getClassFromName(typeStr);
                    }
                    catch (Exception e) {
                        context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_DS_001", typeStr, colName, name));
                    }
                }
                Element colPropsElem = context.getFirstElement(colElem, PROPERTIES_ELEMENT.getNamespaceURI(), PROPERTIES_ELEMENT.getLocalPart());
                IlrMutableStringMap colProp = (IlrMutableStringMap)context.readObject(null, colPropsElem, IlrMutableStringMap.class);
                IlrDefaultColumnModel column = new IlrDefaultColumnModel(colName, type, colProp);
                table.addColumn(column);
            }
            return table;
        }

        @Override
        public Class[] getSupportedClasses() {
            return new Class[]{IlrDefaultDataSourceModel.class};
        }

        @Override
        public QName getXmlElement() {
            return DEFAULT_MODEL_ELEMENT;
        }

        @Override
        public QName getXmlType() {
            return DEFAULT_MODEL_TYPE;
        }

        @Override
        public QName getSchemaLocation() {
            return SCHEMA_LOCATION_QNAME;
        }

        @Override
        public boolean isReferenceWorthy() {
            return true;
        }
    }

    private static class IlrMemDataSourceConverter
    implements IlrXmlConverter,
    IlrXmlDSConstants {
        private IlrMemDataSourceConverter() {
        }

        @Override
        public void writeObject(Object object, Element dsElement, IlrXmlMarshallingContext context) throws IlrErrorException {
            IlrMemTableDataSource ds = (IlrMemTableDataSource)object;
            Document doc = context.getDocument();
            dsElement.setAttribute("name", ds.getName());
            context.writeObject(ds.getModel(), dsElement);
            try {
                this.writeRows(dsElement, ds, doc, context);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private void writeRows(Element dsElement, IlrMemTableDataSource ds, Document doc, IlrXmlMarshallingContext context) throws Exception {
            Element tablesElem = doc.createElement("tables");
            dsElement.appendChild(tablesElem);
            IlrTableDataSourceModel.Table[] tables = ds.getModel().getTables();
            for (int i = 0; i < tables.length; ++i) {
                Element rowsElem = doc.createElement("table");
                String tableName = tables[i].getName();
                rowsElem.setAttribute("name", tableName);
                tablesElem.appendChild(rowsElem);
                IlrTableDataSource.RowIterator rowIte = ds.iterateRows(tableName);
                while (rowIte.hasNext()) {
                    IlrTableDataSource.Row row = rowIte.nextRow();
                    Element rowElem = doc.createElement("row");
                    rowsElem.appendChild(rowElem);
                    this.writeRow(row, rowElem, doc, context);
                }
            }
        }

        private void writeRow(IlrTableDataSource.Row row, Element rowElem, Document doc, IlrXmlMarshallingContext context) throws IlrErrorException {
            Object[] objs = row.getCells();
            for (int i = 0; i < objs.length; ++i) {
                context.writeObject(objs[i], rowElem, new QName("cell"));
            }
        }

        @Override
        public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
            String name = element.getAttribute("name");
            Element modelElmt = context.getFirstElement(element, null, null);
            IlrTableDataSourceModel model = (IlrTableDataSourceModel)context.readObject(null, modelElmt, IlrTableDataSourceModel.class);
            if (model != null) {
                Element tablesElem = context.getNextElement(modelElmt, null, "tables");
                if (tablesElem == null) {
                    context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_009", "tables", modelElmt.toString()));
                } else {
                    IlrMemTableDataSource ds = new IlrMemTableDataSource(name, model);
                    this.readTables(tablesElem, ds, context);
                    return ds;
                }
            }
            return null;
        }

        private void readTables(Element tablesElem, IlrMemTableDataSource ds, IlrXmlUnmarshallingContext context) {
            NodeList tableElems = tablesElem.getElementsByTagName("table");
            for (int i = 0; i < tableElems.getLength(); ++i) {
                Element tableElem = (Element)tableElems.item(i);
                String tableName = tableElem.getAttribute("name");
                IlrTableDataSourceModel.Table table = ds.getModel().getTable(tableName);
                NodeList rowElems = tableElem.getElementsByTagName("row");
                for (int j = 0; j < rowElems.getLength(); ++j) {
                    Element rowElem = (Element)rowElems.item(j);
                    try {
                        IlrMutableTableDataSource.MutableRow row = ds.addRow(tableName);
                        this.readCell(rowElem, table, row, context);
                        continue;
                    }
                    catch (Exception e) {
                        context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_007", new String[]{e.getMessage()}, e));
                    }
                }
            }
        }

        private void readCell(Element rowElem, IlrTableDataSourceModel.Table table, IlrMutableTableDataSource.MutableRow row, IlrXmlUnmarshallingContext context) throws IlrErrorException {
            NodeList cellElems = rowElem.getElementsByTagName("cell");
            for (int i = 0; i < cellElems.getLength(); ++i) {
                Element cellElem = (Element)cellElems.item(i);
                IlrTableDataSourceModel.Column column = table.getColumn(i);
                Class type = column.getType();
                Object obj = null;
                IlrXmlConverter converter = context.getConverterFromClass(type);
                if (converter == null) {
                    context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_DS_001", type.getName(), column.getName(), table.getName()));
                } else {
                    obj = converter.readObject(cellElem, context);
                }
                row.setCell(i, obj);
            }
        }

        @Override
        public Class[] getSupportedClasses() {
            return new Class[]{IlrMemTableDataSource.class};
        }

        @Override
        public QName getXmlElement() {
            return MEM_DATASOURCE_ELEMENT;
        }

        @Override
        public QName getXmlType() {
            return MEM_DATASOURCE_TYPE;
        }

        @Override
        public QName getSchemaLocation() {
            return SCHEMA_LOCATION_QNAME;
        }

        @Override
        public boolean isReferenceWorthy() {
            return true;
        }
    }

    public static class ConverterProvider
    implements IlrXmlConverterProvider {
        @Override
        public void declareConverters(ArrayList converterList) {
            converterList.add(new IlrMemDataSourceConverter());
            converterList.add(new IlrDefaultDataSourceModelConverter());
            converterList.add(new IlrMutableStringMapConverter());
            converterList.add(new IlrXmlPoolConverters.DSDefaultKeyConverter());
            converterList.add(new IlrXmlPoolConverters.DSProxyConverter());
            converterList.add(new IlrXmlPoolConverters.DefaultDSPoolConverter());
            converterList.add(new IlrBooleanConverter());
            converterList.add(new IlrByteConverter());
            converterList.add(new IlrDoubleConverter());
            converterList.add(new IlrFloatConverter());
            converterList.add(new IlrIntConverter());
            converterList.add(new IlrLongConverter());
            converterList.add(new IlrShortConverter());
            converterList.add(new IlrStringConverter());
        }
    }
}

