/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.dvs.rsi;

import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bom.IlrAttribute;
import ilog.rules.bom.IlrCollectionDomain;
import ilog.rules.bom.IlrDomain;
import ilog.rules.bom.IlrDomainIntersection;
import ilog.rules.bom.IlrEnumeratedDomain;
import ilog.rules.bom.IlrObjectModel;
import ilog.rules.bom.IlrType;
import ilog.rules.bom.serializer.IlrSyntaxError;
import ilog.rules.dvs.rsi.internal.IlrCommonMessageHelper;
import ilog.rules.dvs.rsi.utils.IlrSerializationException;
import ilog.rules.factory.IlrReflect;
import ilog.rules.factory.proxy.IlrCompositeReflect;
import ilog.rules.vocabulary.model.util.IlrResourceLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class IlrObjectModelHelper {
    protected static final String XML_OBJECT_FQN = "ilog.rules.xml.IlrXmlObject";

    private IlrObjectModelHelper() {
    }

    public static boolean isOptional(IlrAttribute theAttribute) {
        boolean isClassMappedToXMLXOM;
        if (theAttribute == null) {
            throw new IllegalArgumentException();
        }
        boolean returnedValue = true;
        IlrObjectModel theBOM = theAttribute.getObjectModel();
        IlrType xmlObjectType = null;
        try {
            xmlObjectType = theBOM.getType(XML_OBJECT_FQN);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (xmlObjectType == null) {
            IlrObjectModel bootBom = IlrObjectModelHelper.loadBootBOM();
            try {
                xmlObjectType = bootBom.getType(XML_OBJECT_FQN);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            if (xmlObjectType == null) {
                throw new RuntimeException();
            }
        }
        if (isClassMappedToXMLXOM = xmlObjectType.isAssignableFrom((IlrType)theAttribute.getDeclaringClass())) {
            returnedValue = false;
            IlrDomain domain = theAttribute.getDomain();
            IlrCollectionDomain collectionDomain = IlrObjectModelHelper.getCollectionDomain(domain);
            if (collectionDomain != null && collectionDomain.getMin() == 0) {
                returnedValue = true;
            }
        }
        return returnedValue;
    }

    public static IlrCollectionDomain getCollectionDomain(IlrDomain theDomain) {
        IlrCollectionDomain returnedValue;
        block1: {
            IlrDomain domain;
            List domains;
            block2: {
                returnedValue = null;
                if (theDomain == null) break block1;
                if (!(theDomain instanceof IlrCollectionDomain)) break block2;
                returnedValue = (IlrCollectionDomain)theDomain;
                break block1;
            }
            if (!(theDomain instanceof IlrDomainIntersection) || (domains = ((IlrDomainIntersection)theDomain).getDomains()) == null) break block1;
            Iterator i$ = domains.iterator();
            while (i$.hasNext() && (returnedValue = IlrObjectModelHelper.getCollectionDomain(domain = (IlrDomain)i$.next())) == null) {
            }
        }
        return returnedValue;
    }

    public static IlrEnumeratedDomain getEnumeratedDomain(IlrDomain theDomain) {
        IlrEnumeratedDomain returnedValue;
        block1: {
            IlrDomain domain;
            List domains;
            block2: {
                returnedValue = null;
                if (theDomain == null) break block1;
                if (!(theDomain instanceof IlrEnumeratedDomain)) break block2;
                returnedValue = (IlrEnumeratedDomain)theDomain;
                break block1;
            }
            if (!(theDomain instanceof IlrDomainIntersection) || (domains = ((IlrDomainIntersection)theDomain).getDomains()) == null) break block1;
            Iterator i$ = domains.iterator();
            while (i$.hasNext() && (returnedValue = IlrObjectModelHelper.getEnumeratedDomain(domain = (IlrDomain)i$.next())) == null) {
            }
        }
        return returnedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCollection(IlrObjectModel bom, IlrType type) {
        if (bom == null && type == null) {
            throw new IllegalArgumentException();
        }
        boolean returnedValue = false;
        String collectionTypeFullyQualifiedName = "java.util.Collection";
        IlrObjectModel ilrObjectModel = bom;
        synchronized (ilrObjectModel) {
            IlrType collectionType = bom.getType("java.util.Collection");
            if (collectionType != null) {
                returnedValue = collectionType.isAssignableFrom(type);
            }
        }
        return returnedValue;
    }

    public static IlrReflect loadBOM(String[] theBOMFilesNames, ClassLoader theClassLoaderToLoadTheFileFrom) {
        if (theBOMFilesNames == null || theBOMFilesNames.length == 0) {
            throw new IllegalArgumentException();
        }
        IlrReflect bom = new IlrReflect(IlrObjectModel.Kind.BUSINESS);
        Reader[] readers = new Reader[theBOMFilesNames.length];
        try {
            for (int i = 0; i < theBOMFilesNames.length; ++i) {
                InputStream istream = IlrResourceLoader.openStream((String)theBOMFilesNames[i], (ClassLoader)theClassLoaderToLoadTheFileFrom);
                if (istream == null) {
                    for (int j = 0; j < i; ++j) {
                        readers[j].close();
                    }
                    throw new RuntimeException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_CANNOT_FIND_BOM_FILE_IN_CLASSPATH, new Object[]{theBOMFilesNames[i]}, null, null));
                }
                readers[i] = new InputStreamReader(istream);
            }
            bom.loadPath(readers);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IlrSyntaxError e) {
            throw new RuntimeException(e);
        }
        finally {
            for (Reader reader : readers) {
                try {
                    if (reader == null) continue;
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return bom;
    }

    public static IlrReflect extractBOM(IlrRulesetArchive theRulesetArchive) {
        if (theRulesetArchive == null) {
            throw new IllegalArgumentException();
        }
        IlrReflect bom = new IlrReflect(IlrObjectModel.Kind.BUSINESS);
        Collection bomElements = theRulesetArchive.getElements(1);
        if (bomElements.size() > 0) {
            Reader[] bomReaders = new Reader[bomElements.size()];
            int index = 0;
            for (IlrRulesetArchive.Element bomElement : bomElements) {
                try {
                    bomReaders[index++] = new StringReader(new String(bomElement.getContent(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                bom.loadPath(bomReaders);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (IlrSyntaxError e) {
                throw new RuntimeException(e);
            }
        }
        try {
            bom.loadPath(new Reader[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IlrSyntaxError e) {
            throw new RuntimeException(e);
        }
        return bom;
    }

    protected static IlrObjectModel loadBootBOM() {
        IlrCompositeReflect tempReflect = new IlrCompositeReflect(IlrObjectModel.Platform.JAVA, Collections.EMPTY_LIST);
        return tempReflect.getBootModel();
    }
}

