/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.dvs.rsi.internal;

import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import ilog.rules.bom.IlrAttribute;
import ilog.rules.bom.IlrConstructor;
import ilog.rules.bom.IlrParameter;
import ilog.rules.bom.IlrType;
import ilog.rules.bom.util.IlrClassUtilities;
import ilog.rules.dvs.rsi.IlrBOMTypeDescriptor;
import ilog.rules.dvs.rsi.IlrObjectModelServices;
import ilog.rules.dvs.rsi.exception.IlrBOMTypeNotFoundException;
import ilog.rules.dvs.rsi.exception.IlrMissingDefaultConstructorException;
import ilog.rules.dvs.rsi.exception.IlrObjectFactoryParametersException;
import ilog.rules.dvs.rsi.exception.IlrUnsupportedBOMTypeException;
import ilog.rules.dvs.rsi.internal.IlrCommonBusinessObjectModelServices;
import ilog.rules.dvs.rsi.internal.IlrCommonMessageHelper;
import ilog.rules.dvs.rsi.internal.IlrDefaultBOMTypeDescriptor;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameter;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameterValue;
import ilog.rules.dvs.rsi.ofactory.internal.IlrMetaArray;
import ilog.rules.dvs.rsi.ofactory.internal.IlrMetaObject;
import ilog.rules.dvs.rsi.utils.IlrHRSerializationUtils;
import ilog.rules.dvs.rsi.utils.IlrSerializationException;
import ilog.rules.engine.dataio.IlrTranslatedDataAccessStrategy;
import ilog.rules.factory.IlrDynamicArray;
import ilog.rules.factory.IlrReflect;
import ilog.rules.factory.IlrReflectClass;
import ilog.rules.factory.IlrReflectField;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class IlrCommonObjectModelServices
extends IlrCommonBusinessObjectModelServices
implements IlrObjectModelServices {
    private static final String META_OBJECT_CLASSNAME = IlrMetaObject.class.getName();
    private static final String META_ARRAY_CLASSNAME = IlrMetaArray.class.getName();
    private static final Logger LOGGER = Logger.getLogger(IlrCommonObjectModelServices.class.getName());
    IlrTranslatedDataAccessStrategy translatedDataAccessStrategy = null;

    public IlrCommonObjectModelServices(IlrTranslatedDataAccessStrategy theTranslatedDataAccessStrategy) {
        super((IlrReflect)theTranslatedDataAccessStrategy.getBom());
        this.translatedDataAccessStrategy = theTranslatedDataAccessStrategy;
    }

    @Override
    public Object createObjectInstance(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Map<String, IlrObjectFactoryParameterValue> theFactoryInputParameters) throws IlrUnsupportedBOMTypeException, IlrObjectFactoryParametersException {
        IlrCommonBusinessObjectModelServices.FactorySignature.SignatureType signatureType = this.internalGetObjectFactorySignature(theBOMTypeOfTheObject).getType();
        if (IlrCommonBusinessObjectModelServices.FactorySignature.SignatureType.BEAN.equals((Object)signatureType)) {
            return this.createObjectInstanceWithBeanFactory(theBOMTypeOfTheObject, theFactoryInputParameters);
        }
        return this.createObjectInstanceWithFormatterFactory(theBOMTypeOfTheObject, theFactoryInputParameters);
    }

    @Override
    public Class<?> getXOMClassMappingForBOMType(String theBOMType) throws ClassNotFoundException, IlrUnsupportedBOMTypeException {
        Object emptyArray = this.getNewXOMArrayInstanceForBOMType(theBOMType, 0);
        return emptyArray.getClass().getComponentType();
    }

    @Override
    public Object getNewXOMArrayInstanceForBOMType(String theBOMTypeFullyQualifiedName, int theArrayLength) throws ClassNotFoundException, IlrUnsupportedBOMTypeException {
        if (theBOMTypeFullyQualifiedName == null || theArrayLength < 0) {
            throw new IllegalArgumentException();
        }
        IlrType bomType = this.bom.getType(theBOMTypeFullyQualifiedName);
        if (bomType == null) {
            throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(theBOMTypeFullyQualifiedName, null));
        }
        return this.translatedDataAccessStrategy.newArrayInstance(bomType, theArrayLength);
    }

    protected Object createObjectInstanceWithBeanFactory(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Map<String, IlrObjectFactoryParameterValue> theFactoryInputParameters) throws IlrUnsupportedBOMTypeException, IlrObjectFactoryParametersException {
        Object returnedValue = null;
        IlrReflectClass clazz = this.bom.findClassByName(theBOMTypeOfTheObject.getFullyQualifiedName());
        if (clazz == null) {
            throw new IlrBOMTypeNotFoundException(theBOMTypeOfTheObject);
        }
        HashSet<String> constructorParametersNames = new HashSet<String>();
        if (IlrClassUtilities.isEnumClass((IlrType)clazz)) {
            String stringValueOfObjectParameter = null;
            stringValueOfObjectParameter = this.getMandatoryStringParameter(theFactoryInputParameters, "value", theBOMTypeOfTheObject);
            if ("java.lang.Boolean".equals(clazz.getFullyQualifiedName()) && ("true".equals(stringValueOfObjectParameter) || "false".equals(stringValueOfObjectParameter))) {
                stringValueOfObjectParameter = stringValueOfObjectParameter.toUpperCase();
            }
            constructorParametersNames.add("value");
            IlrAttribute attribute = clazz.getAttribute(stringValueOfObjectParameter);
            if (attribute != null && attribute.isStatic() && attribute.isReadonly()) {
                try {
                    returnedValue = this.translatedDataAccessStrategy.get(null, attribute);
                }
                catch (Throwable t) {
                    throw new IlrObjectFactoryParametersException(t);
                }
            }
            throw new IlrObjectFactoryParametersException(new RuntimeException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_VALUE_NOT_VALID_FOR_CLASS, new Object[]{stringValueOfObjectParameter, IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}, null, null)));
        }
        final IlrConstructor constructorToUse = this.getDefaultConstructor(clazz);
        List constructorParameters = constructorToUse.getParameters();
        int numberOfParameters = 0;
        if (constructorParameters != null) {
            numberOfParameters = constructorParameters.size();
        }
        final Object[] constructorArguments = new Object[numberOfParameters];
        for (int index = 0; index < numberOfParameters; ++index) {
            Object obj;
            IlrParameter parameter = (IlrParameter)constructorParameters.get(index);
            constructorParametersNames.add(parameter.getName());
            IlrObjectFactoryParameterValue parameterValue = theFactoryInputParameters.get(parameter.getName());
            if (parameterValue == null) {
                throw new IlrObjectFactoryParametersException(new RuntimeException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_MANDATORY_PARAMETER_IS_MISSING, new Object[]{parameter.getName(), IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}, null, null)));
            }
            constructorArguments[index] = obj = parameterValue.getValue();
            if (obj == null || !obj.getClass().getName().equals(META_ARRAY_CLASSNAME) && !obj.getClass().getName().equals(META_OBJECT_CLASSNAME)) continue;
            constructorArguments[index] = this.getObject(obj);
        }
        try {
            returnedValue = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return IlrCommonObjectModelServices.this.translatedDataAccessStrategy.newInstance(constructorToUse, constructorArguments);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }.run();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        this.setupInstance(theBOMTypeOfTheObject, theFactoryInputParameters, returnedValue, clazz, constructorParametersNames);
        return returnedValue;
    }

    protected Object createObjectInstanceWithFormatterFactory(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Map<String, IlrObjectFactoryParameterValue> theFactoryInputParameters) throws IlrUnsupportedBOMTypeException, IlrObjectFactoryParametersException {
        Object returnedValue = null;
        IlrReflectClass clazz = this.bom.findClassByName(theBOMTypeOfTheObject.getFullyQualifiedName());
        if (clazz == null) {
            throw new IlrBOMTypeNotFoundException(theBOMTypeOfTheObject);
        }
        HashSet<String> constructorParametersNames = new HashSet<String>();
        String formatFactoryParameterValue = this.getMandatoryStringParameter(theFactoryInputParameters, "value", theBOMTypeOfTheObject);
        constructorParametersNames.add("value");
        if (formatFactoryParameterValue != null) {
            try {
                returnedValue = clazz.getReflect().getFormat().parse((IlrType)clazz, formatFactoryParameterValue);
            }
            catch (Throwable t) {
                throw new IlrObjectFactoryParametersException(t);
            }
        }
        try {
            this.setupInstance(theBOMTypeOfTheObject, theFactoryInputParameters, returnedValue, clazz, constructorParametersNames);
        }
        catch (IlrMissingDefaultConstructorException e) {
            // empty catch block
        }
        return returnedValue;
    }

    private void setupInstance(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Map<String, IlrObjectFactoryParameterValue> theFactoryInputParameters, Object returnedValue, IlrReflectClass clazz, Set<String> constructorParametersNames) throws IlrUnsupportedBOMTypeException, IlrObjectFactoryParametersException {
        Map<String, IlrObjectFactoryParameter> factorySignature = this.getBeanFactorySignature(theBOMTypeOfTheObject);
        for (IlrObjectFactoryParameter parameter : factorySignature.values()) {
            String parameterName = parameter.getName();
            if (constructorParametersNames.contains(parameterName)) continue;
            IlrObjectFactoryParameterValue parameterValue = theFactoryInputParameters.get(parameterName);
            if (parameterValue == null) {
                if (parameter.isOptional()) continue;
                throw new IlrObjectFactoryParametersException(new RuntimeException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_MANDATORY_PARAMETER_IS_MISSING, new Object[]{parameter.getName(), IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}, null, null)));
            }
            IlrReflectField attributeToSet = clazz.getField(parameterName);
            if (attributeToSet != null) {
                try {
                    Object obj = parameterValue.getValue();
                    if (obj.getClass().getName().equals(META_ARRAY_CLASSNAME)) {
                        this.translatedDataAccessStrategy.set(returnedValue, (IlrAttribute)attributeToSet, this.getObject(obj));
                        continue;
                    }
                    if (obj.getClass().getName().equals(META_OBJECT_CLASSNAME)) {
                        this.translatedDataAccessStrategy.set(returnedValue, (IlrAttribute)attributeToSet, this.getObject(obj));
                        continue;
                    }
                    this.translatedDataAccessStrategy.set(returnedValue, (IlrAttribute)attributeToSet, obj);
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            throw new IlrObjectFactoryParametersException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_MISSING_ATTRIBUTE_IN_CLASS, new Object[]{parameterName, IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}, null, null));
        }
        this.postProcessNewlyCreatedInstance(theBOMTypeOfTheObject, theFactoryInputParameters, returnedValue);
    }

    protected Object getObject(Object obj) {
        try {
            Method m = obj.getClass().getMethod("getObject", null);
            return m.invoke(obj, (Object[])null);
        }
        catch (Exception e) {
            return obj;
        }
    }

    protected String getMandatoryStringParameter(Map<String, IlrObjectFactoryParameterValue> theFactoryInputParametersValues, String theNameOfTheMandatoryStringParameter, IlrBOMTypeDescriptor theBOMTypeOfTheObjectToBuild) throws IlrObjectFactoryParametersException {
        IlrObjectFactoryParameterValue factoryParameter = theFactoryInputParametersValues.get(theNameOfTheMandatoryStringParameter);
        if (factoryParameter == null) {
            throw new IlrObjectFactoryParametersException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_MANDATORY_PARAMETER_IS_MISSING, new Object[]{theNameOfTheMandatoryStringParameter, IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObjectToBuild)}, null, null));
        }
        String returnedValue = null;
        if (factoryParameter.getValue() != null) {
            if (!(factoryParameter.getValue() instanceof String)) {
                throw new IlrObjectFactoryParametersException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_VALUE_OF_MANDATORY_PARAMETER_MUST_BE_STRING, new Object[]{theNameOfTheMandatoryStringParameter, IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObjectToBuild)}, null, null));
            }
            returnedValue = (String)factoryParameter.getValue();
        }
        return returnedValue;
    }

    protected void postProcessNewlyCreatedInstance(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Map<String, IlrObjectFactoryParameterValue> theFactoryInputParameters, Object theInstance) throws IlrUnsupportedBOMTypeException, IlrObjectFactoryParametersException {
        IlrObjectFactoryParameterValue parameterValue;
        if (this.isCollection(theBOMTypeOfTheObject.getFullyQualifiedName()) && (parameterValue = theFactoryInputParameters.get("_content")) != null) {
            Object[] values = null;
            Object obj = parameterValue.getValue();
            Object valuesObj = obj.getClass().getName().equals(META_ARRAY_CLASSNAME) ? this.getObject(obj) : obj;
            try {
                if (valuesObj instanceof IlrDynamicArray) {
                    IlrDynamicArray dynamicArrayValue = (IlrDynamicArray)valuesObj;
                    values = new Object[dynamicArrayValue.length];
                    for (int i = 0; i < dynamicArrayValue.length; ++i) {
                        values[i] = dynamicArrayValue.get(i);
                    }
                } else {
                    values = (Object[])valuesObj;
                }
            }
            catch (ClassCastException e) {
                throw new IlrObjectFactoryParametersException(e);
            }
            if (values != null) {
                for (Object value : values) {
                    try {
                        ((Collection)theInstance).add(value);
                    }
                    catch (Throwable t) {
                        throw new IlrObjectFactoryParametersException(t);
                    }
                }
            }
        }
    }
}

