/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.dvs.rsi.internal;

import com.ibm.rules.dvs.rsi.de.ObjectModelHelper;
import com.ibm.rules.engine.lang.semantics.SemCollectionDomain;
import com.ibm.rules.engine.lang.semantics.SemDomain;
import com.ibm.rules.engine.lang.semantics.SemType;
import ilog.rules.bom.IlrCollectionDomain;
import ilog.rules.bom.IlrDomain;
import ilog.rules.bom.IlrEnumeratedDomain;
import ilog.rules.bom.IlrType;
import ilog.rules.dvs.rsi.IlrBOMTypeDescriptor;
import ilog.rules.dvs.rsi.IlrObjectModelHelper;
import java.util.Arrays;
import java.util.List;

public class IlrDefaultBOMTypeDescriptor
implements IlrBOMTypeDescriptor {
    private static final long serialVersionUID = 7119444130792594695L;
    private String fullyQualifiedName = null;
    private IlrBOMTypeDescriptor elementsType = null;
    private String[] domainValues = null;

    public IlrDefaultBOMTypeDescriptor(String theFullyQualifiedName, IlrBOMTypeDescriptor theElementsType) {
        if (theFullyQualifiedName == null || "".equals(theFullyQualifiedName.trim())) {
            throw new IllegalArgumentException();
        }
        this.fullyQualifiedName = theFullyQualifiedName;
        this.elementsType = theElementsType;
    }

    public IlrDefaultBOMTypeDescriptor(IlrType theBOMType) {
        this.fullyQualifiedName = theBOMType.getFullyQualifiedName();
        IlrDomain domain = theBOMType.getDomain();
        this.domainValues = IlrDefaultBOMTypeDescriptor.getDomainValues(domain, this.fullyQualifiedName);
        if (domain != null && domain instanceof IlrCollectionDomain) {
            IlrCollectionDomain collectionDomain = (IlrCollectionDomain)domain;
            this.elementsType = new IlrDefaultBOMTypeDescriptor(collectionDomain.getElementType());
        }
    }

    public IlrDefaultBOMTypeDescriptor(SemType theBOMType) {
        SemType collectionDomainElementType;
        SemCollectionDomain collectionDomain;
        this.fullyQualifiedName = ObjectModelHelper.getFullyQualifiedNameForType(theBOMType);
        this.domainValues = ObjectModelHelper.getDomainValues(theBOMType);
        SemDomain domain = ObjectModelHelper.getDomainForType(theBOMType);
        if (domain != null && (collectionDomain = ObjectModelHelper.getCollectionDomain(domain)) != null && (collectionDomainElementType = collectionDomain.getElementType()) != null) {
            this.elementsType = new IlrDefaultBOMTypeDescriptor(collectionDomainElementType);
        }
    }

    public IlrDefaultBOMTypeDescriptor() {
    }

    public static String[] getDomainValues(IlrDomain theDomain, String theFullyQualifiedNameOfTheClassForWhichTheDomainIsDefined) {
        List values;
        String[] returnedValue = null;
        IlrEnumeratedDomain enumeratedDomain = IlrObjectModelHelper.getEnumeratedDomain(theDomain);
        if (enumeratedDomain != null && (values = enumeratedDomain.getValues()) != null) {
            String[] domainValues = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                domainValues[i] = String.valueOf(values.get(i));
                try {
                    if (!domainValues[i].startsWith(new StringBuffer(theFullyQualifiedNameOfTheClassForWhichTheDomainIsDefined).append(".").toString())) continue;
                    domainValues[i] = domainValues[i].substring(theFullyQualifiedNameOfTheClassForWhichTheDomainIsDefined.length() + 1);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            returnedValue = domainValues;
        }
        return returnedValue;
    }

    @Override
    public IlrBOMTypeDescriptor getElementsType() {
        return this.elementsType;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public String[] getDomainValues() {
        return this.domainValues;
    }

    public void setFullyQualifiedName(String theFullyQualifiedName) {
        this.fullyQualifiedName = theFullyQualifiedName;
    }

    public void setElementsType(IlrBOMTypeDescriptor theElementsType) {
        this.elementsType = theElementsType;
    }

    public void setDomainValues(String[] theDomainValues) {
        this.domainValues = theDomainValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.domainValues);
        result = 31 * result + (this.elementsType == null ? 0 : this.elementsType.hashCode());
        result = 31 * result + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IlrDefaultBOMTypeDescriptor other = (IlrDefaultBOMTypeDescriptor)obj;
        if (!Arrays.equals(this.domainValues, other.domainValues)) {
            return false;
        }
        if (this.elementsType == null ? other.elementsType != null : !this.elementsType.equals(other.elementsType)) {
            return false;
        }
        return !(this.fullyQualifiedName == null ? other.fullyQualifiedName != null : !this.fullyQualifiedName.equals(other.fullyQualifiedName));
    }
}

