/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.dvs.rsi.internal;

import ilog.rules.bom.IlrAttribute;
import ilog.rules.bom.IlrClass;
import ilog.rules.bom.IlrObjectModel;
import ilog.rules.dvs.rsi.IlrBOMTypeDescriptor;
import ilog.rules.dvs.rsi.IlrObjectModelHelper;
import ilog.rules.dvs.rsi.IlrRulesetVerbalizationProvider;
import ilog.rules.dvs.rsi.exception.IlrUnsupportedBOMTypeException;
import ilog.rules.dvs.rsi.internal.IlrCommonBusinessObjectModelServices;
import ilog.rules.factory.IlrReflect;
import ilog.rules.vocabulary.model.IlrConcept;
import ilog.rules.vocabulary.model.IlrConceptInstance;
import ilog.rules.vocabulary.model.IlrFactType;
import ilog.rules.vocabulary.model.IlrRole;
import ilog.rules.vocabulary.model.IlrTerm;
import ilog.rules.vocabulary.model.IlrVerbalizable;
import ilog.rules.vocabulary.model.IlrVocabulary;
import ilog.rules.vocabulary.model.helper.IlrVocabularyHelper;
import ilog.rules.vocabulary.verbalization.IlrDefaultTermBuilder;
import ilog.rules.vocabulary.verbalization.IlrTermBuilder;
import ilog.rules.vocabulary.verbalization.IlrVerbalizer;
import ilog.rules.vocabulary.verbalization.IlrVerbalizerHelper;
import ilog.rules.vocabulary.verbalization.IlrVerbalizerRegistry;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class IlrDefaultRulesetVerbalizationProvider
implements IlrRulesetVerbalizationProvider {
    private IlrVocabulary vocabulary = null;
    private IlrObjectModel bom = null;
    private Map<String, String> rulesetParametersVerbalization = new HashMap<String, String>();
    private IlrTermBuilder termBuilder = null;
    private boolean useDefaultVerbalizationWhenNoneAvailable = false;

    public IlrDefaultRulesetVerbalizationProvider(IlrVocabulary theVocabulary, Map<String, String> theVerbalizationOfTheRulesetParameters) {
        if (theVocabulary == null) {
            throw new IllegalArgumentException();
        }
        this.vocabulary = theVocabulary;
        IlrVerbalizer verbalizer = IlrVerbalizerRegistry.getDefault().getVerbalizer(theVocabulary.getLocale());
        this.termBuilder = verbalizer != null ? verbalizer.getTermBuilder() : new IlrDefaultTermBuilder();
        if (theVerbalizationOfTheRulesetParameters != null) {
            this.rulesetParametersVerbalization = theVerbalizationOfTheRulesetParameters;
        }
    }

    public IlrDefaultRulesetVerbalizationProvider(IlrObjectModel theBOM, IlrVocabulary theVocabulary, Map<String, String> theVerbalizationOfTheRulesetParameters) {
        if (theVocabulary == null) {
            throw new IllegalArgumentException();
        }
        this.bom = theBOM;
        this.vocabulary = theVocabulary;
        IlrVerbalizer verbalizer = IlrVerbalizerRegistry.getDefault().getVerbalizer(theVocabulary.getLocale());
        this.termBuilder = verbalizer != null ? verbalizer.getTermBuilder() : new IlrDefaultTermBuilder();
        if (theVerbalizationOfTheRulesetParameters != null) {
            this.rulesetParametersVerbalization = theVerbalizationOfTheRulesetParameters;
        }
    }

    @Override
    public String getBOMTypeAttributeVerbalization(String theBOMType, String theAttributeName) {
        if (theBOMType == null || theAttributeName == null) {
            throw new IllegalArgumentException();
        }
        String bomType = theBOMType;
        boolean usePlural = false;
        if (this.bom != null) {
            IlrAttribute attribute;
            IlrCommonBusinessObjectModelServices businessObjectModelServices = new IlrCommonBusinessObjectModelServices((IlrReflect)this.bom);
            try {
                IlrBOMTypeDescriptor typeDescriptor = businessObjectModelServices.getFieldDeclaringClass(bomType, theAttributeName);
                if (typeDescriptor != null) {
                    bomType = typeDescriptor.getFullyQualifiedName();
                }
            }
            catch (IlrUnsupportedBOMTypeException e) {
                // empty catch block
            }
            IlrClass clazz = this.bom.getClass(bomType);
            if (clazz != null && (attribute = clazz.getAttribute(theAttributeName)) != null) {
                usePlural = IlrObjectModelHelper.isCollection(this.bom, attribute.getAttributeType()) || attribute.getAttributeType().isArray();
            }
        }
        String returnedValue = theAttributeName;
        IlrFactType attributeFact = this.vocabulary.getFactType(bomType + "/" + theAttributeName);
        if (attributeFact == null) {
            IlrTerm term;
            if (this.useDefaultVerbalizationWhenNoneAvailable && (term = this.termBuilder.getTerm(theAttributeName, null, false)) != null) {
                returnedValue = term.getLabel();
            }
        } else {
            IlrRole attributeRoleInFact = IlrVocabularyHelper.getOwnedRole((IlrFactType)attributeFact);
            if (attributeRoleInFact != null) {
                String singularVerbalization = attributeRoleInFact.getLabel();
                if (usePlural) {
                    IlrTerm pluralTerm = this.vocabulary.getGlossary().getTerm(singularVerbalization);
                    if (pluralTerm != null) {
                        returnedValue = pluralTerm.getPluralLabel();
                        if (returnedValue == null) {
                            returnedValue = IlrVerbalizerHelper.getDefaultPlural((IlrVerbalizable)attributeRoleInFact, (IlrVocabulary)this.vocabulary);
                        }
                    } else {
                        returnedValue = IlrVerbalizerHelper.getDefaultPlural((IlrVerbalizable)attributeRoleInFact, (IlrVocabulary)this.vocabulary);
                    }
                } else {
                    returnedValue = attributeRoleInFact.getLabel();
                }
            }
        }
        return returnedValue;
    }

    @Override
    public String getBOMTypeVerbalization(String theBOMType) {
        if (theBOMType == null) {
            throw new IllegalArgumentException();
        }
        String returnedValue = theBOMType;
        IlrConcept conceptForTheBOMType = this.vocabulary.getConcept(theBOMType);
        if (conceptForTheBOMType != null) {
            returnedValue = conceptForTheBOMType.getLabel();
            if (returnedValue == null) {
                returnedValue = conceptForTheBOMType.getName();
            }
            if (returnedValue == null) {
                returnedValue = theBOMType;
            }
        }
        return returnedValue;
    }

    @Override
    public String getBOMTypeDomainValueVerbalization(String theBOMType, String theDomainValue) {
        if (theBOMType == null || theDomainValue == null) {
            throw new IllegalArgumentException();
        }
        String returnedValue = theDomainValue;
        IlrConceptInstance conceptInstance = this.vocabulary.getConceptInstance(theBOMType + "/" + theDomainValue);
        if (conceptInstance != null) {
            returnedValue = conceptInstance.getLabel();
        }
        return returnedValue;
    }

    @Override
    public Locale getLocale() {
        return this.vocabulary.getLocale();
    }

    @Override
    public String getRulesetParameterVerbalization(String theRulesetParameterName) {
        if (theRulesetParameterName == null) {
            throw new IllegalArgumentException();
        }
        String returnedValue = this.rulesetParametersVerbalization.get(theRulesetParameterName);
        if (returnedValue == null) {
            returnedValue = theRulesetParameterName;
        } else if (returnedValue.trim().length() == 0) {
            returnedValue = theRulesetParameterName;
        }
        return returnedValue;
    }

    @Override
    public IlrVocabulary getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public void setUseDefaultVerbalizationWhenNoneAvailable(boolean theFlag) {
        this.useDefaultVerbalizationWhenNoneAvailable = theFlag;
    }

    @Override
    public boolean useDefaultVerbalizationWhenNoneAvailable() {
        return this.useDefaultVerbalizationWhenNoneAvailable;
    }
}

