/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.dvs.rsi.utils;

import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import ilog.rules.dvs.rsi.internal.IlrCommonMessageHelper;
import ilog.rules.dvs.rsi.utils.IlrSerializationException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IlrXUStringCodec<T> {
    private static final String STRING_ELEMENT = "string";
    private static final String NULL_ELEMENT = "null";
    private static final String ARRAY_ELEMENT = "array";
    private static final String ARRAY_LENGTH_ATTRIBUTE = "length";
    private static final String ARRAY_ELEMENTS_TYPE_ATTRIBUTE = "elementsType";
    private static final String ENUM_ELEMENT = "enum";
    private static final String ENUM_TYPE_ATTRIBUTE = "type";
    private static final String FIELD_ELEMENT = "field";
    private static final String FIELD_NAME_ATTRIBUTE = "name";
    private static final String FIELD_IS_ARRAY_ATTRIBUTE = "is-array";
    private static final String FIELD_TYPE_ATTRIBUTE = "type";
    private static SAXParserFactory parserFactory = null;

    public String encode(T theObjectToEncode) {
        StringBuffer output = new StringBuffer();
        output.append("<?xml version='1.0' encoding='UTF-8'?>");
        try {
            output.append(this.encodeObjectToXML(theObjectToEncode, 0));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return output.toString();
    }

    public T decode(String theEncodedObject) {
        Object returnedValue = null;
        SAXParser parser = null;
        try {
            parser = IlrXUStringCodec.CreateSAXParser();
            StringReader reader = new StringReader(theEncodedObject);
            SerializedObjectHandler handler = new SerializedObjectHandler();
            parser.parse(new InputSource(reader), (DefaultHandler)handler);
            returnedValue = handler.getReadenObject();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return (T)returnedValue;
    }

    protected String encodeObjectToXML(Object theObjectToEncode, int indentLevel) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        StringBuffer output = new StringBuffer();
        if (theObjectToEncode != null) {
            Class<?> objectClass = theObjectToEncode.getClass();
            boolean objectIsString = "java.lang.String".equals(objectClass.getName());
            if (objectIsString) {
                output.append("\n");
                this.appendTabs(output, indentLevel);
                output.append("<");
                output.append(STRING_ELEMENT);
                output.append(">");
                output.append(this.getCDATAString(theObjectToEncode.toString()));
                output.append("</");
                output.append(STRING_ELEMENT);
                output.append(">");
            } else {
                boolean objectIsAnArray = objectClass.isArray();
                boolean objectIsAnEnum = objectClass.isEnum();
                if (objectIsAnArray) {
                    output.append("\n");
                    this.appendTabs(output, indentLevel);
                    output.append("<");
                    output.append(ARRAY_ELEMENT);
                    output.append(" ");
                    output.append(ARRAY_LENGTH_ATTRIBUTE);
                    output.append("='");
                    output.append(Array.getLength(theObjectToEncode));
                    output.append("' ");
                    output.append(ARRAY_ELEMENTS_TYPE_ATTRIBUTE);
                    output.append("='");
                    output.append(IlrXUStringCodec.getXMLStringForClassName(this.getFQNOfArrayElements(objectClass)));
                    output.append("'>");
                } else if (objectIsAnEnum) {
                    output.append("\n");
                    this.appendTabs(output, indentLevel);
                    output.append("<");
                    output.append(ENUM_ELEMENT);
                    output.append(" ");
                    output.append("type");
                    output.append("='");
                    output.append(IlrXUStringCodec.getXMLStringForClassName(objectClass.getName()));
                    output.append("'>");
                    output.append(String.valueOf(theObjectToEncode));
                } else {
                    output.append("\n");
                    this.appendTabs(output, indentLevel);
                    output.append("<");
                    output.append(IlrXUStringCodec.getXMLStringForClassName(objectClass.getName()));
                    output.append(">");
                }
                if (objectIsAnArray) {
                    int length = Array.getLength(theObjectToEncode);
                    for (int i = 0; i < length; ++i) {
                        output.append(this.encodeObjectToXML(Array.get(theObjectToEncode, i), indentLevel + 1));
                    }
                }
                if (!objectIsAnEnum && !objectIsAnArray) {
                    Method[] methods;
                    HashSet<FieldInfo> readableAttributes = new HashSet<FieldInfo>();
                    HashSet<FieldInfo> writableAttributes = new HashSet<FieldInfo>();
                    for (Method method : methods = theObjectToEncode.getClass().getMethods()) {
                        String methodName = method.getName();
                        Class<?>[] methodParameterTypes = method.getParameterTypes();
                        Class<?> methodReturnType = method.getReturnType();
                        if (methodName.startsWith("set") && methodParameterTypes.length == 1) {
                            writableAttributes.add(new FieldInfo(methodName.substring(3), methodParameterTypes[0]));
                            continue;
                        }
                        if (!methodName.startsWith("get") || methodParameterTypes.length != 0) continue;
                        FieldInfo fi = new FieldInfo(methodName.substring(3), methodReturnType);
                        fi.setReader(method);
                        readableAttributes.add(fi);
                    }
                    for (FieldInfo fieldInfo : readableAttributes) {
                        if (!writableAttributes.contains(fieldInfo)) continue;
                        boolean fieldIsAnArray = fieldInfo.getType().isArray();
                        String fieldType = fieldInfo.getType().getName();
                        if (fieldIsAnArray) {
                            fieldType = this.getFQNOfArrayElements(fieldInfo.getType());
                        }
                        output.append("\n");
                        this.appendTabs(output, indentLevel + 1);
                        output.append("<");
                        output.append(FIELD_ELEMENT);
                        output.append(" ");
                        output.append(FIELD_NAME_ATTRIBUTE);
                        output.append("='");
                        output.append(IlrXUStringCodec.getXMLStringForClassName(fieldInfo.getName()));
                        output.append("' ");
                        output.append(FIELD_IS_ARRAY_ATTRIBUTE);
                        output.append("='");
                        output.append(fieldIsAnArray);
                        output.append("' ");
                        output.append("type");
                        output.append("='");
                        output.append(IlrXUStringCodec.getXMLStringForClassName(fieldType));
                        output.append("'>");
                        output.append(this.encodeObjectToXML(fieldInfo.getReader().invoke(theObjectToEncode, new Object[0]), indentLevel + 1));
                        output.append("\n");
                        this.appendTabs(output, indentLevel + 1);
                        output.append("</");
                        output.append(FIELD_ELEMENT);
                        output.append(">");
                    }
                }
                if (objectIsAnArray) {
                    output.append("\n");
                    this.appendTabs(output, indentLevel);
                    output.append("</");
                    output.append(ARRAY_ELEMENT);
                    output.append(">");
                } else if (objectIsAnEnum) {
                    output.append("</");
                    output.append(ENUM_ELEMENT);
                    output.append(">");
                } else {
                    output.append("\n");
                    this.appendTabs(output, indentLevel);
                    output.append("</");
                    output.append(IlrXUStringCodec.getXMLStringForClassName(objectClass.getName()));
                    output.append(">");
                }
            }
        } else {
            output.append("\n");
            this.appendTabs(output, indentLevel);
            output.append("<");
            output.append(NULL_ELEMENT);
            output.append("/>");
        }
        return output.toString();
    }

    protected String getCDATAString(String theString) {
        StringBuffer returnedValue = new StringBuffer();
        returnedValue.append("<![CDATA[");
        returnedValue.append(theString);
        returnedValue.append("]]>");
        return returnedValue.toString();
    }

    protected String getFQNOfArrayElements(Class<?> theArrayType) {
        if (!theArrayType.isArray()) {
            throw new IllegalArgumentException();
        }
        return theArrayType.getName().substring(2, theArrayType.getName().length() - 1);
    }

    protected static String getXMLStringForClassName(String theClassName) {
        return theClassName.replace("$", "..");
    }

    protected static String getClassNameFromXMLString(String theXMLString) {
        return theXMLString.replace("..", "$");
    }

    protected void appendTabs(StringBuffer theStringBufferToAppendTabsTo, int theNumberOfTabsToAppend) {
        for (int i = 0; i < theNumberOfTabsToAppend; ++i) {
            theStringBufferToAppendTabsTo.append("\t");
        }
    }

    protected static synchronized SAXParser CreateSAXParser() throws ParserConfigurationException, SAXException {
        if (parserFactory == null) {
            parserFactory = SAXParserFactory.newInstance();
        }
        return parserFactory.newSAXParser();
    }

    private static final class SerializedObjectHandler
    extends DefaultHandler {
        private Stack<Object> objects = null;
        private Stack<String> fieldsNames = null;
        private Stack<Class<?>> fieldsClasses = null;
        private boolean pushNextStringToStack = false;
        private StringBuffer nextStringBuffer = null;
        private boolean pushNextStringToStackAsAnEnum = false;
        private StringBuffer nextEnumStringBuffer = null;
        private String nextEnumFQN = null;
        private boolean currentObjectIsAnArray = false;
        private int currentArrayIndex = 0;

        private SerializedObjectHandler() {
        }

        public Object getReadenObject() {
            if (this.objects.size() != 1) {
                throw new IllegalStateException();
            }
            return this.objects.peek();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            if (this.pushNextStringToStack) {
                this.nextStringBuffer.append(ch, start, length);
            } else if (this.pushNextStringToStackAsAnEnum) {
                this.nextEnumStringBuffer.append(ch, start, length);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.objects = new Stack();
            this.fieldsNames = new Stack();
            this.fieldsClasses = new Stack();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, name, attributes);
            try {
                if (IlrXUStringCodec.NULL_ELEMENT.equals(name)) {
                    this.pushObject(null);
                } else if (IlrXUStringCodec.ARRAY_ELEMENT.equals(name)) {
                    int arrayLength = Integer.parseInt(attributes.getValue("", IlrXUStringCodec.ARRAY_LENGTH_ATTRIBUTE));
                    this.pushObject(Array.newInstance(Class.forName(IlrXUStringCodec.getClassNameFromXMLString(attributes.getValue("", IlrXUStringCodec.ARRAY_ELEMENTS_TYPE_ATTRIBUTE))), arrayLength));
                    this.currentObjectIsAnArray = true;
                    this.currentArrayIndex = 0;
                } else if (IlrXUStringCodec.ENUM_ELEMENT.equals(name)) {
                    this.pushNextStringToStackAsAnEnum = true;
                    this.nextEnumFQN = IlrXUStringCodec.getClassNameFromXMLString(attributes.getValue("", "type"));
                    this.nextEnumStringBuffer = new StringBuffer();
                } else if (IlrXUStringCodec.FIELD_ELEMENT.equals(name)) {
                    this.fieldsNames.push(attributes.getValue("", IlrXUStringCodec.FIELD_NAME_ATTRIBUTE));
                    Class<?> fieldClass = null;
                    String typeFQN = IlrXUStringCodec.getClassNameFromXMLString(attributes.getValue("", "type"));
                    if (Boolean.valueOf(attributes.getValue("", IlrXUStringCodec.FIELD_IS_ARRAY_ATTRIBUTE)).booleanValue()) {
                        Object array = Array.newInstance(Class.forName(typeFQN), 0);
                        fieldClass = array.getClass();
                        array = null;
                    } else {
                        fieldClass = Class.forName(typeFQN);
                    }
                    this.fieldsClasses.push(fieldClass);
                } else if (IlrXUStringCodec.STRING_ELEMENT.equals(name)) {
                    this.pushNextStringToStack = true;
                    this.nextStringBuffer = new StringBuffer();
                } else {
                    Class<?> objectClass = Class.forName(IlrXUStringCodec.getClassNameFromXMLString(name));
                    Constructor<?> noArgsConstructor = objectClass.getConstructor(new Class[0]);
                    this.pushObject(noArgsConstructor.newInstance(new Object[0]));
                }
            }
            catch (Exception t) {
                throw new SAXException(t);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            super.endElement(uri, localName, name);
            try {
                if (IlrXUStringCodec.FIELD_ELEMENT.equals(name)) {
                    String fieldName = this.fieldsNames.pop();
                    Class<?> fieldType = this.fieldsClasses.pop();
                    Object fieldValue = this.objects.pop();
                    Object objectToSetFieldValueTo = this.objects.peek();
                    if (objectToSetFieldValueTo == null) {
                        throw new RuntimeException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_CANNOT_FIND_BOM_FILE_IN_CLASSPATH, null, null, null));
                    }
                    objectToSetFieldValueTo.getClass().getMethod("set" + fieldName, fieldType).invoke(objectToSetFieldValueTo, fieldValue);
                } else if (IlrXUStringCodec.STRING_ELEMENT.equals(name)) {
                    this.pushNextStringToStack = false;
                    this.pushObject(this.nextStringBuffer.toString());
                    this.nextStringBuffer = null;
                } else if (IlrXUStringCodec.ENUM_ELEMENT.equals(name)) {
                    this.pushNextStringToStackAsAnEnum = false;
                    this.pushObject(Enum.valueOf(Class.forName(this.nextEnumFQN), this.nextEnumStringBuffer.toString()));
                    this.nextEnumStringBuffer = null;
                    this.nextEnumFQN = null;
                } else if (IlrXUStringCodec.ARRAY_ELEMENT.equals(name)) {
                    this.currentObjectIsAnArray = false;
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        protected void pushObject(Object theObject) {
            if (this.currentObjectIsAnArray) {
                Array.set(this.objects.peek(), this.currentArrayIndex++, theObject);
            } else {
                this.objects.push(theObject);
            }
        }
    }

    private static class FieldInfo {
        private String name;
        private Class<?> type;
        private Method reader;

        public FieldInfo(String theNameOfTheField, Class<?> theTypeOfTheField) {
            this.name = theNameOfTheField;
            this.type = theTypeOfTheField;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public Method getReader() {
            return this.reader;
        }

        public void setReader(Method reader) {
            this.reader = reader;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldInfo other = (FieldInfo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

