/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mbean.util;

import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.mbean.util.InvocationResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

class IlrMBeanManagerImpl
implements IlrMBeanManager {
    protected static final int INVOC_METHOD = 1;
    protected static final int INVOC_SET = 2;
    protected static final int INVOC_GET = 3;
    protected Properties props = new Properties();
    protected String typeElement;
    protected String domain;
    protected MBeanServer mbeanServer = null;
    protected UnregisterPrivilegedExceptionAction unregisterAction = new UnregisterPrivilegedExceptionAction();

    public IlrMBeanManagerImpl(Properties props) {
        this("type", "RES", props);
    }

    IlrMBeanManagerImpl(String typeElement, String domain, Properties props) {
        this.typeElement = typeElement;
        this.domain = domain;
        if (props != null) {
            this.props = props;
        }
    }

    @Override
    public void initMBeanManager() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
                IlrMBeanManagerImpl.this.mbeanServer = servers.size() > 0 ? servers.get(0) : MBeanServerFactory.createMBeanServer();
                return null;
            }
        });
    }

    @Override
    public Properties getProperties() {
        return (Properties)this.props.clone();
    }

    @Override
    public String getImplementationName() {
        return "Sun";
    }

    @Override
    public MBeanServer getLocalMBeanServer() {
        return this.mbeanServer;
    }

    @Override
    public ObjectName registerMBean(String type, Properties properties, final Object object) throws Exception {
        properties.setProperty(this.typeElement, type);
        Hashtable<String, String> propsAsMap = new Hashtable<String, String>();
        for (Object key : properties.keySet()) {
            String keyStr = (String)key;
            String valStr = properties.getProperty(keyStr);
            propsAsMap.put(keyStr, valStr);
        }
        final ObjectName objectName = new ObjectName(this.domain, propsAsMap);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectName>(){

                @Override
                public ObjectName run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                    ObjectInstance instance = IlrMBeanManagerImpl.this.mbeanServer.registerMBean(object, objectName);
                    return instance.getObjectName();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    public synchronized void unregisterMBean(ObjectName objectName) throws Exception {
        try {
            this.unregisterAction.init(this.mbeanServer, objectName);
            AccessController.doPrivileged(this.unregisterAction);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    public Set<ObjectName> findLocalMBeans(final ObjectName query) {
        return AccessController.doPrivileged(new PrivilegedAction<Set<ObjectName>>(){

            @Override
            public Set<ObjectName> run() {
                return IlrMBeanManagerImpl.this.mbeanServer.queryNames(query, null);
            }
        });
    }

    @Override
    public List<InvocationResult> getAttribute(ObjectName query, String attributeName) {
        return this.invoke(3, null, query, attributeName, null, null);
    }

    @Override
    public List<InvocationResult> getAttribute(String serverInfoQuery, ObjectName query, String attributeName) {
        return this.invoke(3, serverInfoQuery, query, attributeName, null, null);
    }

    @Override
    public List<InvocationResult> setAttribute(ObjectName query, String attributeName, Object attributeValue) {
        return this.invoke(2, null, query, attributeName, new Object[]{attributeValue}, null);
    }

    @Override
    public List<InvocationResult> setAttribute(String serverInfoQuery, ObjectName query, String attributeName, Object attributeValue) {
        return this.invoke(2, serverInfoQuery, query, attributeName, new Object[]{attributeValue}, null);
    }

    @Override
    public List<InvocationResult> invoke(ObjectName query, String operationName, Object[] params, String[] signature) {
        return this.invoke(1, null, query, operationName, params, signature);
    }

    @Override
    public List<InvocationResult> invoke(String serverInfoQuery, ObjectName query, String operationName, Object[] params, String[] signature) {
        return this.invoke(1, serverInfoQuery, query, operationName, params, signature);
    }

    public ObjectName addLocationToObjectName(ObjectName on, String locationKey, String locationValue) {
        if (locationValue != null) {
            String ons = on.getCanonicalName();
            int index = ons.indexOf(58);
            StringBuffer buff = new StringBuffer();
            buff.append(ons.substring(0, index + 1));
            buff.append(locationKey);
            buff.append('=');
            buff.append(locationValue);
            buff.append(',');
            buff.append(ons.substring(index + 1));
            try {
                return new ObjectName(buff.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return on;
    }

    @Override
    public ObjectName getQuery(String type) throws MalformedObjectNameException {
        return this.getQuery(type, null, null);
    }

    @Override
    public ObjectName getQuery(String type, Properties filter) throws MalformedObjectNameException {
        return this.getQuery(type, null, filter);
    }

    @Override
    public ObjectName getQuery(String type, String queryPart, Properties filter) throws MalformedObjectNameException {
        StringBuffer buff = new StringBuffer();
        buff.append(this.domain);
        buff.append(':');
        if (type != null) {
            buff.append(this.typeElement);
            buff.append('=');
            buff.append(type);
            buff.append(',');
        }
        if (queryPart != null) {
            buff.append(queryPart);
            buff.append(',');
        }
        if (filter != null) {
            for (Map.Entry<Object, Object> entry : filter.entrySet()) {
                buff.append(entry.getKey());
                buff.append('=');
                buff.append(entry.getValue());
                buff.append(',');
            }
        }
        buff.append("*");
        return new ObjectName(buff.toString());
    }

    protected List<InvocationResult> invoke(final int type, String serverInfoQuery, final ObjectName query, final String operationName, final Object[] params, final String[] signature) {
        return AccessController.doPrivileged(new PrivilegedAction<List<InvocationResult>>(){

            @Override
            public List<InvocationResult> run() {
                ArrayList<InvocationResult> result = new ArrayList<InvocationResult>();
                Set<ObjectName> objectNames = IlrMBeanManagerImpl.this.mbeanServer.queryNames(query, null);
                Iterator<ObjectName> i$ = objectNames.iterator();
                while (i$.hasNext()) {
                    ObjectName name;
                    ObjectName objectName = name = i$.next();
                    result.add(IlrMBeanManagerImpl.this.invokeDispatcher(IlrMBeanManagerImpl.this.mbeanServer, "localhost", type, objectName, operationName, params, signature));
                }
                return result;
            }
        });
    }

    protected InvocationResult invokeDispatcher(MBeanServerConnection server, String serverInfo, int type, ObjectName objectName, String operationName, Object[] params, String[] signature) {
        Object result = null;
        try {
            switch (type) {
                case 1: {
                    result = server.invoke(objectName, operationName, params, signature);
                    break;
                }
                case 2: {
                    server.setAttribute(objectName, new Attribute(operationName, params[0]));
                    break;
                }
                case 3: {
                    result = server.getAttribute(objectName, operationName);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Throwable e) {
            return new InvocationResult(e, serverInfo, objectName);
        }
        return new InvocationResult(result, serverInfo, objectName);
    }

    private static class UnregisterPrivilegedExceptionAction
    implements PrivilegedExceptionAction<Void> {
        private MBeanServer mbeanServer;
        private ObjectName objectName;

        private UnregisterPrivilegedExceptionAction() {
        }

        public void init(MBeanServer mbeanServer, ObjectName objectName) {
            this.mbeanServer = mbeanServer;
            this.objectName = objectName;
        }

        @Override
        public Void run() throws InstanceNotFoundException, MBeanRegistrationException {
            this.mbeanServer.unregisterMBean(this.objectName);
            return null;
        }
    }
}

