/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mbean.util;

import ilog.rules.res.mbean.util.IlrMBeanManagerImpl;
import ilog.rules.res.mbean.util.InvocationResult;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.bootstrap.spi.util.ServerConfigUtil;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.proxy.ClientContainer;
import org.jboss.proxy.Interceptor;

class IlrMBeanManagerImpl_jboss5HA
extends IlrMBeanManagerImpl {
    protected static final String JMX_INVOKER = "jmx/invoker/RMIAdaptor";
    protected HAPartition haPartition;
    protected HashMap<String, MBeanServerConnection> connections = new HashMap();

    public IlrMBeanManagerImpl_jboss5HA(Properties props) {
        super(props);
    }

    @Override
    public String getImplementationName() {
        return "JBoss5HA";
    }

    @Override
    public void initMBeanManager() throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
                ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(System.getProperty("jboss.remoting.jmxid"));
                if (!list.isEmpty()) {
                    IlrMBeanManagerImpl_jboss5HA.this.mbeanServer = (MBeanServer)list.iterator().next();
                }
                ObjectName mClusterPartitionName = new ObjectName("jboss:partition=" + IlrMBeanManagerImpl_jboss5HA.getDefaultPartitionName() + ",service=HAPartition");
                IlrMBeanManagerImpl_jboss5HA.this.haPartition = (HAPartition)IlrMBeanManagerImpl_jboss5HA.this.mbeanServer.getAttribute(mClusterPartitionName, "HAPartition");
                return null;
            }
        });
    }

    @Override
    protected List<InvocationResult> invoke(final int type, final String serverInfoQuery, final ObjectName query, final String operationName, final Object[] params, final String[] signature) {
        return AccessController.doPrivileged(new PrivilegedAction<List<InvocationResult>>(){

            @Override
            public List<InvocationResult> run() {
                ClusterNode[] nodes;
                ArrayList<InvocationResult> result = new ArrayList<InvocationResult>();
                HashMap<String, MBeanServerConnection> tmpConnections = new HashMap<String, MBeanServerConnection>();
                for (ClusterNode node : nodes = IlrMBeanManagerImpl_jboss5HA.this.haPartition.getClusterNodes()) {
                    String serverInfo = node.getName();
                    if (serverInfoQuery != null && !serverInfoQuery.equals(serverInfo)) continue;
                    Iterator<ObjectName> itMBean = null;
                    MBeanServerConnection connection = null;
                    boolean isLocal = false;
                    if (!node.getName().equals(IlrMBeanManagerImpl_jboss5HA.this.haPartition.getNodeName())) {
                        String providerURL = IlrMBeanManagerImpl_jboss5HA.this.getProviderUrl(node);
                        connection = IlrMBeanManagerImpl_jboss5HA.this.connections.get(providerURL);
                        if (connection != null) {
                            try {
                                itMBean = connection.queryNames(query, null).iterator();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (connection == null || itMBean == null) {
                            try {
                                connection = IlrMBeanManagerImpl_jboss5HA.this.retreiveMBeanServerConnection(providerURL);
                                itMBean = connection.queryNames(query, null).iterator();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                        }
                        tmpConnections.put(providerURL, connection);
                    } else {
                        isLocal = true;
                        itMBean = IlrMBeanManagerImpl_jboss5HA.this.mbeanServer.queryNames(query, null).iterator();
                    }
                    while (itMBean.hasNext()) {
                        ObjectName objectName = itMBean.next();
                        result.add(IlrMBeanManagerImpl_jboss5HA.this.invokeDispatcher(isLocal ? IlrMBeanManagerImpl_jboss5HA.this.mbeanServer : connection, serverInfo, type, objectName, operationName, params, signature));
                    }
                }
                IlrMBeanManagerImpl_jboss5HA.this.connections = tmpConnections;
                return result;
            }
        });
    }

    protected String getProviderUrl(ClusterNode node) {
        return node.getName();
    }

    protected static String getDefaultPartitionName() {
        return ServerConfigUtil.getDefaultPartitionName();
    }

    protected MBeanServerConnection retreiveMBeanServerConnection(String providerURL) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", providerURL);
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jnp.interfaces");
        MBeanServerConnection result = (MBeanServerConnection)new InitialContext(env).lookup(JMX_INVOKER);
        ClientContainer clientContainer = (ClientContainer)Proxy.getInvocationHandler(result);
        ArrayList interceptors = clientContainer.getInterceptors();
        Interceptor last = (Interceptor)interceptors.get(interceptors.size() - 1);
        if (last.getClass().equals(InvokerInterceptor.class)) {
            interceptors.set(interceptors.size() - 1, new DirectInvokerInterceptor());
        }
        clientContainer.setInterceptors(interceptors);
        return result;
    }

    public static class DirectInvokerInterceptor
    extends InvokerInterceptor {
        public Object invoke(Invocation invocation) throws Exception {
            return this.invokeInvoker(invocation);
        }
    }
}

