/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mbean.util;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import ilog.rules.res.mbean.util.IlrMBeanManagerImpl;
import ilog.rules.res.mbean.util.InvocationResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;

class IlrMBeanManagerImpl_websphere
extends IlrMBeanManagerImpl {
    protected MBeanFactory mbeanFactory = null;
    protected AdminClient adminClient = null;
    protected AdminService adminService = null;
    protected UnregisterPrivilegedExceptionAction unregisterAction = new UnregisterPrivilegedExceptionAction();

    public IlrMBeanManagerImpl_websphere(Properties props) {
        super("type", "WebSphere", props);
    }

    @Override
    public String getImplementationName() {
        return "WebSphere";
    }

    @Override
    public void initMBeanManager() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                IlrMBeanManagerImpl_websphere.this.adminService = AdminServiceFactory.getAdminService();
                IlrMBeanManagerImpl_websphere.this.mbeanFactory = AdminServiceFactory.getMBeanFactory();
                IlrMBeanManagerImpl_websphere.this.mbeanServer = IlrMBeanManagerImpl_websphere.this.mbeanFactory.getMBeanServer();
                return null;
            }
        });
        if (this.adminService == null || this.mbeanFactory == null || this.mbeanServer == null) {
            throw new ConnectorNotAvailableException();
        }
    }

    @Override
    public ObjectName registerMBean(final String type, final Properties properties, final Object object) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectName>(){

                @Override
                public ObjectName run() throws AdminException {
                    return IlrMBeanManagerImpl_websphere.this.mbeanFactory.activateMBean(type, (RuntimeCollaborator)object, IlrMBeanManagerImpl_websphere.this.mbeanFactory.getConfigId(object), type + ".xml", properties);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    public synchronized void unregisterMBean(ObjectName objectName) throws Exception {
        try {
            this.unregisterAction.init(this.mbeanFactory, objectName);
            AccessController.doPrivileged(this.unregisterAction);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    protected List<InvocationResult> invoke(final int type, final String serverInfoQuery, final ObjectName query, final String operationName, final Object[] params, final String[] signature) {
        return AccessController.doPrivileged(new PrivilegedAction<List<InvocationResult>>(){

            @Override
            public List<InvocationResult> run() {
                IlrMBeanManagerImpl_websphere.this.checkAdminClient();
                ArrayList<InvocationResult> result = new ArrayList<InvocationResult>();
                Set objectNames = null;
                if (IlrMBeanManagerImpl_websphere.this.adminClient != null) {
                    try {
                        objectNames = IlrMBeanManagerImpl_websphere.this.adminClient.queryNames(query, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (IlrMBeanManagerImpl_websphere.this.adminService != null) {
                    objectNames = IlrMBeanManagerImpl_websphere.this.adminService.queryNames(query, null);
                }
                if (objectNames != null) {
                    for (Object name : objectNames) {
                        ObjectName objectName = (ObjectName)name;
                        String serverInfo = IlrMBeanManagerImpl_websphere.this.getServerInfo(objectName);
                        if (serverInfoQuery != null && !serverInfoQuery.equals(serverInfo)) continue;
                        result.add(IlrMBeanManagerImpl_websphere.this.invokeDispatcher(IlrMBeanManagerImpl_websphere.this.adminClient, IlrMBeanManagerImpl_websphere.this.adminService, serverInfo, type, objectName, operationName, params, signature));
                    }
                }
                return result;
            }
        });
    }

    protected InvocationResult invokeDispatcher(AdminClient adminClient, AdminService adminService, String serverInfo, int type, ObjectName objectName, String operationName, Object[] params, String[] signature) {
        Object result = null;
        try {
            switch (type) {
                case 1: {
                    if (adminClient != null) {
                        result = adminClient.invoke(objectName, operationName, params, signature);
                        break;
                    }
                    result = adminService.invoke(objectName, operationName, params, signature);
                    break;
                }
                case 2: {
                    if (adminClient != null) {
                        adminClient.setAttribute(objectName, new Attribute(operationName, params[0]));
                        break;
                    }
                    adminService.setAttribute(objectName, new Attribute(operationName, params[0]));
                    break;
                }
                case 3: {
                    if (adminClient != null) {
                        result = adminClient.getAttribute(objectName, operationName);
                        break;
                    }
                    result = adminService.getAttribute(objectName, operationName);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Throwable e) {
            return new InvocationResult(e, serverInfo, objectName);
        }
        return new InvocationResult(result, serverInfo, objectName);
    }

    protected String getServerInfo(ObjectName objectName) {
        StringBuffer buffer = new StringBuffer(ObjectNameHelper.getCellName((ObjectName)objectName));
        buffer.append(" - ");
        buffer.append(ObjectNameHelper.getNodeName((ObjectName)objectName));
        buffer.append(" - ");
        buffer.append(ObjectNameHelper.getProcessName((ObjectName)objectName));
        return buffer.toString();
    }

    protected synchronized void checkAdminClient() {
        if (this.adminService == null) {
            this.adminClient = null;
            return;
        }
        try {
            if (this.adminClient == null || this.adminClient.isAlive() == null) {
                this.adminClient = this.adminService.getDeploymentManagerAdminClient();
            }
        }
        catch (ConnectorNotAvailableException ignore) {
            this.adminClient = null;
            return;
        }
        catch (AdminException ignore) {
            this.adminClient = null;
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.adminClient = null;
            return;
        }
    }

    private static class UnregisterPrivilegedExceptionAction
    implements PrivilegedExceptionAction<Void> {
        private MBeanFactory mbeanFactory;
        private ObjectName objectName;

        private UnregisterPrivilegedExceptionAction() {
        }

        public void init(MBeanFactory mbeanFactory, ObjectName objectName) {
            this.mbeanFactory = mbeanFactory;
            this.objectName = objectName;
        }

        @Override
        public Void run() throws AdminException {
            this.mbeanFactory.deactivateMBean(this.objectName);
            return null;
        }
    }
}

