/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import ilog.rules.res.model.internal.IlrReadOnlyProperties;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import java.util.Date;
import java.util.Map;

public abstract class IlrEntity {
    protected String name;
    protected IlrVersion version;
    protected Date creationDate;
    protected String displayName;
    protected String description;
    protected IlrReadOnlyProperties properties;
    protected boolean _propertiesLoaded = false;

    protected IlrEntity(String name, IlrVersion version, Date creationDate) {
        this.name = name;
        this.version = version;
        this.creationDate = creationDate;
    }

    public String getName() {
        return this.name;
    }

    public IlrVersion getVersion() {
        return this.version;
    }

    public abstract IlrPath getCanonicalPath();

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        if (this.getDAO() != null) {
            try {
                this.getDAO().setDisplayName(this.getCanonicalPath(), displayName);
            }
            catch (IlrDAOException e) {
                throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.SET_DISPLAY_NAME_ERROR, new String[]{String.valueOf(this.getCanonicalPath())}, (Throwable)e);
            }
        }
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (this.getDAO() != null) {
            try {
                this.getDAO().setDescription(this.getCanonicalPath(), description);
            }
            catch (IlrDAOException e) {
                throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.SET_DESCRIPTION_ERROR, new String[]{String.valueOf(this.getCanonicalPath())}, (Throwable)e);
            }
        }
        this.description = description;
    }

    public void setProperty(String key, String value) {
        if (this.getDAO() != null) {
            this.retreiveProperties();
            try {
                this.getDAO().setProperty(this.getCanonicalPath(), key, value);
            }
            catch (IlrDAOException e) {
                throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.PROPERTIES_ERROR, new String[]{String.valueOf(this.getCanonicalPath())}, (Throwable)e);
            }
        }
        if (value != null) {
            this.properties.properties.put(key, value);
        } else {
            this.properties.properties.remove(key);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IlrEntity)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getCanonicalPath().toString();
    }

    protected abstract IlrRepositoryDAO getDAO();

    protected abstract IlrReadOnlyProperties createProperties(Map<String, String> var1);

    protected IlrReadOnlyProperties getProps() {
        if (this.getDAO() != null) {
            this.retreiveProperties();
        }
        return this.properties;
    }

    private void retreiveProperties() throws IlrResourceRuntimeException {
        if (!this._propertiesLoaded) {
            try {
                Map<String, String> props = this.getDAO().getProperties(this.getCanonicalPath());
                this.properties = this.createProperties(props);
                this._propertiesLoaded = true;
            }
            catch (IlrDAOException e) {
                throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.PROPERTIES_ERROR, new String[]{String.valueOf(this.getCanonicalPath())}, (Throwable)e);
            }
        }
    }
}

