/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrRuleAppProperties;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrEntity;
import ilog.rules.res.model.internal.IlrEntityContainer;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import ilog.rules.res.model.internal.IlrMutableRepositoryImpl;
import ilog.rules.res.model.internal.IlrMutableRulesetArchiveInformationImpl;
import ilog.rules.res.model.internal.IlrReadOnlyProperties;
import ilog.rules.res.model.internal.IlrRuleAppPropertiesImpl;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class IlrMutableRuleAppInformationImpl
extends IlrEntity
implements IlrMutableRuleAppInformation {
    public static final Comparator<IlrMutableRuleAppInformation> CASE_INSENSITIVE_ORDER = new IlrMutableRuleAppInformationComparator();
    protected IlrMutableRepositoryImpl repository;
    protected IlrEntityContainer<IlrMutableRulesetArchiveInformation> rulesetsContainer = new IlrEntityContainer();

    protected IlrMutableRuleAppInformationImpl(String name, IlrVersion version, Date creationDate) {
        super(name, version, creationDate);
        this.properties = new IlrRuleAppPropertiesImpl();
    }

    @Override
    public IlrMutableRepository getRepository() {
        return this.repository;
    }

    @Override
    public IlrPath getCanonicalPath() {
        return new IlrPath(this.name, this.version);
    }

    @Override
    public IlrRuleAppProperties getProperties() {
        return (IlrRuleAppProperties)((Object)this.getProps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getXOM() {
        String xomPath = (String)this.getProperties().get("xom.path");
        if (xomPath == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(xomPath);
            IlrFileUtil.copy((InputStream)fis, baos);
        }
        catch (IOException e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }

    public void setName(String name) {
        if (this.repository != null) {
            throw new IllegalStateException();
        }
        if (name == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULEAPP_NAME_NULL_ERROR);
        }
        this.name = name;
    }

    public void setVersion(IlrVersion version) {
        if (this.repository != null) {
            throw new IllegalStateException();
        }
        if (version == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.VERSION_NULL_ERROR);
        }
        this.version = version;
    }

    public int getNbRulesets() {
        return this.rulesetsContainer.getNbEntities();
    }

    @Override
    public Set<IlrMutableRulesetArchiveInformation> getRulesets() {
        return Collections.unmodifiableSet(this.rulesetsContainer.getEntities());
    }

    @Override
    public Set<IlrMutableRulesetArchiveInformation> getRulesets(String rulesetName) {
        return Collections.unmodifiableSet(this.rulesetsContainer.getEntities(rulesetName));
    }

    @Override
    public IlrMutableRulesetArchiveInformation getRuleset(String rulesetName, IlrVersion rulesetVersion) {
        return this.rulesetsContainer.getEntity(rulesetName, rulesetVersion);
    }

    @Override
    public IlrMutableRulesetArchiveInformation getGreatestRuleset(String rulesetName) {
        return this.rulesetsContainer.getGreatestEntity(rulesetName);
    }

    @Override
    public IlrMutableRulesetArchiveInformation addRuleset(IlrMutableRulesetArchiveInformation ruleset) throws IlrAlreadyExistException {
        if (ruleset == null) {
            return null;
        }
        if (ruleset.getRuleApp() == this || this.rulesetsContainer.containsEntity(ruleset.getName(), ruleset.getVersion())) {
            throw new IlrAlreadyExistException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULESET_ALREADY_EXIST, new String[]{new IlrPath(this.name, this.version, ruleset.getName(), ruleset.getVersion()).toString()});
        }
        ((IlrMutableRulesetArchiveInformationImpl)ruleset).setRuleApp(this);
        this.rulesetsContainer.addEntity(ruleset.getName(), ruleset.getVersion(), ruleset);
        return ruleset;
    }

    @Override
    public boolean removeRuleset(IlrMutableRulesetArchiveInformation ruleset) {
        if (ruleset == null || ruleset.getRuleApp() != this) {
            return false;
        }
        IlrMutableRulesetArchiveInformationImpl rs = (IlrMutableRulesetArchiveInformationImpl)this.rulesetsContainer.getEntity(ruleset.getName(), ruleset.getVersion());
        if (rs == null || rs != ruleset) {
            return false;
        }
        rs.setRuleApp(null);
        this.rulesetsContainer.removeEntity(rs.getName(), rs.getVersion());
        return true;
    }

    @Override
    protected IlrRepositoryDAO getDAO() {
        return this.repository == null ? null : this.repository.getDAO();
    }

    @Override
    protected IlrReadOnlyProperties createProperties(Map<String, String> props) {
        return new IlrRuleAppPropertiesImpl(props);
    }

    protected void updateFields(IlrMutableRuleAppInformationImpl ruleApp, boolean propertiesLoaded) {
        this.displayName = ruleApp.getDisplayName();
        this.description = ruleApp.getDescription();
        this.creationDate = ruleApp.getCreationDate();
        this._propertiesLoaded = propertiesLoaded;
        if (propertiesLoaded) {
            this.properties = ruleApp.properties;
        }
    }

    protected void setRepository(IlrMutableRepositoryImpl newRepository) {
        if (this.getRepository() != null && newRepository != null || this.getRepository() == null && newRepository == null) {
            throw new IllegalStateException();
        }
        if (newRepository != null) {
            IlrRepositoryDAO repositoryDAO = newRepository.getDAO();
            if (repositoryDAO != null) {
                try {
                    repositoryDAO.addRuleApp(this);
                }
                catch (IlrDAOException e) {
                    throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ADD_RULEAPP_ERROR, new String[]{String.valueOf(this.getCanonicalPath())}, (Throwable)e);
                }
            }
        } else {
            IlrRepositoryDAO repositoryDAO = this.getDAO();
            if (repositoryDAO != null) {
                try {
                    repositoryDAO.removeRuleApp(this.getCanonicalPath());
                }
                catch (IlrDAOException e) {
                    throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.REMOVE_RULEAPP_ERROR, new String[]{String.valueOf(this.getCanonicalPath())}, (Throwable)e);
                }
            }
        }
        this.linked(newRepository, true);
    }

    protected void linked(IlrMutableRepositoryImpl newRepository, boolean propertiesLoaded) {
        this.repository = newRepository;
        this._propertiesLoaded = propertiesLoaded;
        for (IlrMutableRulesetArchiveInformation ruleset : this.getRulesets()) {
            ((IlrMutableRulesetArchiveInformationImpl)ruleset).linked(this, propertiesLoaded);
        }
    }

    static class IlrMutableRuleAppInformationComparator
    implements Comparator<IlrMutableRuleAppInformation>,
    Serializable {
        private static final long serialVersionUID = 1L;

        IlrMutableRuleAppInformationComparator() {
        }

        @Override
        public int compare(IlrMutableRuleAppInformation o1, IlrMutableRuleAppInformation o2) {
            int nameComparison = o1.getName().compareToIgnoreCase(o2.getName());
            if (nameComparison == 0) {
                return o1.getVersion().compareTo(o2.getVersion());
            }
            return nameComparison;
        }
    }
}

