/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrEntity;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import ilog.rules.res.model.internal.IlrMutableRepositoryImpl;
import ilog.rules.res.model.internal.IlrMutableRuleAppInformationImpl;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import ilog.rules.res.model.internal.IlrReadOnlyProperties;
import ilog.rules.res.model.internal.IlrRulesetArchivePropertiesImpl;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;

public class IlrMutableRulesetArchiveInformationImpl
extends IlrEntity
implements IlrMutableRulesetArchiveInformation {
    public static final Comparator<IlrMutableRulesetArchiveInformation> CASE_INSENSITIVE_ORDER = new IlrMutableRulesetArchiveInformationComparator();
    protected IlrMutableRuleAppInformationImpl ruleApp;
    protected IlrRESRulesetArchive resRulesetArchive;

    public IlrMutableRulesetArchiveInformationImpl(String name, IlrVersion version, Date creationDate) {
        super(name, version, creationDate);
        this.properties = new IlrRulesetArchivePropertiesImpl();
    }

    @Override
    public IlrMutableRepository getRepository() {
        return this.ruleApp != null ? this.ruleApp.getRepository() : null;
    }

    @Override
    public IlrMutableRuleAppInformation getRuleApp() {
        return this.ruleApp;
    }

    @Override
    public IlrPath getCanonicalPath() {
        if (this.ruleApp == null) {
            return null;
        }
        return new IlrPath(this.ruleApp.getName(), this.ruleApp.getVersion(), this.name, this.version);
    }

    public void setName(String name) {
        if (this.ruleApp != null) {
            throw new IllegalStateException();
        }
        if (name == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULESET_NAME_NULL_ERROR);
        }
        this.name = name;
    }

    public void setVersion(IlrVersion version) {
        if (this.ruleApp != null) {
            throw new IllegalStateException();
        }
        if (version == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.VERSION_NULL_ERROR);
        }
        this.version = version;
    }

    @Override
    public IlrRulesetArchiveProperties getProperties() {
        return (IlrRulesetArchiveProperties)((Object)this.getProps());
    }

    @Override
    public IlrRESRulesetArchive getRESRulesetArchive() {
        if (this.getDAO() != null) {
            try {
                return this.getDAO().getRESRulesetArchive(this.getCanonicalPath());
            }
            catch (IlrDAOException e) {
                throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULESET_ARCHIVE_ERROR, new String[]{this.toString()}, (Throwable)e);
            }
        }
        return this.resRulesetArchive;
    }

    @Override
    @Deprecated
    public IlrRulesetArchive getRulesetArchive() {
        IlrCRERulesetArchive archive = (IlrCRERulesetArchive)this.getRESRulesetArchive();
        if (archive == null) {
            return null;
        }
        return archive.getRulesetArchive();
    }

    @Override
    @Deprecated
    public void setRulesetArchive(IlrRulesetArchive rulesetArchive) {
        try {
            InputStream stream = IlrRESArchiveUtil.getRulesetArchiveAsStream(rulesetArchive);
            this.setRESRulesetArchive(IlrEngineType.CRE, stream, false);
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULESET_ARCHIVE_ERROR, new String[]{this.toString()}, (Throwable)e);
        }
    }

    @Override
    public void setRCERulesetArchive(InputStream content) {
        this.setRESRulesetArchive(IlrEngineType.CRE, content);
    }

    @Override
    public void setRESRulesetArchive(IlrEngineType engineType, InputStream content) {
        this.setRESRulesetArchive(engineType, content, true);
    }

    protected void setRESRulesetArchive(IlrEngineType engineType, InputStream content, boolean setEngineTypeProperty) {
        if (engineType == null) {
            throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.UNKNOWN_RULESET_TYPE_ERROR, null);
        }
        if (setEngineTypeProperty) {
            this.setProperty("ruleset.engine", engineType.toString());
        }
        if (this.getDAO() != null) {
            try {
                this.getDAO().setRESRulesetArchive(this.getCanonicalPath(), engineType, content);
            }
            catch (IlrDAOException e) {
                throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULESET_ARCHIVE_ERROR, new String[]{this.toString()}, (Throwable)e);
            }
        }
        try {
            this.resRulesetArchive = IlrRESArchiveUtil.getRESRulesetArchive(engineType, content);
        }
        catch (IOException e) {
            throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULESET_ARCHIVE_ERROR, new String[]{this.toString()}, (Throwable)e);
        }
    }

    @Override
    protected IlrRepositoryDAO getDAO() {
        return this.ruleApp == null ? null : this.ruleApp.getDAO();
    }

    @Override
    protected IlrReadOnlyProperties createProperties(Map<String, String> props) {
        return new IlrRulesetArchivePropertiesImpl(props);
    }

    protected void updateFields(IlrMutableRulesetArchiveInformationImpl ruleset) {
        this.displayName = ruleset.getDisplayName();
        this.description = ruleset.getDescription();
        this.creationDate = ruleset.getCreationDate();
        this._propertiesLoaded = false;
    }

    protected void setRuleApp(IlrMutableRuleAppInformationImpl newRuleApp) throws IllegalStateException, IlrResourceRuntimeException {
        if (this.ruleApp != null && newRuleApp != null || this.ruleApp == null && newRuleApp == null) {
            throw new IllegalStateException();
        }
        if (newRuleApp != null) {
            IlrRepositoryDAO repositoryDAO = newRuleApp.getDAO();
            if (repositoryDAO != null) {
                IlrPath rulesetPath = new IlrPath(newRuleApp.getName(), newRuleApp.getVersion(), this.getName(), this.getVersion());
                try {
                    repositoryDAO.addRuleset(rulesetPath, this);
                }
                catch (IlrDAOException e) {
                    throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ADD_RULESET_ERROR, new String[]{rulesetPath.toString()}, (Throwable)e);
                }
            }
        } else {
            IlrRepositoryDAO repositoryDAO = this.getDAO();
            if (repositoryDAO != null) {
                try {
                    repositoryDAO.removeRuleset(this.getCanonicalPath());
                }
                catch (IlrDAOException e) {
                    throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.REMOVE_RULESET_ERROR, new String[]{this.toString()}, (Throwable)e);
                }
            }
        }
        this.linked(newRuleApp, true);
    }

    protected void linked(IlrMutableRuleAppInformationImpl newRuleApp, boolean propertiesLoaded) {
        IlrMutableRepositoryImpl newRepository = null;
        if (newRuleApp != null) {
            newRepository = (IlrMutableRepositoryImpl)newRuleApp.getRepository();
        }
        if (this.ruleApp != newRuleApp) {
            this.ruleApp = newRuleApp;
        }
        if (newRepository != null && newRepository.getDAO() != null) {
            this.resRulesetArchive = null;
        }
        this._propertiesLoaded = propertiesLoaded;
    }

    @Override
    public String toString() {
        if (this.ruleApp != null) {
            return super.toString();
        }
        return new IlrPath("-", this.name, this.version).toString();
    }

    static class IlrMutableRulesetArchiveInformationComparator
    implements Comparator<IlrMutableRulesetArchiveInformation>,
    Serializable {
        private static final long serialVersionUID = 1L;

        IlrMutableRulesetArchiveInformationComparator() {
        }

        @Override
        public int compare(IlrMutableRulesetArchiveInformation o1, IlrMutableRulesetArchiveInformation o2) {
            int nameComparison = o1.getName().compareToIgnoreCase(o2.getName());
            if (nameComparison == 0) {
                return o1.getVersion().compareTo(o2.getVersion());
            }
            return nameComparison;
        }
    }
}

