/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.archive.IlrJarArchiveLoader;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.archive.IlrRulesetArchiveLoader;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrDERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrRulesetParameter;
import ilog.rules.res.model.internal.IlrBaseRESRulesetArchive;
import ilog.rules.res.model.internal.IlrCRERulesetArchiveImpl;
import ilog.rules.res.model.internal.IlrDERulesetArchiveImpl;
import ilog.rules.res.model.internal.IlrRulesetParameterImpl;
import ilog.rules.res.model.internal.IlrXMLSignatureParser;
import ilog.rules.res.util.io.IlrFileUtil;
import ilog.rules.util.engine.IlrXmlSignatureParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IlrRESArchiveUtil {
    public static boolean isEmpty(IlrRESRulesetArchive resArchive) {
        if (resArchive == null) {
            return true;
        }
        if (resArchive instanceof IlrCRERulesetArchive) {
            IlrRulesetArchive rulesetArchive = ((IlrCRERulesetArchive)resArchive).getRulesetArchive();
            if (rulesetArchive == null) {
                return true;
            }
            return rulesetArchive.getElements().isEmpty();
        }
        if (resArchive instanceof IlrDERulesetArchiveImpl) {
            byte[] content = ((IlrDERulesetArchiveImpl)resArchive).data;
            if (content == null) {
                return true;
            }
            return content.length == 0;
        }
        return false;
    }

    public static byte[] streamToBytes(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IlrFileUtil.copy(stream, baos);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IlrRulesetArchive getRulesetArchive(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        if (stream instanceof IlrRulesetArchiveStream) {
            return ((IlrRulesetArchiveStream)stream).internalRulesetArchive;
        }
        IlrRulesetArchive rulesetArchive = null;
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(stream);
            rulesetArchive = IlrRulesetArchive.extractArchive((IlrRulesetArchiveLoader)new IlrJarArchiveLoader(jis));
        }
        finally {
            try {
                if (jis != null) {
                    jis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return rulesetArchive;
    }

    public static IlrRESRulesetArchive getRESRulesetArchive(IlrEngineType engineType, InputStream content) throws IOException {
        if (content == null) {
            return null;
        }
        IlrBaseRESRulesetArchive resRulesetArchive = null;
        if (engineType == IlrEngineType.CRE) {
            resRulesetArchive = new IlrCRERulesetArchiveImpl(IlrRESArchiveUtil.getRulesetArchive(content));
        } else if (engineType == IlrEngineType.DE) {
            byte[] data = StreamUtil.toByteArray(content);
            resRulesetArchive = new IlrDERulesetArchiveImpl(data);
        }
        return resRulesetArchive;
    }

    public static byte[] getRulesetArchiveAsBytes(IlrRulesetArchive rulesetArchive) throws IOException {
        if (rulesetArchive == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jarOutputStream = new JarOutputStream(baos);
        jarOutputStream.setLevel(9);
        rulesetArchive.write(jarOutputStream);
        jarOutputStream.close();
        baos.close();
        return baos.toByteArray();
    }

    public static byte[] getRESRulesetArchiveAsBytes(IlrRESRulesetArchive rulesetArchive) throws IOException {
        if (rulesetArchive == null) {
            return null;
        }
        if (rulesetArchive instanceof IlrCRERulesetArchive) {
            return IlrRESArchiveUtil.getRulesetArchiveAsBytes(((IlrCRERulesetArchive)rulesetArchive).getRulesetArchive());
        }
        if (rulesetArchive instanceof IlrDERulesetArchiveImpl) {
            return ((IlrDERulesetArchiveImpl)rulesetArchive).data;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = ((IlrDERulesetArchive)rulesetArchive).getContentStream();
        IlrFileUtil.copy(is, baos);
        baos.close();
        return baos.toByteArray();
    }

    public static InputStream getRulesetArchiveAsStream(IlrRulesetArchive rulesetArchive) throws IOException {
        if (rulesetArchive == null) {
            return null;
        }
        return new IlrRulesetArchiveStream(rulesetArchive);
    }

    public Collection<IlrRulesetParameter> extractRulesetParametersFromRulesetArchiveXmlSignature(InputStream xmlSignatureStream, byte direction) {
        ArrayList<IlrRulesetParameter> params = new ArrayList<IlrRulesetParameter>();
        IlrXMLSignatureParser parser = new IlrXMLSignatureParser();
        try {
            IlrXmlSignatureParser.Parameter[] paramsValue;
            InputSource input = new InputSource(xmlSignatureStream);
            for (IlrXmlSignatureParser.Parameter element : paramsValue = parser.parseSignature(input)) {
                byte pdirection = element.direction.equals("in") ? (byte)1 : (element.direction.equals("out") ? (byte)2 : 4);
                if ((direction & pdirection) <= 0) continue;
                byte kind = element.kind.equals("xml") ? (byte)1 : 0;
                IlrRulesetParameterImpl param = new IlrRulesetParameterImpl(element.name, element.xomType, element.xmlType, kind, pdirection);
                params.add(param);
            }
        }
        catch (IOException e) {
            throw new IlrResourceRuntimeException(e);
        }
        catch (SAXException e) {
            throw new IlrResourceRuntimeException(e);
        }
        catch (IlrXMLSignatureParser.InvalidXMLDocument e) {
            throw new IlrResourceRuntimeException(e);
        }
        return params;
    }

    public static class IlrRulesetArchiveStream
    extends InputStream {
        private InputStream internalInputStream;
        private final IlrRulesetArchive internalRulesetArchive;

        public IlrRulesetArchiveStream(IlrRulesetArchive rulesetArchive) {
            this.internalRulesetArchive = rulesetArchive;
        }

        private void lazyInstantiation() throws IOException {
            if (this.internalInputStream == null) {
                this.internalInputStream = StreamUtil.toStream(IlrRESArchiveUtil.getRulesetArchiveAsBytes(this.internalRulesetArchive));
            }
        }

        @Override
        public int read() throws IOException {
            this.lazyInstantiation();
            return this.internalInputStream.read();
        }
    }
}

