/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrRepository;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrRuleAppInformation;
import ilog.rules.res.model.IlrVersion;
import java.util.Set;

public class IlrRepositoryImpl
implements IlrRepository {
    private final IlrRepositoryFactory factory;
    private final IlrMutableRepository repository;

    public IlrRepositoryImpl(IlrRepositoryFactory factory, IlrMutableRepository repository) {
        this.factory = factory;
        this.repository = repository;
    }

    @Override
    public Set<IlrRuleAppInformation> getRuleApps() {
        return this.factory.unmodifiableRuleApps(this.repository.getRuleApps());
    }

    @Override
    public Set<IlrRuleAppInformation> getRuleApps(String ruleAppName) {
        return this.factory.unmodifiableRuleApps(this.repository.getRuleApps(ruleAppName));
    }

    @Override
    public IlrRuleAppInformation getRuleApp(String ruleAppName, IlrVersion ruleAppVersion) {
        return this.factory.unmodifiableRuleApp((IlrMutableRuleAppInformation)this.repository.getRuleApp(ruleAppName, ruleAppVersion));
    }

    @Override
    public IlrRuleAppInformation getGreatestRuleApp(String ruleAppName) {
        return this.factory.unmodifiableRuleApp((IlrMutableRuleAppInformation)this.repository.getGreatestRuleApp(ruleAppName));
    }
}

