/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.model.internal.IlrReadOnlyProperties;
import ilog.rules.res.util.IlrListParser;
import ilog.rules.util.engine.IlrPropertyNames;
import ilog.rules.util.engine.IlrRulesetOptimConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class IlrRulesetArchivePropertiesImpl
extends IlrReadOnlyProperties
implements IlrRulesetArchiveProperties {
    private static final long serialVersionUID = 1L;
    public static final String[] ALL_PUBLIC_CRE_KEYS;
    public static final String[] ALL_PUBLIC_DE_KEYS;

    public IlrRulesetArchivePropertiesImpl() {
        this(new HashMap<String, String>());
    }

    public IlrRulesetArchivePropertiesImpl(Map<String, String> properties) {
        super(properties);
        HashMap<String, String> defaults = new HashMap<String, String>(11);
        defaults.put("ruleset.debug.enabled", "false");
        defaults.put("ruleset.shareable", "true");
        defaults.put("ruleset.trace.enabled", "false");
        defaults.put("ruleset.sequential.trace.enabled", "false");
        defaults.put("ruleset.sequential.trace.tasks", "");
        defaults.put("ruleset.status", "enabled");
        defaults.put("ruleset.xmlDocumentDriverPool.reserveTimeout", "30000");
        defaults.put("ruleset.xmlDocumentDriverPool.maxSize", "1");
        defaults.put("ruleset.optimization.enabled", "false");
        defaults.put("ruleset.bom.enabled", "true");
        defaults.put("ruleset.maxIdleTime", Long.toString(-1L));
        defaults.put("ruleset.engine", DEFAULT_VALUE_ENGINE_TYPE);
        this.setDefaultProperties(defaults);
    }

    @Override
    public int getXMLDocumentDriverPoolMaxSize() {
        String result = this.get("ruleset.xmlDocumentDriverPool.maxSize");
        return Integer.valueOf(result);
    }

    @Override
    public IlrEngineType getEngineType() {
        return IlrEngineType.toEngineType(this.get("ruleset.engine"));
    }

    public static IlrEngineType getEngineType(String stype) {
        return IlrEngineType.toEngineType(stype);
    }

    @Override
    public long getXMLDocumentDriverPoolReserveTimeout() {
        String result = this.get("ruleset.xmlDocumentDriverPool.reserveTimeout");
        return Long.valueOf(result);
    }

    @Override
    public boolean isOptimizationEnabled() {
        String result = this.get("ruleset.optimization.enabled");
        return Boolean.valueOf(result);
    }

    @Override
    public boolean isDebugEnabled() {
        String result = this.get("ruleset.debug.enabled");
        return Boolean.valueOf(result);
    }

    @Override
    public boolean isShareable() {
        String result = this.get("ruleset.shareable");
        return Boolean.valueOf(result);
    }

    @Override
    public String getStatus() {
        return this.get("ruleset.status");
    }

    @Override
    public boolean isTraceEnabled() {
        String result = this.get("ruleset.trace.enabled");
        return Boolean.valueOf(result);
    }

    @Override
    public boolean isBOMSupportEnabled() {
        String result = this.get("ruleset.bom.enabled");
        return Boolean.valueOf(result);
    }

    @Override
    public boolean isSequentialTraceEnabled() {
        String result = this.get("ruleset.sequential.trace.enabled");
        return Boolean.valueOf(result);
    }

    @Override
    public String[] getSequentialTracedTasks() {
        String propertyValue = this.get("ruleset.sequential.trace.tasks");
        return new IlrListParser().parse(propertyValue);
    }

    @Override
    public long getMaxIdleTime() {
        String result = this.get("ruleset.maxIdleTime");
        if (result == null) {
            return -1L;
        }
        return Long.valueOf(result);
    }

    @Override
    public boolean isMonitoringEnabled() {
        String result = this.get("monitoring.enabled");
        return Boolean.valueOf(result);
    }

    @Override
    public String[] getManagedXOMURIs() {
        String propertyValue = this.get("ruleset.managedxom.uris");
        if (propertyValue == null || propertyValue.trim().equals("")) {
            return null;
        }
        String[] strings = propertyValue.split("\\p{Blank}*,\\p{Blank}*");
        return strings;
    }

    @Override
    public String getDataConnectorClass() {
        return this.get("dataconnector.factory.class");
    }

    static {
        String[] resKeys = IlrRulesetArchiveProperties.KEYS;
        String[] engineKeys = IlrPropertyNames.AllNames;
        String[] optimKeys = IlrRulesetOptimConfig.getAttributeNames();
        String[] globalKeys = new String[resKeys.length + engineKeys.length + optimKeys.length];
        System.arraycopy(resKeys, 0, globalKeys, 0, resKeys.length);
        System.arraycopy(engineKeys, 0, globalKeys, resKeys.length, engineKeys.length);
        System.arraycopy(optimKeys, 0, globalKeys, resKeys.length + engineKeys.length, optimKeys.length);
        ALL_PUBLIC_CRE_KEYS = globalKeys;
        ArrayList<String> deKeys = new ArrayList<String>();
        for (String k : IlrRulesetArchiveProperties.KEYS) {
            deKeys.add(k);
        }
        deKeys.remove("ruleset.trace.enabled");
        deKeys.remove("ruleset.shareable");
        deKeys.remove("ruleset.sequential.trace.enabled");
        deKeys.remove("ruleset.sequential.trace.tasks");
        deKeys.remove("ruleset.optimization.enabled");
        deKeys.remove("ruleset.bom.enabled");
        deKeys.remove("monitoring.inout.filters");
        ALL_PUBLIC_DE_KEYS = deKeys.toArray(new String[0]);
    }
}

