/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.util.engine.IlrXmlRulesetArchiveTag;
import ilog.rules.util.engine.IlrXmlSignatureParser;
import ilog.rules.util.engine.IlrXmlSignatureTag;
import ilog.rules.util.prefs.IlrMessages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IlrXMLSignatureParser
implements IlrXmlSignatureTag,
IlrXmlRulesetArchiveTag {
    public static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected static Stack<DocumentBuilder> documentBuilderPool;

    protected static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        try {
            return documentBuilderPool.pop();
        }
        catch (EmptyStackException e) {
            return factory.newDocumentBuilder();
        }
    }

    public static void releaseDocumentBuilder(DocumentBuilder docBuilder) {
        documentBuilderPool.add(docBuilder);
    }

    private Document createDocument(InputSource xmlArchive) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = IlrXMLSignatureParser.getDocumentBuilder();
        Document result = docBuilder.parse(xmlArchive);
        IlrXMLSignatureParser.releaseDocumentBuilder(docBuilder);
        return result;
    }

    private Node getElement(Node parentNode, String ns, String tag) throws InvalidXMLDocument {
        NodeList nl = parentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getNamespaceURI().equals(ns) || !n.getLocalName().equals(tag)) continue;
            return n;
        }
        String msg = IlrMessages.format("messages.RulesetSignature.7", ns + ':' + tag);
        throw new InvalidXMLDocument(msg);
    }

    private String getElementValue(Node parentNode, String ns, String tag) throws InvalidXMLDocument {
        Node n = this.getElement(parentNode, ns, tag);
        Node childValue = n.getFirstChild();
        return childValue == null ? null : childValue.getNodeValue();
    }

    private String getAttributeValue(Node element, String ns, String name) {
        NamedNodeMap attrsNode = element.getAttributes();
        Node n = attrsNode.getNamedItem(name);
        return n == null ? null : n.getNodeValue();
    }

    private NodeList getParameterNodesInArchive(Document doc) throws InvalidXMLDocument {
        Element root = doc.getDocumentElement();
        return root.getChildNodes();
    }

    public IlrXmlSignatureParser.Parameter[] parseSignature(InputSource xmlArchive) throws SAXException, IOException, InvalidXMLDocument {
        try {
            Document doc = this.createDocument(xmlArchive);
            NodeList paramNodes = this.getParameterNodesInArchive(doc);
            ArrayList<IlrXmlSignatureParser.Parameter> parameters = new ArrayList<IlrXmlSignatureParser.Parameter>();
            for (int i = 0; i < paramNodes.getLength(); ++i) {
                Node paramNode = paramNodes.item(i);
                if (paramNode.getNodeType() != 1 || !paramNode.getLocalName().equals("parameter")) continue;
                IlrXmlSignatureParser.Parameter p = new IlrXmlSignatureParser.Parameter();
                parameters.add(p);
                p.name = this.getElementValue(paramNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "name");
                p.direction = this.getElementValue(paramNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "direction");
                Node typeNode = this.getElement(paramNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "type");
                p.bomType = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "bom-type");
                p.xomType = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "xom-type");
                p.kind = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "kind");
                p.xmlElement = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "xml-element");
                p.xmlType = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "xml-type");
            }
            IlrXmlSignatureParser.Parameter[] paramArray = new IlrXmlSignatureParser.Parameter[parameters.size()];
            parameters.toArray(paramArray);
            return paramArray;
        }
        catch (ParserConfigurationException e) {
            String msg = IlrMessages.format("messages.RulesetSignature.8", "");
            throw new InvalidXMLDocument(msg);
        }
    }

    static {
        factory.setNamespaceAware(true);
        documentBuilderPool = new Stack();
    }

    public final class InvalidXMLDocument
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidXMLDocument(String str) {
            super(str);
        }
    }
}

