/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.trace;

import ilog.rules.res.model.trace.IlrDWTraceFilter;
import ilog.rules.res.session.impl.IlrTraceFilterBase;
import java.util.Map;

public class IlrDWTraceFilterImpl
extends IlrTraceFilterBase
implements IlrDWTraceFilter {
    private static final long serialVersionUID = 1L;
    protected static final int M_INFO_USER_DATA = 32768;
    protected static final int M_INFO_INPUT_PARAMETERS = 65536;
    protected static final int M_INFO_OUTPUT_PARAMETERS = 131072;
    protected static final int M_INFO_RULESET_PROPERTIES = 262144;
    protected static final int M_INFO_EXECUTION_OUTPUT = 524288;
    protected static final int M_INFO_EXECUTION_TRACE_TREE = 0x100000;
    protected static final int M_INFO_TOTAL_TASKS = 0x200000;
    protected static final int M_INFO_TOTAL_RULES = 0x400000;
    protected static final int M_ALL = 0x6FFFFF;
    static final String t = Boolean.TRUE.toString();

    public IlrDWTraceFilterImpl() {
        this.setInfoAllFilters(Boolean.TRUE);
    }

    public IlrDWTraceFilterImpl(boolean enabled) {
        if (enabled) {
            this.setInfoAllFilters(Boolean.TRUE);
        }
    }

    @Override
    public final void setInfoAllFilters(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x6FFFFF) : (this.filters &= 0xFF900000);
    }

    @Override
    public final void setInfoUserData(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x8000) : (this.filters &= 0xFFFF7FFF);
    }

    @Override
    public final void setInfoInputParameters(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x10000) : (this.filters &= 0xFFFEFFFF);
    }

    @Override
    public final void setInfoOutputParameters(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x20000) : (this.filters &= 0xFFFDFFFF);
    }

    @Override
    public final void setInfoRulesetProperties(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x40000) : (this.filters &= 0xFFFBFFFF);
    }

    @Override
    public final void setInfoExecutionOutput(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x80000) : (this.filters &= 0xFFF7FFFF);
    }

    @Override
    public final boolean isInfoInputParameters() {
        return (this.filters & 0x10000) > 0;
    }

    @Override
    public final boolean isInfoOutputParameters() {
        return (this.filters & 0x20000) > 0;
    }

    @Override
    public final boolean isInfoRulesetProperties() {
        return (this.filters & 0x40000) > 0;
    }

    @Override
    public final boolean isInfoExecutionOutput() {
        return (this.filters & 0x80000) > 0;
    }

    @Override
    public final boolean isInfoUserData() {
        return (this.filters & 0x8000) > 0;
    }

    @Override
    public boolean isInfoExecutionTrace() {
        return (this.filters & 0x100000) > 0;
    }

    @Override
    public final void setInfoTotalTasks(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x200000) : (this.filters &= 0xFFDFFFFF);
    }

    @Override
    public final void setInfoTotalRules(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x400000) : (this.filters &= 0xFFBFFFFF);
    }

    @Override
    public final boolean isInfoTotalTasks() {
        return (this.filters & 0x200000) > 0;
    }

    @Override
    public final boolean isInfoTotalRules() {
        return (this.filters & 0x400000) > 0;
    }

    @Override
    public final Map<String, String> toMap() {
        Map<String, String> result = super.toMap();
        if (this.isInfoUserData()) {
            result.put("INFO_USER_DATA", t);
        }
        if (this.isInfoInputParameters()) {
            result.put("INFO_INPUT_PARAMETERS", t);
        }
        if (this.isInfoOutputParameters()) {
            result.put("INFO_OUTPUT_PARAMETERS", t);
        }
        if (this.isInfoRulesetProperties()) {
            result.put("INFO_RULESET_PROPERTIES", t);
        }
        if (this.isInfoExecutionOutput()) {
            result.put("INFO_EXECUTION_OUTPUT", t);
        }
        if (this.isInfoExecutionTrace()) {
            result.put("INFO_EXECUTION_TRACE_TREE", t);
        }
        if (this.isInfoTotalTasks()) {
            result.put("INFO_TOTAL_TASKS", t);
        }
        if (this.isInfoTotalRules()) {
            result.put("INFO_TOTAL_RULES", t);
        }
        return result;
    }

    @Override
    protected final int to_mask(String name) {
        if (name.equals("INFO_USER_DATA")) {
            return 32768;
        }
        if (name.equals("INFO_INPUT_PARAMETERS")) {
            return 65536;
        }
        if (name.equals("INFO_OUTPUT_PARAMETERS")) {
            return 131072;
        }
        if (name.equals("INFO_RULESET_PROPERTIES")) {
            return 262144;
        }
        if (name.equals("INFO_EXECUTION_OUTPUT")) {
            return 524288;
        }
        if (name.equals("INFO_EXECUTION_TRACE_TREE")) {
            return 0x100000;
        }
        if (name.equals("INFO_TOTAL_TASKS")) {
            return 0x200000;
        }
        if (name.equals("INFO_TOTAL_RULES")) {
            return 0x400000;
        }
        return super.to_mask(name);
    }
}

