/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IlrErrorHandlerImpl
implements ErrorHandler {
    private ErrorHandler delegationHandle = null;
    private final List<SAXParseException> warnings = new ArrayList<SAXParseException>();
    private final List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private final List<SAXParseException> fatalErrors = new ArrayList<SAXParseException>();
    private SAXParseException firstErrorException = null;

    public IlrErrorHandlerImpl() {
        this(null);
    }

    public IlrErrorHandlerImpl(ErrorHandler delegationHandle) {
        this.delegationHandle = delegationHandle;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasFatalErrors() {
        return this.fatalErrors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public SAXParseException getFirstErrorException() {
        return this.firstErrorException;
    }

    public List<SAXParseException> getWarnings() {
        return this.warnings;
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public List<SAXParseException> getFatalErrors() {
        return this.fatalErrors;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.errors.add(exception);
        if (this.firstErrorException == null) {
            this.firstErrorException = exception;
        }
        if (this.delegationHandle != null) {
            this.delegationHandle.error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.fatalErrors.add(exception);
        if (this.firstErrorException == null) {
            this.firstErrorException = exception;
        }
        if (this.delegationHandle != null) {
            this.delegationHandle.fatalError(exception);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.warnings.add(exception);
        if (this.delegationHandle != null) {
            this.delegationHandle.warning(exception);
        }
    }
}

