/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mprofiler;

import ilog.rules.res.mprofiler.ClassInfo;
import ilog.rules.res.mprofiler.IlrClassInfo;
import ilog.rules.res.mprofiler.IlrFieldInfo;
import ilog.rules.res.mprofiler.IlrInfoBase;
import ilog.rules.res.mprofiler.IlrObjectInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class IlrObjectInfoBase
extends IlrInfoBase
implements IlrObjectInfo {
    protected long tsize = -1L;

    public static final String toHumanReadableClassName(String className) {
        if (className == null || className.length() < 2 || className.charAt(0) != '[') {
            return className;
        }
        if (className.length() == 2) {
            switch (className.charAt(1)) {
                case 'B': {
                    return "byte[]";
                }
                case 'C': {
                    return "char[]";
                }
                case 'I': {
                    return "int[]";
                }
                case 'D': {
                    return "double[]";
                }
                case 'F': {
                    return "float[]";
                }
                case 'J': {
                    return "long[]";
                }
                case 'S': {
                    return "short[]";
                }
                case 'Z': {
                    return "boolean[]";
                }
            }
            return className;
        }
        if (className.charAt(className.length() - 1) == ';' && className.charAt(1) == 'L') {
            return className.substring(2, className.length() - 1) + "[]";
        }
        return className;
    }

    @Override
    public Map<String, ? extends IlrClassInfo> getClassesInfo() {
        List<IlrObjectInfo> infos = this.getLinkedObjectsInfo();
        if (!infos.contains(this)) {
            infos.add(this);
        }
        HashMap<String, ClassInfo> result = new HashMap<String, ClassInfo>();
        for (IlrObjectInfo oinfo : infos) {
            String className = oinfo.getObjectClassName();
            ClassInfo classInfo = (ClassInfo)result.get(className);
            if (classInfo == null) {
                classInfo = new ClassInfo();
                classInfo.name = className;
                result.put(className, classInfo);
            }
            ++classInfo.count;
            classInfo.totalSize += oinfo.getSize();
        }
        return result;
    }

    @Override
    public List<IlrObjectInfo> getLinkedObjectsInfo() {
        HashSet<IlrObjectInfo> infos = new HashSet<IlrObjectInfo>();
        this.getLinkedObjectsInfo(infos, this);
        ArrayList<IlrObjectInfo> result = new ArrayList<IlrObjectInfo>();
        result.addAll(infos);
        return result;
    }

    protected void getLinkedObjectsInfo(HashSet<IlrObjectInfo> infos, IlrObjectInfo object) {
        for (IlrFieldInfo field : object.getFields()) {
            if (field.isPrimitive() || field.getObjectInfo() == null || infos.contains(field.getObjectInfo())) continue;
            infos.add(field.getObjectInfo());
            this.getLinkedObjectsInfo(infos, field.getObjectInfo());
        }
        for (IlrObjectInfo entry : object.getArrayEntries()) {
            if (entry == null || infos.contains(entry)) continue;
            infos.add(entry);
            this.getLinkedObjectsInfo(infos, entry);
        }
    }

    @Override
    public synchronized long getTotalSize() {
        if (this.tsize == -1L) {
            this.tsize = this.getSize();
            List<IlrObjectInfo> objects = this.getLinkedObjectsInfo();
            for (IlrObjectInfo object : objects) {
                this.tsize += object.getSize();
            }
        }
        return this.tsize;
    }
}

