/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mprofiler;

import ilog.rules.res.mprofiler.IlrFieldInfo;
import ilog.rules.res.mprofiler.IlrFieldInfoImpl;
import ilog.rules.res.mprofiler.IlrObjectInfo;
import ilog.rules.res.mprofiler.IlrObjectInfoBase;
import java.util.ArrayList;
import java.util.List;

public class IlrObjectInfoImpl
extends IlrObjectInfoBase
implements IlrObjectInfo {
    protected long size = 0L;
    protected ArrayList<IlrFieldInfo> fieldsInfo = new ArrayList();
    protected ArrayList<IlrObjectInfo> arrayEntries = new ArrayList();
    protected Class<?> objectClass;
    protected Object object;
    protected long id;

    public IlrObjectInfoImpl(long id, Class<?> objectClass) {
        this.objectClass = objectClass;
        this.id = id;
    }

    public void addArrayEntry(IlrObjectInfoImpl objectInfo) {
        this.arrayEntries.add(objectInfo);
    }

    public void addField(String name, Object value, Class<?> objectClass, IlrObjectInfoImpl objectInfo) {
        IlrFieldInfoImpl field = new IlrFieldInfoImpl(name, value, objectInfo, objectClass);
        this.fieldsInfo.add(field);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getObjectClassName() {
        return this.objectClass.getName();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public List<IlrFieldInfo> getFields() {
        return this.fieldsInfo;
    }

    @Override
    public List<IlrObjectInfo> getArrayEntries() {
        return this.arrayEntries;
    }

    @Override
    protected String toStringValue(Object value) {
        if (value != null) {
            if (value.getClass() == Integer.class || value.getClass() == Boolean.class || value.getClass() == Long.class) {
                return value.toString();
            }
            if (value instanceof String) {
                if (((String)value).length() < 20) {
                    return (String)value;
                }
                return ((String)value).substring(0, 20);
            }
        }
        return null;
    }

    @Override
    public String getValue() {
        return this.toStringValue(this.object);
    }
}

