/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mprofiler.xml;

import ilog.rules.res.mprofiler.IlrObjectInfo;
import ilog.rules.res.mprofiler.xml.IlrFieldInfoImpl;
import ilog.rules.res.mprofiler.xml.IlrObjectInfoImpl;
import ilog.rules.res.mprofiler.xml.IlrParserException;
import ilog.rules.res.mprofiler.xml.IlrXMLParserListener;
import ilog.rules.tools.IlrVersionFullInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IlrXMLParser {
    public Map<Long, IlrObjectInfo> parse(File file, IlrXMLParserListener listener) throws IlrParserException, ParserConfigurationException, IOException, SAXException {
        HashMap<Long, IlrObjectInfo> result = new HashMap<Long, IlrObjectInfo>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(file);
        Element rootElement = document.getDocumentElement();
        NodeList memoryElements = rootElement.getElementsByTagName("memory");
        if (memoryElements.getLength() == 0) {
            throw new IlrParserException("Does not contain any memory element");
        }
        if (memoryElements.getLength() > 1) {
            throw new IlrParserException("Contains more than one memory element");
        }
        Element memoryElement = (Element)memoryElements.item(0);
        String jrulesVersion = memoryElement.getAttribute("jrules-version");
        if (!(jrulesVersion != null && jrulesVersion.equals(IlrVersionFullInfo.getFullVersionNumber()) || listener == null)) {
            String message = "Parser version (" + IlrVersionFullInfo.getFullVersionNumber() + ") is different from the XML memory dump version (" + jrulesVersion + ")";
            listener.warning(message);
        }
        NodeList objectElements = memoryElement.getElementsByTagName("object");
        for (int i = 0; i < objectElements.getLength(); ++i) {
            Element objectElement = (Element)objectElements.item(i);
            long id = Integer.parseInt(objectElement.getAttribute("id"));
            int size = Integer.parseInt(objectElement.getAttribute("size"));
            int tsize = -1;
            String clazz = objectElement.getAttribute("class");
            String svalue = objectElement.getAttribute("value");
            if (svalue.length() == 0) {
                svalue = null;
            }
            IlrObjectInfoImpl oinfo = new IlrObjectInfoImpl(id, svalue, clazz, size, tsize, result);
            result.put(id, oinfo);
            NodeList fieldElements = objectElement.getElementsByTagName("field");
            for (int j = 0; j < fieldElements.getLength(); ++j) {
                Element fieldElement = (Element)fieldElements.item(j);
                int fid = -1;
                if (fieldElement.getAttribute("id") != null && !fieldElement.getAttribute("id").equals("")) {
                    fid = Integer.parseInt(fieldElement.getAttribute("id"));
                }
                String fclazz = fieldElement.getAttribute("class");
                String name = fieldElement.getAttribute("name");
                String value = fieldElement.getAttribute("value");
                value = value.length() == 0 ? null : value;
                oinfo.addField(new IlrFieldInfoImpl(name, value, fclazz, fid, result));
            }
            NodeList entriesElements = objectElement.getElementsByTagName("array-entry");
            for (int j = 0; j < entriesElements.getLength(); ++j) {
                Element entryElement = (Element)entriesElements.item(j);
                long entryId = Long.parseLong(entryElement.getAttribute("id"));
                oinfo.addArrayEntry(entryId);
            }
        }
        return result;
    }
}

