/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence;

import com.ibm.rules.res.message.internal.LocalizedException;
import com.ibm.rules.res.persistence.DAOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;

public class IlrDAOException
extends LocalizedException {
    private static final long serialVersionUID = 1L;

    public IlrDAOException(String resourceBundleName, String messageCode) {
        super(resourceBundleName, messageCode, null);
    }

    public IlrDAOException(String resourceBundleName, String messageCode, Throwable cause) {
        super(resourceBundleName, messageCode, null, cause);
    }

    public IlrDAOException(String resourceBundleName, String messageCode, String[] messageParams, Throwable cause) {
        super(resourceBundleName, messageCode, (Object[])messageParams, cause);
    }

    public IlrDAOException(DAOException e) {
        super(e.getResourceBundleName(), e.getMessageCode(), e.getMessageParameters(), e.getCause());
    }

    public IlrDAOException(String resourceBundleName, String messageCode, String[] messageParams) {
        super(resourceBundleName, messageCode, messageParams);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream err) {
        super.printStackTrace(err);
        if (this.getCause() instanceof SQLException) {
            SQLException sqlEx = (SQLException)this.getCause();
            for (SQLException ex = sqlEx.getNextException(); ex != null; ex = ex.getNextException()) {
                ex.printStackTrace(err);
            }
        }
    }

    @Override
    public void printStackTrace(PrintWriter err) {
        super.printStackTrace(err);
        if (this.getCause() instanceof SQLException) {
            SQLException sqlEx = (SQLException)this.getCause();
            for (SQLException ex = sqlEx.getNextException(); ex != null; ex = ex.getNextException()) {
                ex.printStackTrace(err);
            }
        }
    }

    public static void main(String[] args) {
        SQLException sqlEx = new SQLException("the SQLException message");
        SQLException nextSQLEx = new SQLException("the *next* SQLException message");
        sqlEx.setNextException(nextSQLEx);
        sqlEx.initCause(new RuntimeException("The innermost cause message"));
        IlrDAOException daoException = new IlrDAOException("fakeBundleName", "toto", sqlEx);
        daoException.printStackTrace();
    }
}

