/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence;

import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrDiagnosticResult;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import ilog.rules.res.persistence.IlrTransaction;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;

public interface IlrRepositoryDAO {
    public String getDetails();

    public IlrDiagnosticResult executeDiagnostic();

    public Set<IlrMutableRuleAppInformation> load(IlrRepositoryFactory var1) throws IlrDAOException;

    public IlrPath getCanonicalRulesetPath(IlrPath var1) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public Map<String, String> getProperties(IlrPath var1) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public IlrRESRulesetArchive getRESRulesetArchive(IlrPath var1) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public byte[] getRESRulesetArchiveAsBytes(IlrPath var1) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public ClassLoader getManagedXOMClassLoader(IlrPath var1, ClassLoader var2, boolean var3, boolean var4) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void setRESRulesetArchive(IlrPath var1, IlrEngineType var2, InputStream var3) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void setProperty(IlrPath var1, String var2, String var3) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void setDisplayName(IlrPath var1, String var2) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void setDescription(IlrPath var1, String var2) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public IlrTransaction beginTransaction() throws IlrDAOException;

    public void addRuleApp(IlrMutableRuleAppInformation var1) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void addRuleApp(IlrMutableRuleAppInformation var1, IlrTransaction var2) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void updateRuleApp(IlrMutableRuleAppInformation var1) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void updateRuleApp(IlrMutableRuleAppInformation var1, IlrTransaction var2) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void addRuleset(IlrPath var1, IlrMutableRulesetArchiveInformation var2) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void addRuleset(IlrPath var1, IlrMutableRulesetArchiveInformation var2, IlrTransaction var3) throws IlrDAOException, IlrResourceNotFoundDAOException;

    public void removeRuleApp(IlrPath var1) throws IlrDAOException;

    public void removeRuleApp(IlrPath var1, IlrTransaction var2) throws IlrDAOException;

    public void removeRuleset(IlrPath var1) throws IlrDAOException;

    public void removeRuleset(IlrPath var1, IlrTransaction var2) throws IlrDAOException;

    public void setConfigParameters(Map<String, String> var1) throws IlrDAOException;

    public void setClassLoader(ClassLoader var1) throws IlrDAOException;

    public XOMRepositoryDAO getXOMRepositoryDAO();
}

