/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl;

import com.ibm.rules.res.persistence.internal.DAOLoader;
import ilog.rules.crypto.IlrEncryptionService;
import ilog.rules.crypto.IlrEncryptionServiceException;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.IlrRepositoryDAOFactory;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.file.IlrFileRepositoryDAO;
import ilog.rules.res.persistence.impl.jdbc.IlrDataSourceDAOFactory;
import ilog.rules.res.persistence.impl.jdbc.IlrDriverDAOFactory;
import java.util.Map;
import java.util.Properties;

public class IlrRepositoryDAOFactoryImpl
implements IlrRepositoryDAOFactory {
    public static final int NO_USERNAME_NO_PASSWORD_BLANK_VALUES_POLICY = 0;
    public static final int NO_USERNAME_NO_PASSWORD_NO_VALUES_POLICY = 1;

    @Override
    public IlrRepositoryDAO getDataSourceRepositoryDAO(boolean transactionSupport) throws IlrDAOException {
        return this.getDataSourceRepositoryDAO(null, transactionSupport);
    }

    @Override
    public IlrRepositoryDAO getDataSourceRepositoryDAO(String jndiName, boolean transactionSupport) throws IlrDAOException {
        return (IlrRepositoryDAO)IlrDataSourceDAOFactory.getDAO("RepositoryDAODescriptor.xml", jndiName, transactionSupport);
    }

    @Override
    public IlrRepositoryDAO getDriverRepositoryDAO(ClassLoader classLoader, String driverName, String url, String user, String password, String cryptedPassword) throws IlrDAOException {
        Properties props = this.getUserPasswordProperties(user, password, cryptedPassword);
        return (IlrRepositoryDAO)IlrDriverDAOFactory.getDAO("RepositoryDAODescriptor.xml", classLoader, driverName, url, props);
    }

    protected Properties getUserPasswordProperties(String user, String password, String cryptedPassword) throws IlrDAOException {
        String effectivePassword = null;
        try {
            effectivePassword = this.determinePasswordToUse(password, cryptedPassword);
        }
        catch (IlrEncryptionServiceException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.JDBC_PASSWORD_DECRYPTION_ERROR, new String[]{"********"}, e);
        }
        Properties props = new Properties();
        if (user != null) {
            props.setProperty("user", user);
        }
        if (effectivePassword != null) {
            props.setProperty("password", effectivePassword);
        }
        return props;
    }

    private String determinePasswordToUse(String password, String cryptedPassword) throws IlrEncryptionServiceException {
        if (this.isNotEmpty(password)) {
            return password;
        }
        if (this.isNotEmpty(cryptedPassword)) {
            return IlrEncryptionService.getInstance().decrypt(cryptedPassword);
        }
        return null;
    }

    private boolean isNotEmpty(String value) {
        return value != null && value.length() > 0;
    }

    @Override
    public IlrRepositoryDAO getFileRepositoryDAO() throws IlrDAOException {
        return this.getFileRepositoryDAO(null);
    }

    @Override
    public IlrRepositoryDAO getFileRepositoryDAO(String repositoryPath) throws IlrDAOException {
        return new IlrFileRepositoryDAO(repositoryPath);
    }

    @Override
    public IlrRepositoryDAO getFileRepositoryDAO(ClassLoader classLoader, String repositoryPath) throws IlrDAOException {
        return new IlrFileRepositoryDAO(classLoader, repositoryPath);
    }

    @Override
    public IlrRepositoryDAO getRepositoryDAO(Map<String, String> properties) throws IlrDAOException {
        DAOLoader persistenceLoader = new DAOLoader();
        IlrRepositoryDAO repositoryDAO = (IlrRepositoryDAO)persistenceLoader.getDAO("persistence", DAOLoader.PERSISTENCE_ALIAS, DAOLoader.PERSISTENCE_PROPERTY_ALIAS, properties);
        repositoryDAO.setConfigParameters(properties);
        return repositoryDAO;
    }
}

