/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.file;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.DAOLoader;
import com.ibm.rules.res.persistence.internal.XOMClassLoader;
import com.ibm.rules.res.persistence.internal.XOMClassLoaderFactory;
import com.ibm.rules.res.persistence.internal.file.FileXOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.jdbc.GenericXOMRepositoryDAO;
import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.internal.IlrCRERulesetArchiveImpl;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import ilog.rules.res.model.internal.IlrRuleAppPropertiesImpl;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrDiagnosticResult;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import ilog.rules.res.persistence.IlrTransaction;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.IlrDiagnosticResultImpl;
import ilog.rules.res.persistence.impl.file.IlrFileTransaction;
import ilog.rules.res.persistence.impl.file.helper.IlrRuleAppDir;
import ilog.rules.res.persistence.impl.file.helper.IlrRulesetDir;
import ilog.rules.res.persistence.impl.file.security.IlrGetCanonicalPathPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrIsDirectoryPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrMkdirsPrivilegedAction;
import java.io.File;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class IlrFileRepositoryDAO
implements IlrRepositoryDAO {
    private final RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.persistence", "ilog.rules.res.persistence.impl.messages");
    private static final String DEFAULT_REPOSITORY_PATH = "res_data";
    protected XOMRepositoryDAO xomRepository;
    protected static final String CONFIGURATION_PARAMETERS_FILENAME = "config.properties";
    protected File configurationParameterFile;
    private final File repositoryDir;
    private final String repositoryPath;
    private final boolean rulesetArchiveExpanded;
    private ClassLoader classLoader;

    public IlrFileRepositoryDAO(ClassLoader classLoader, String repositoryPath, boolean rulesetArchiveExpanded) throws IlrDAOException {
        this.rulesetArchiveExpanded = rulesetArchiveExpanded;
        this.setClassLoader(classLoader);
        this.repositoryDir = repositoryPath != null && repositoryPath.length() > 0 ? new File(repositoryPath) : new File(DEFAULT_REPOSITORY_PATH);
        this.configurationParameterFile = new File(this.repositoryDir, CONFIGURATION_PARAMETERS_FILENAME);
        try {
            IlrMkdirsPrivilegedAction.execute(this.repositoryDir);
            this.repositoryPath = IlrGetCanonicalPathPrivilegedAction.execute(this.repositoryDir);
            if (!IlrIsDirectoryPrivilegedAction.execute(this.repositoryDir)) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_REP_DIRECTORY, new String[]{repositoryPath});
            }
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.INIT_FILE_DAO_ERROR, new String[]{repositoryPath}, e.getCause());
        }
    }

    public IlrFileRepositoryDAO(ClassLoader classLoader, String repositoryPath) throws IlrDAOException {
        this(classLoader, repositoryPath, false);
    }

    public IlrFileRepositoryDAO(String repositoryPath) throws IlrDAOException {
        this(null, repositoryPath, false);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) throws IlrDAOException {
        this.classLoader = classLoader;
    }

    @Override
    public String getDetails() {
        return this.repositoryPath;
    }

    @Override
    public IlrDiagnosticResult executeDiagnostic() {
        Properties infos = new Properties();
        infos.setProperty("daoClassName", this.getClass().getName());
        infos.setProperty("repositoryPath", this.repositoryPath);
        return new IlrDiagnosticResultImpl(infos, true);
    }

    @Override
    public Set<IlrMutableRuleAppInformation> load(IlrRepositoryFactory repositoryFactory) throws IlrDAOException {
        try {
            HashSet<IlrMutableRuleAppInformation> ruleApps = new HashSet<IlrMutableRuleAppInformation>();
            List<IlrRuleAppDir.RuleAppItem> ruleAppItems = IlrRuleAppDir.load(this.repositoryDir, repositoryFactory);
            for (IlrRuleAppDir.RuleAppItem ruleAppItem : ruleAppItems) {
                IlrRulesetDir.load(repositoryFactory, ruleAppItem.getRuleAppDir(), ruleAppItem.getRuleApp());
                ruleApps.add(ruleAppItem.getRuleApp());
            }
            return ruleApps;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LOAD_REPOSITORY_ERROR, e);
        }
    }

    @Override
    public void setDisplayName(IlrPath path, String displayName) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isCanonical()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        try {
            if (path.isRuleAppPath()) {
                if (!IlrRuleAppDir.setDisplayName(this.repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), displayName)) {
                    throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND_FILE, new String[]{String.valueOf(path), this.repositoryPath});
                }
            } else if (!IlrRulesetDir.setDisplayName(this.repositoryDir, path, displayName)) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND_FILE, new String[]{String.valueOf(path), this.repositoryPath});
            }
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_DISPLAY_NAME_ERROR, new String[]{String.valueOf(path), displayName}, e.getCause());
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_DISPLAY_NAME_ERROR, new String[]{String.valueOf(path), displayName}, e);
        }
    }

    @Override
    public void setDescription(IlrPath path, String description) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isCanonical()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        try {
            if (path.isRuleAppPath()) {
                if (!IlrRuleAppDir.setDescription(this.repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), description)) {
                    throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND_FILE, new String[]{String.valueOf(path), this.repositoryPath});
                }
            } else if (!IlrRulesetDir.setDescription(this.repositoryDir, path, description)) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND_FILE, new String[]{String.valueOf(path), this.repositoryPath});
            }
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_DESCRIPTION_ERROR, new String[]{String.valueOf(path), description}, e.getCause());
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_DESCRIPTION_ERROR, new String[]{String.valueOf(path), description}, e);
        }
    }

    @Override
    public void setProperty(IlrPath path, String key, String value) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isCanonical()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        try {
            if (path.isRuleAppPath()) {
                if (!IlrRuleAppDir.setProperty(this.repositoryDir, path, key, value)) {
                    throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND_FILE, new String[]{String.valueOf(path), this.repositoryPath});
                }
            } else if (!IlrRulesetDir.setProperty(this.repositoryDir, path, key, value)) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND_FILE, new String[]{String.valueOf(path), this.repositoryPath});
            }
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_PROPERTY_ERROR, new String[]{String.valueOf(path), key, value}, e.getCause());
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_PROPERTY_ERROR, new String[]{String.valueOf(path), key, value}, e);
        }
    }

    @Override
    public void setRESRulesetArchive(IlrPath rulesetPath, IlrEngineType engineType, InputStream archive) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!rulesetPath.isCanonical() || !rulesetPath.isRulesetPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(rulesetPath)});
        }
        if (archive == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.RULESET_ARCHIVE_NULL, new String[]{String.valueOf(rulesetPath)});
        }
        try {
            if (!IlrRulesetDir.setRESRulesetArchive(this.repositoryDir, rulesetPath, engineType, archive, this.rulesetArchiveExpanded)) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND_FILE, new String[]{String.valueOf(rulesetPath), this.repositoryPath});
            }
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_RULESET_ARCHIVE_ERROR, new String[]{String.valueOf(rulesetPath)}, e.getCause());
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_RULESET_ARCHIVE_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
    }

    @Override
    public IlrPath getCanonicalRulesetPath(IlrPath path) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isRulesetPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        IlrPath result = null;
        try {
            result = path.getRuleAppVersion() != null && path.getRulesetVersion() != null ? IlrRulesetDir.getCanonicalRulesetPath(this.repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName(), path.getRulesetVersion()) : (path.getRuleAppVersion() != null && path.getRulesetVersion() == null ? IlrRulesetDir.getCanonicalRulesetPath(this.repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName()) : (path.getRuleAppVersion() == null && path.getRulesetVersion() != null ? IlrRulesetDir.getCanonicalRulesetPath(this.repositoryDir, path.getRuleAppName(), path.getRulesetName(), path.getRulesetVersion()) : IlrRulesetDir.getCanonicalRulesetPath(this.repositoryDir, path.getRuleAppName(), path.getRulesetName())));
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_CANONICAL_RULESETPATH_ERROR, new String[]{String.valueOf(path)}, e);
        }
        if (result == null) {
            throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND_FILE, new String[]{String.valueOf(path), this.repositoryPath});
        }
        return result;
    }

    @Override
    public Map<String, String> getProperties(IlrPath path) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isCanonical()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        try {
            if (path.isRuleAppPath()) {
                Map<String, String> props = IlrRuleAppDir.getProperties(this.repositoryDir, path);
                if (props == null) {
                    throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND_FILE, new String[]{String.valueOf(path), this.repositoryPath});
                }
                return props;
            }
            Map<String, String> props = IlrRulesetDir.getProperties(this.repositoryDir, path);
            if (props == null) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND_FILE, new String[]{String.valueOf(path), this.repositoryPath});
            }
            return props;
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_PROPERTIES_ERROR, new String[]{String.valueOf(path)}, e);
        }
    }

    protected IlrEngineType getEngineType(IlrPath rulesetPath) throws IlrDAOException, IlrResourceNotFoundDAOException {
        IlrEngineType result;
        String engineTypeAsString = null;
        Map<String, String> properties = this.getProperties(rulesetPath);
        if (properties != null) {
            engineTypeAsString = properties.get("ruleset.engine");
        }
        if ((result = IlrEngineType.toEngineType(engineTypeAsString)) == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_ENGINE_TYPE_ERROR, new String[]{String.valueOf(engineTypeAsString)}, null);
        }
        return result;
    }

    @Override
    public IlrRESRulesetArchive getRESRulesetArchive(IlrPath rulesetPath) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!rulesetPath.isCanonical() || !rulesetPath.isRulesetPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(rulesetPath)});
        }
        IlrRESRulesetArchive result = null;
        try {
            IlrEngineType engineType = this.getEngineType(rulesetPath);
            if (this.rulesetArchiveExpanded) {
                IlrRulesetArchive archive = IlrRulesetDir.getExpandedCRERulesetArchive(this.repositoryDir, rulesetPath, engineType);
                if (archive == null) {
                    throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND_FILE, new String[]{String.valueOf(rulesetPath), this.repositoryPath});
                }
                result = new IlrCRERulesetArchiveImpl(archive);
            } else {
                byte[] archive = IlrRulesetDir.getRESRulesetArchive(this.repositoryDir, rulesetPath, engineType, this.rulesetArchiveExpanded);
                if (archive == null) {
                    throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND_FILE, new String[]{String.valueOf(rulesetPath), this.repositoryPath});
                }
                result = IlrRESArchiveUtil.getRESRulesetArchive(engineType, StreamUtil.toStream(archive));
            }
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_RULESET_ARCHIVE_ERROR, new String[]{String.valueOf(rulesetPath)}, e.getCause());
        }
        catch (IlrDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_RULESET_ARCHIVE_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
        if (result == null) {
            throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND_FILE, new String[]{String.valueOf(rulesetPath), this.repositoryPath});
        }
        return result;
    }

    @Override
    public IlrTransaction beginTransaction() throws IlrDAOException {
        IlrFileTransaction transaction = new IlrFileTransaction();
        try {
            transaction.begin();
        }
        catch (IlrDAOException e) {
            transaction.close();
            throw e;
        }
        return transaction;
    }

    @Override
    public void addRuleApp(IlrMutableRuleAppInformation ruleApp) throws IlrDAOException {
        this.addRuleApp(ruleApp, null);
    }

    @Override
    public void addRuleApp(IlrMutableRuleAppInformation ruleApp, IlrTransaction transaction) throws IlrDAOException {
        try {
            Set rulesets = ruleApp.getRulesets();
            for (IlrMutableRulesetArchiveInformation ruleset : rulesets) {
                IlrRESRulesetArchive archive = ruleset.getRESRulesetArchive();
                if (archive == null) {
                    throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.RULESET_ARCHIVE_NULL, new String[]{String.valueOf(ruleset)});
                }
                if (!IlrRESArchiveUtil.isEmpty(archive)) continue;
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.RULESET_ARCHIVE_EMPTY, new String[]{String.valueOf(ruleset)});
            }
            File ruleAppDir = IlrRuleAppDir.add(this.repositoryDir, ruleApp);
            for (IlrMutableRulesetArchiveInformation ruleset : rulesets) {
                String engineTypeAsString = (String)ruleset.getProperties().get("ruleset.engine");
                IlrEngineType engineType = IlrEngineType.toEngineType(engineTypeAsString);
                if (engineType == null) {
                    throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_ENGINE_TYPE_ERROR, new String[]{String.valueOf(engineTypeAsString)});
                }
                IlrRulesetDir.add(ruleset.getName(), ruleset.getVersion(), ruleAppDir, ruleset, engineType, this.rulesetArchiveExpanded);
            }
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.ADD_RULEAPP_ERROR, new String[]{String.valueOf(ruleApp)}, e.getCause());
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.ADD_RULEAPP_ERROR, new String[]{String.valueOf(ruleApp)}, e);
        }
    }

    @Override
    public void addRuleset(IlrPath rulesetPath, IlrMutableRulesetArchiveInformation ruleset) throws IlrDAOException, IlrResourceNotFoundDAOException {
        this.addRuleset(rulesetPath, ruleset, null);
    }

    @Override
    public void addRuleset(IlrPath rulesetPath, IlrMutableRulesetArchiveInformation ruleset, IlrTransaction transaction) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!rulesetPath.isCanonical() || !rulesetPath.isRulesetPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(rulesetPath)});
        }
        IlrRESRulesetArchive archive = ruleset.getRESRulesetArchive();
        if (archive == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.RULESET_ARCHIVE_NULL, new String[]{String.valueOf(rulesetPath)});
        }
        if (IlrRESArchiveUtil.isEmpty(archive)) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.RULESET_ARCHIVE_EMPTY, new String[]{String.valueOf(rulesetPath)});
        }
        try {
            File ruleAppDir = IlrRuleAppDir.getDir(this.repositoryDir, rulesetPath.getRuleAppName(), rulesetPath.getRuleAppVersion());
            if (ruleAppDir == null) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND_FILE, new String[]{"/" + rulesetPath.getRuleAppName() + "/" + rulesetPath.getRuleAppVersion(), this.repositoryPath});
            }
            String engineTypeAsString = (String)ruleset.getProperties().get("ruleset.engine");
            IlrEngineType engineType = IlrEngineType.toEngineType(engineTypeAsString);
            if (engineType == null) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_ENGINE_TYPE_ERROR, new String[]{String.valueOf(engineTypeAsString)}, null);
            }
            IlrRulesetDir.add(rulesetPath.getRulesetName(), rulesetPath.getRulesetVersion(), ruleAppDir, ruleset, engineType, this.rulesetArchiveExpanded);
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.ADD_RULESET_ERROR, new String[]{String.valueOf(rulesetPath)}, e.getCause());
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.ADD_RULESET_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
    }

    @Override
    public void removeRuleApp(IlrPath ruleAppPath) throws IlrDAOException {
        this.removeRuleApp(ruleAppPath, null);
    }

    @Override
    public void removeRuleApp(IlrPath ruleAppPath, IlrTransaction transaction) throws IlrDAOException {
        if (!ruleAppPath.isCanonical() || !ruleAppPath.isRuleAppPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(ruleAppPath)});
        }
        try {
            IlrRuleAppDir.remove(this.repositoryDir, ruleAppPath);
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.REMOVE_RULEAPP_ERROR, new String[]{String.valueOf(ruleAppPath)}, e.getCause());
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.REMOVE_RULEAPP_ERROR, new String[]{String.valueOf(ruleAppPath)}, e);
        }
    }

    @Override
    public void removeRuleset(IlrPath rulesetPath) throws IlrDAOException {
        this.removeRuleset(rulesetPath, null);
    }

    @Override
    public void removeRuleset(IlrPath rulesetPath, IlrTransaction transaction) throws IlrDAOException {
        if (!rulesetPath.isCanonical() || !rulesetPath.isRulesetPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(rulesetPath)});
        }
        try {
            IlrRulesetDir.remove(this.repositoryDir, rulesetPath);
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.REMOVE_RULESET_ERROR, new String[]{String.valueOf(rulesetPath)}, e.getCause());
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.REMOVE_RULESET_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
    }

    @Override
    public void updateRuleApp(IlrMutableRuleAppInformation ruleApp) throws IlrDAOException, IlrResourceNotFoundDAOException {
        this.updateRuleApp(ruleApp, null);
    }

    @Override
    public void updateRuleApp(IlrMutableRuleAppInformation ruleApp, IlrTransaction transaction) throws IlrDAOException, IlrResourceNotFoundDAOException {
        try {
            if (!IlrRuleAppDir.setDisplayName(this.repositoryDir, ruleApp.getName(), ruleApp.getVersion(), ruleApp.getDisplayName())) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND_FILE, new String[]{String.valueOf(ruleApp), this.repositoryPath});
            }
            if (!IlrRuleAppDir.setDescription(this.repositoryDir, ruleApp.getName(), ruleApp.getVersion(), ruleApp.getDescription())) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND_FILE, new String[]{String.valueOf(ruleApp), this.repositoryPath});
            }
            if (!IlrRuleAppDir.setProperties(this.repositoryDir, ruleApp.getName(), ruleApp.getVersion(), (IlrRuleAppPropertiesImpl)ruleApp.getProperties())) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND_FILE, new String[]{String.valueOf(ruleApp), this.repositoryPath});
            }
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UPDATE_RULEAPP_ERROR, new String[]{String.valueOf(ruleApp)}, e.getCause());
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UPDATE_RULEAPP_ERROR, new String[]{String.valueOf(ruleApp)}, e);
        }
    }

    public File getConfigurationParameterFile() {
        return this.configurationParameterFile;
    }

    @Override
    public byte[] getRESRulesetArchiveAsBytes(IlrPath rulesetPath) throws IlrDAOException, IlrResourceNotFoundDAOException {
        try {
            return IlrRulesetDir.getRESRulesetArchive(this.repositoryDir, rulesetPath, this.getEngineType(rulesetPath), this.rulesetArchiveExpanded);
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_RULESET_ARCHIVE_ERROR, new String[]{String.valueOf(rulesetPath)}, e.getCause());
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_RULESET_ARCHIVE_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
    }

    @Override
    public XOMRepositoryDAO getXOMRepositoryDAO() {
        return this.xomRepository;
    }

    @Override
    public ClassLoader getManagedXOMClassLoader(IlrPath canonicalPath, ClassLoader xomcl, boolean clientFirst, boolean lazyLoading) throws IlrDAOException, IlrResourceNotFoundDAOException {
        try {
            XOMClassLoader cl = (XOMClassLoader)new XOMClassLoaderFactory().getManagedXOMClassLoader(canonicalPath, this, this.xomRepository, xomcl, clientFirst, lazyLoading);
            XOMClassLoaderFactory.displayInfoTrace(clientFirst, canonicalPath, cl.getDependencyTree());
            return cl;
        }
        catch (DAOException e) {
            throw new IlrDAOException(e);
        }
    }

    @Override
    public void setConfigParameters(Map<String, String> parameters) throws IlrDAOException {
        DAOLoader xomPersistenceLoader = new DAOLoader();
        xomPersistenceLoader.setClassLoader(this.classLoader);
        try {
            this.xomRepository = (XOMRepositoryDAO)xomPersistenceLoader.getDAO("xomPersistence", DAOLoader.XOM_PERSISTENCE_ALIAS, DAOLoader.XOM_PERSISTENCE_PROPERTY_ALIAS, parameters);
            if (this.xomRepository instanceof FileXOMRepositoryDAO) {
                this.logger.log(Level.INFO, IlrDAOLocalization.FILE_XOM_PERSISTENCE, new Object[]{this.xomRepository.getDetails()}, null);
            } else if (this.xomRepository instanceof GenericXOMRepositoryDAO) {
                this.logger.log(Level.INFO, IlrDAOLocalization.DB_XOM_PERSISTENCE, new Object[]{this.xomRepository.getDetails()}, null);
            }
        }
        catch (Throwable t) {
            this.logger.warning(IlrDAOLocalization.XOM_PERSISTENCE_NOT_SET, new Object[]{t.getMessage()}, t);
            try {
                this.xomRepository = new FileXOMRepositoryDAO(null);
                this.logger.warning(IlrDAOLocalization.DEFAULT_XOM_REPOSITORY, new Object[]{"file", this.xomRepository.getDetails()}, null);
            }
            catch (DAOException e) {
                // empty catch block
            }
        }
    }
}

