/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.file.helper;

import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrReadOnlyProperties;
import ilog.rules.res.model.internal.IlrRuleAppPropertiesImpl;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.file.helper.IlrFile;
import ilog.rules.res.persistence.impl.file.security.IlrDeletePrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrDirectoryNameFilter;
import ilog.rules.res.persistence.impl.file.security.IlrDirectoryVersionFilter;
import ilog.rules.res.persistence.impl.file.security.IlrIsDirectoryPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrIsFilePrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrListFilesPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrMkdirsPrivilegedAction;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class IlrRuleAppDir {
    public static final String RESOURCE_BUNDLE_NAME = "ilog.rules.res.persistence.impl.messages";

    public static List<RuleAppItem> load(File repositoryDir, IlrRepositoryFactory repositoryFactory) throws IlrDAOException, IlrFormatException, IOException {
        File[] ruleAppDirs = IlrRuleAppDir.listRuleAppDirs(repositoryDir);
        ArrayList<RuleAppItem> ruleApps = new ArrayList<RuleAppItem>();
        for (File ruleAppDir : ruleAppDirs) {
            File[] versionDirs;
            for (File versionDir : versionDirs = IlrRuleAppDir.listRuleAppVersionDirs(ruleAppDir)) {
                File creationDateFile = new File(versionDir, "creation_date.txt");
                if (!IlrIsFilePrivilegedAction.execute(creationDateFile)) continue;
                Date creationDate = IlrFile.getCreationDate(creationDateFile);
                String displayName = IlrFile.getStringContent(new File(versionDir, "display_name.txt"));
                String description = IlrFile.getStringContent(new File(versionDir, "description.txt"));
                IlrMutableRuleAppInformation ruleApp = repositoryFactory.createRuleApp(ruleAppDir.getName(), IlrVersion.parseVersion(versionDir.getName()), creationDate);
                ruleApp.setDisplayName(displayName);
                ruleApp.setDescription(description);
                ruleApps.add(new RuleAppItem(versionDir, ruleApp));
            }
        }
        return ruleApps;
    }

    static File[] listRuleAppVersionDirs(File ruleAppDir) throws IlrDAOException {
        File[] versionDirs = IlrListFilesPrivilegedAction.execute(ruleAppDir, new IlrDirectoryVersionFilter());
        if (versionDirs == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LIST_RULEAPP_VERSION_DIRS_IO_ERROR, new String[]{ruleAppDir.getPath()});
        }
        return versionDirs;
    }

    static File[] listRuleAppDirs(File repositoryDir) throws IlrDAOException {
        File[] ruleAppDirs = IlrListFilesPrivilegedAction.execute(repositoryDir, new IlrDirectoryNameFilter(true));
        if (ruleAppDirs == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LIST_RULEAPP_DIRS_IO_ERROR, new String[]{repositoryDir.getPath()});
        }
        return ruleAppDirs;
    }

    public static File getDir(File repositoryDir, String name, IlrVersion version) {
        File ruleAppDir = new File(repositoryDir, name);
        File versionDir = new File(ruleAppDir, version.toString());
        if (IlrIsDirectoryPrivilegedAction.execute(versionDir)) {
            return versionDir;
        }
        return null;
    }

    public static File add(File repositoryDir, IlrMutableRuleAppInformation ruleApp) throws PrivilegedActionException, IOException {
        File ruleAppDir = new File(repositoryDir, ruleApp.getName());
        File versionDir = new File(ruleAppDir, ruleApp.getVersion().toString());
        IlrMkdirsPrivilegedAction.execute(versionDir);
        IlrFile.setCreationDate(new File(versionDir, "creation_date.txt"), ruleApp.getCreationDate().getTime());
        IlrFile.setContent(new File(versionDir, "display_name.txt"), ruleApp.getDisplayName());
        IlrFile.setContent(new File(versionDir, "description.txt"), ruleApp.getDescription());
        IlrFile.setProperties(new File(versionDir, "properties.txt"), (IlrRuleAppPropertiesImpl)ruleApp.getProperties());
        return versionDir;
    }

    public static void remove(File repositoryDir, IlrPath path) throws PrivilegedActionException {
        File ruleAppDir = new File(repositoryDir, path.getRuleAppName());
        File versionDir = new File(ruleAppDir, path.getRuleAppVersion().toString());
        if (!IlrDeletePrivilegedAction.execute(versionDir)) {
            throw new PrivilegedActionException(new IlrDAOException(RESOURCE_BUNDLE_NAME, IlrDAOLocalization.ERROR_CANNOT_DELETE_DIRECTORY, new String[]{versionDir.getAbsolutePath()}));
        }
        File[] files = IlrListFilesPrivilegedAction.execute(ruleAppDir, null);
        if (!(files != null && files.length != 0 || IlrDeletePrivilegedAction.execute(ruleAppDir))) {
            throw new PrivilegedActionException(new IlrDAOException(RESOURCE_BUNDLE_NAME, IlrDAOLocalization.ERROR_CANNOT_DELETE_DIRECTORY, new String[]{ruleAppDir.getAbsolutePath()}));
        }
    }

    public static Map<String, String> getProperties(File repositoryDir, IlrPath path) throws IOException {
        File ruleAppDir = IlrRuleAppDir.getDir(repositoryDir, path.getRuleAppName(), path.getRuleAppVersion());
        if (ruleAppDir != null) {
            Properties props = IlrFile.getProperties(new File(ruleAppDir, "properties.txt"));
            HashMap<String, String> result = new HashMap<String, String>(props.size());
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
            return result;
        }
        return null;
    }

    public static boolean setDisplayName(File repositoryDir, String name, IlrVersion version, String displayName) throws PrivilegedActionException, IOException {
        File ruleAppDir = IlrRuleAppDir.getDir(repositoryDir, name, version);
        if (ruleAppDir != null) {
            IlrFile.setContent(new File(ruleAppDir, "display_name.txt"), displayName);
            return true;
        }
        return false;
    }

    public static boolean setDescription(File repositoryDir, String name, IlrVersion version, String description) throws PrivilegedActionException, IOException {
        File ruleAppDir = IlrRuleAppDir.getDir(repositoryDir, name, version);
        if (ruleAppDir != null) {
            IlrFile.setContent(new File(ruleAppDir, "description.txt"), description);
            return true;
        }
        return false;
    }

    public static boolean setProperty(File repositoryDir, IlrPath path, String key, String value) throws PrivilegedActionException, IOException {
        File ruleAppDir = IlrRuleAppDir.getDir(repositoryDir, path.getRuleAppName(), path.getRuleAppVersion());
        if (ruleAppDir != null) {
            File propertiesFile = new File(ruleAppDir, "properties.txt");
            Properties props = IlrFile.getProperties(propertiesFile);
            if (value == null) {
                props.remove(key);
            } else {
                props.put(key, value);
            }
            IlrFile.setProperties(propertiesFile, props);
            return true;
        }
        return false;
    }

    public static boolean setProperties(File repositoryDir, String name, IlrVersion version, IlrReadOnlyProperties props) throws PrivilegedActionException, IOException {
        File ruleAppDir = IlrRuleAppDir.getDir(repositoryDir, name, version);
        if (ruleAppDir != null) {
            IlrFile.setProperties(new File(ruleAppDir, "properties.txt"), props);
            return true;
        }
        return false;
    }

    public static class RuleAppItem {
        private final File ruleAppDir;
        private final IlrMutableRuleAppInformation ruleApp;

        private RuleAppItem(File ruleAppDir, IlrMutableRuleAppInformation ruleApp) {
            this.ruleAppDir = ruleAppDir;
            this.ruleApp = ruleApp;
        }

        public File getRuleAppDir() {
            return this.ruleAppDir;
        }

        public IlrMutableRuleAppInformation getRuleApp() {
            return this.ruleApp;
        }
    }
}

