/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.file.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class IlrFileInputStreamPrivilegedAction
implements PrivilegedAction<FileInputStream> {
    private final File file;

    private IlrFileInputStreamPrivilegedAction(File file) {
        this.file = file;
    }

    @Override
    public FileInputStream run() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static FileInputStream execute(File file) {
        return AccessController.doPrivileged(new IlrFileInputStreamPrivilegedAction(file));
    }
}

